local M = {}

local htmlTexture = require('htmlTexture')

M.autosave = true

local saveInterval = 60
local saveAccumulator = 0
local value = 0

local function getSaveFilePath()
    local vehicleFolder = string.sub(v.vehicleDirectory,10,-2)
    return "settings/" .. vehicleFolder .. ".save.json"
end

local function getSaveVersion()
    return 1.01
end

local function serialize()
    local serializedData = {}

    serializedData.version = getSaveVersion()
    serializedData.value = value

    return serializedData
end

local function deserialize(serializedData)
    if serializedData.version ~= getSaveVersion() then return end

    value = serializedData.value
end

local function saveOdometer(checkFileFirst)
    checkFileFirst = checkFileFirst or true

    if checkFileFirst then
        local serializedData = jsonReadFile(getSaveFilePath())

        if serializedData ~= nil then
            if serializedData.version ~= getSaveVersion() then
                --bad
            else
                local diff = math.abs(value - serializedData.value)

                if serializedData.value > value or diff < 0.001 then
                    return
                end
            end
        end
    end

    jsonWriteFile(getSaveFilePath(), serialize(), true)
end

local function loadOdometer()
    local serializedData = jsonReadFile(getSaveFilePath())

    if serializedData ~= nil then deserialize(serializedData) end
end

local function getIsEngineRunning()
    return (electrics.values["engineRunning"] or 0) > 0.5
end

local function getGear()
    return electrics.values.gearIndex or 1
end

local function isNaN(v) return type(v) == "number" and v ~= v end

local function getValue()
    return value
end

local function setValue(val)
    value = val
 end

local function init()
    loadOdometer()
end

local function updateGFX(dt)
    if M.autosave then
        saveAccumulator = saveAccumulator + dt

        if saveAccumulator >= saveInterval then
            saveOdometer()
            saveAccumulator = 0
        end
    end

    local speedMin = 0.5
    local speedMax = 600

    if not electrics.values["odo"] then
        electrics.values["odo"] = value
    end

    if getIsEngineRunning() and getGear() ~= 0 then
        local curSpeed = electrics.values["wheelspeed"] or 0
        if isNaN(curSpeed) then return end

        if curSpeed > speedMin and curSpeed < speedMax then
            value = value + ((curSpeed * dt) * 0.001)
            electrics.values["odo"] = value
        end
    end

    htmlTexture.call('@fortuner_gauge_screen', 'odometerUpdate', electrics.values["odo"])
end

M.setValue = setValue
M.getValue = getValue
M.saveOdometer = saveOdometer
M.init = init
M.updateGFX = updateGFX

return M