-- Written by Miata lover
-- Do not reuse/modify without permission!
local M = {}

local timer = 0
local timerR = 0
local wiperState = 0
local wiperStateR = 0
local wiperSleep = 0
local spd = 0
local spdR = 0
local ignitionIndependent
local hasRearWiper
local wiperOffset
local wipersNode
local wipersSound = false

local function init(jbeamData)
  electrics.values.wiperVal = 0
  electrics.values.wiperVal2 = 0
  electrics.values.wiperValR = 0
  electrics.values.wipers = 0
  wiperState = 0
  wiperStateR = 0
  spd = 0
  spdR = 0
  ignitionIndependent = jbeamData.ignitionIndependent or false
  hasRearWiper = jbeamData.hasRearWiper or false
  wiperOffset = jbeamData.wiperOffset or nil
  wipersNode = jbeamData.wipersNode

  for v, n in pairs(v.data.nodes) do
    if n.name == wipersNode then
      wipersNode = v
      break
    end
  end
  
  if wipersNode == jbeamData.wipersNode then
    log("W", "controller.animatedWipers", "failed to find node: " .. wipersNode .. ". Using RefNode Instead.") 
    wipersNode = v.data.refNodes[0].ref
  end
end

local function reset()
  electrics.values.wiperVal = 0
  electrics.values.wiperVal2 = 0
  electrics.values.wiperValR = 0
  electrics.values.wipers = 0
  wiperState = 0
  wiperStateR = 0
  spd = 0
  spdR = 0
end

local function updateGFX(dt)
  if wiperState ~= 0 and electrics.values.wiperVal == 0 and timer >= wiperSleep and electrics.values.ignitionLevel ~= 0 then
    if not wipersSound then
      obj:createSFXSource("art/sound/wiper.mp3", "AudioDefault3D", "wiperSound", wipersNode, 0)
      wipersSound = true
    end
    obj:playSFXOnce("wiperSound", wipersNode, 1, 1)
    spd = 1
    timer = 0
  elseif electrics.values.wiperVal > 0.1 and electrics.values.wiperVal < 0.9 and spd == 1 then
    spd = 1.5
  elseif electrics.values.wiperVal > 1 then
    spd = -1
  elseif electrics.values.wiperVal > 0.9 and spd == 1.5 then
    spd = 1
  elseif electrics.values.wiperVal < 0.9 and electrics.values.wiperVal > 0.1 and spd == -1 then
    spd = -1.5
  elseif electrics.values.wiperVal < 0.1 and spd == -1.5 then
    spd = -1
  elseif electrics.values.wiperVal < 0 then
    electrics.values.wiperVal = 0
    spd = 0
    timer = 0
  end
  
  if hasRearWiper then
    if wiperStateR ~= 0 and electrics.values.wiperValR == 0 and timerR >= 1 and electrics.values.ignitionLevel ~= 0 then
      if not wipersSound then
        obj:createSFXSource("art/sound/wiper.mp3", "AudioDefault3D", "wiperSound", wipersNode, 0)
        wipersSound = true
      end
      obj:playSFXOnce("wiperSound", wipersNode, 1, 0.7)
      spdR = 0.7
      timerR = 0
    elseif electrics.values.wiperValR > 0.1 and electrics.values.wiperValR < 0.9 and spdR == 0.7 then
      spdR = 1
    elseif electrics.values.wiperValR > 1 then
      spdR = -0.7
    elseif electrics.values.wiperValR > 0.9 and spdR == 1 then
      spdR = 0.7
    elseif electrics.values.wiperValR < 0.9 and electrics.values.wiperValR > 0.1 and spdR == -0.7 then
      spdR = -1
    elseif electrics.values.wiperValR < 0.1 and spdR == -1 then
      spdR = -0.7
    elseif electrics.values.wiperValR < 0 then
      electrics.values.wiperValR = 0
      spdR = 0
    end
  end

  if electrics.values.ignitionLevel ~= 0 or ignitionIndependent == true then
    electrics.values.wiperVal = electrics.values.wiperVal + (dt * spd)
    electrics.values.wiperValR = electrics.values.wiperValR + (dt * spdR)
    if wiperOffset then electrics.values.wiperVal2 = electrics.values.wiperVal + wiperOffset end
  end

  timer = timer + dt
  timerR = timerR + dt
end

local function toggleMode()
  if wiperState == 0 then
    wiperState = 1
    wiperSleep = 3
    timer = wiperSleep
    gui.message("Wipers: Slow", 2, "wiperMsg")
  elseif wiperState == 1 then
	wiperState = 2
    wiperSleep = 0.02
    gui.message("Wipers: Fast", 2, "wiperMsg")
  else
	wiperState = 0
    gui.message("Wipers: Off", 2, "wiperMsg")
  end
  electrics.values.wipers = wiperState / 2
end

local function toggleModeR()
  if hasRearWiper then
    if wiperStateR == 0 then
      wiperStateR = 1
      gui.message("Rear Wiper: On", 2, "wiperMsgR")
    else
      wiperStateR = 0
      gui.message("Rear Wiper: Off", 2, "wiperMsgR")
    end
  end
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX
M.toggleMode = toggleMode
M.toggleModeR = toggleModeR
return M