-- lua, cluster screen, gps screen and climate screen by ThatTonybo
local M = {}

local htmlTexture = require('htmlTexture')

M.type = 'auxiliary'
M.relevantDevice = nil

local hasSentMapData = false

local function initMap()
    hasSentMapData = false

	obj:queueGameEngineLua("extensions.load('ui/uinavi')")
	obj:queueGameEngineLua(string.format('extensions.ui_uinavi.requestVehicleDashboardMap(%q)', '@fortuner_navi_screens'))
	
	hasSentMapData = true
end

local function updateMap()
    if hasSentMapData then
		local zoomMult = 1 - (1 * 0.1)
		
        local pos = obj:getPosition()
		local rotation = math.deg(obj:getDirection()) + 180
		local speed = electrics.values.airspeed * 3.6
        local zoom = math.min(300 + speed * 1.5, 500)
	
		local data = { x = pos.x, y = pos.y, rotation = rotation, zoom = zoom, zoomMult = zoomMult }

		htmlTexture.call("@fortuner_navi_screens", "map.updateData", data)
	end	
end

local function sendServiceStatus(status)
	htmlTexture.call("@fortuner_gauge_screen", "serviceStatusUpdate", { serviceRequired = status })
end

-- credit to Zeit
-- modified a little to suit this use case
local function requestServiceStatus()
	for _, device in pairs (powertrain.getDevices()) do
	  	if damageTracker.getDamage("powertrain", tostring(device.name)) then
			return sendServiceStatus(true)
	  	end
	end

	for _, storage in pairs (energyStorage.getStorages()) do
	  	if damageTracker.getDamage("energyStorage", tostring(storage.name)) then
			return sendServiceStatus(true)
	  	end
	end
  
	if damageTracker.getDamage("engine", "oilpanLeak") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "oilRadiatorLeak") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "headGasketDamaged") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "pistonRingsDamaged") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "rogBearingsDamaged") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "blockMelted") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "cylinderWallsMelted") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "radiatorLeak") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "exhaustBroken") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "inductionSystemDamaged") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "superchargerDamaged") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "turbochargerDamaged") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "engineTorqueReduced") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "impactDamage") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "catastrophicOverrevDamaged") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "mildOverrevDamage") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "engineDisabled") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "engineLockedUp") then return sendServiceStatus(true)
	elseif damageTracker.getDamage("engine", "energyStorage") then return sendServiceStatus(true)
	end

	return sendServiceStatus(false)
end

M.initMap = initMap
M.updateMap = updateMap
M.requestServiceStatus = requestServiceStatus
M.init = nop
M.updateGFX = nop

fortuner_screens = M

return M