-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local floor = math.floor
local max = math.max
local min = math.min
local abs = math.abs

local rpmToAV = 0.104719755
local avToRPM = 9.5493

M.isExisting = true
M.isArmed = false
M.isActive1 = false
M.isActive2 = false
M.isActive3 = false
M.isActive4 = false
M.isActive5 = false
M.isActive6 = false

local assignedEngine = nil
local nitrousOxideTorqueLookup1 = nil
local nitrousOxideOverrideTorqueLookup1 = nil
local nitrousOxideTorqueLookup2 = nil
local nitrousOxideOverrideTorqueLookup2 = nil
local nitrousOxideTorqueLookup3 = nil
local nitrousOxideOverrideTorqueLookup3 = nil
local nitrousOxideTorqueLookup4 = nil
local nitrousOxideOverrideTorqueLookup4 = nil
local nitrousOxideTorqueLookup5 = nil
local nitrousOxideOverrideTorqueLookup5 = nil
local nitrousOxideTorqueLookup6 = nil
local nitrousOxideOverrideTorqueLookup6 = nil
local noArmName = nil
local noOverrideName = nil
local noActiveName = nil
local minimumGear1 = nil
local minimumGear2 = nil
local minimumGear3 = nil
local minimumGear4 = nil
local minimumGear5 = nil
local minimumGear6 = nil
local volumeCoef = nil

local n2oActive1 = false
local n2oActive2 = false
local n2oActive3 = false
local n2oActive4 = false
local n2oActive5 = false
local n2oActive6 = false
local cutInRPM1 = nil
local cutInRPM2 = nil
local cutInRPM3 = nil
local cutInRPM4 = nil
local cutInRPM5 = nil
local cutInRPM6 = nil

local purgeActiveTime = 0
local purgeParticleTick = 0
local purgeValveNodes = nil

local storageWithEnergyCounter = 0
local registeredEnergyStorages = {}
local previousEnergyLevels = {}
local hasLiquid = true
local energyStorageRatios = {}

local function updateSounds(dt)
end

local function purgeLines(purgeTime)
  purgeActiveTime = (#purgeValveNodes > 0 and hasLiquid) and purgeTime or 0
end

local function getTankRatio()
  local ratio = 0
  local counter = 0
  for _, s in pairs(registeredEnergyStorages) do
    local storage = energyStorage.getStorage(s)
    if storage then
      ratio = ratio + storage.remainingRatio
      counter = counter + 1
    end
  end
  ratio = counter > 0 and ratio / counter or 0
  return ratio
end

local function updateEnergyStorageRatios()
  for _, s in pairs(registeredEnergyStorages) do
    local storage = energyStorage.getStorage(s)
    if storage then
      if storage.storedEnergy > 0 then
        energyStorageRatios[storage.name] = 1 / storageWithEnergyCounter
      else
        energyStorageRatios[storage.name] = 0
      end
    end
  end
end

local function updateFuelUsage()
  if not n2oActive1 then
    return
  end

  local hasLiquidTmp = false
  local previousTankCount = storageWithEnergyCounter
  for _, s in pairs(registeredEnergyStorages) do
    local storage = energyStorage.getStorage(s)
    if storage then
      local previous = previousEnergyLevels[storage.name]
      storage.storedEnergy = max(storage.storedEnergy - (assignedEngine.spentEnergyNitrousOxide * energyStorageRatios[storage.name]), 0)
      if previous > 0 and storage.storedEnergy <= 0 then
        storageWithEnergyCounter = storageWithEnergyCounter - 1
      elseif previous <= 0 and storage.storedEnergy > 0 then
        storageWithEnergyCounter = storageWithEnergyCounter + 1
      end
      previousEnergyLevels[storage.name] = storage.storedEnergy
    end

    hasLiquidTmp = hasLiquidTmp or (storage and storage.storedEnergy > 0 or false)
  end
  if previousTankCount ~= storageWithEnergyCounter then
    updateEnergyStorageRatios()
  end

  hasLiquid = hasLiquidTmp
end

local function updateGFX(dt)
  if assignedEngine.engineDisabled then
    M.updateGFX = nop
    M.isArmed = false
    M.isActive1 = false
    M.isActive2 = false
    M.isActive3 = false
    M.isActive4 = false
    M.isActive5 = false
    M.isActive6 = false
    return
  end

  updateFuelUsage()

  local purgeActive = purgeActiveTime > 0
  if purgeActive then
    purgeParticleTick = purgeParticleTick + dt
    if purgeParticleTick > 0.02 then
      for _, v in ipairs(purgeValveNodes) do
        obj:addParticleByNodesRelative(v.cid1, v.cid2, -2, 70, 0, 1)
        obj:addParticleByNodesRelative(v.cid1, v.cid2, -4, 71, 0, 1)
        obj:addParticleByNodesRelative(v.cid1, v.cid2, -8, 72, 0, 1)
      end
      purgeParticleTick = 0
    end
    purgeActiveTime = purgeActiveTime - dt
  end

  local manualOverride = (electrics.values[noOverrideName] or 0) >= 1
  local isArmed = (electrics.values[noArmName] or 0) >= 1
  local engineRPM = floor(assignedEngine.outputAV1 * avToRPM)
  local rpmHighEnough1 = engineRPM >= cutInRPM1
  local rpmHighEnough2 = engineRPM >= cutInRPM2
  local rpmHighEnough3 = engineRPM >= cutInRPM3
  local rpmHighEnough4 = engineRPM >= cutInRPM4
  local rpmHighEnough5 = engineRPM >= cutInRPM5
  local rpmHighEnough6 = engineRPM >= cutInRPM6
  local hasEnoughThrottle = assignedEngine.throttle >= 1
  local isGearHighEnough1 = abs(electrics.values.gearIndex) >= minimumGear1
  local isGearHighEnough2 = abs(electrics.values.gearIndex) >= minimumGear2
  local isGearHighEnough3 = abs(electrics.values.gearIndex) >= minimumGear3
  local isGearHighEnough4 = abs(electrics.values.gearIndex) >= minimumGear4
  local isGearHighEnough5 = abs(electrics.values.gearIndex) >= minimumGear5
  local isGearHighEnough6 = abs(electrics.values.gearIndex) >= minimumGear6
  local clutchNotUsed = (electrics.values.clutch or 0) == 0
  local shouldUseN2o1 = (isArmed and hasEnoughThrottle and rpmHighEnough1 and isGearHighEnough1 and clutchNotUsed) or manualOverride
  local shouldUseN2o2 = (isArmed and hasEnoughThrottle and rpmHighEnough2 and isGearHighEnough2 and clutchNotUsed) or manualOverride
  local shouldUseN2o3 = (isArmed and hasEnoughThrottle and rpmHighEnough3 and isGearHighEnough3 and clutchNotUsed) or manualOverride
  local shouldUseN2o4 = (isArmed and hasEnoughThrottle and rpmHighEnough4 and isGearHighEnough4 and clutchNotUsed) or manualOverride
  local shouldUseN2o5 = (isArmed and hasEnoughThrottle and rpmHighEnough5 and isGearHighEnough5 and clutchNotUsed) or manualOverride
  local shouldUseN2o6 = (isArmed and hasEnoughThrottle and rpmHighEnough6 and isGearHighEnough6 and clutchNotUsed) or manualOverride

  n2oActive1 = shouldUseN2o1 and hasLiquid and not purgeActive
  n2oActive2 = shouldUseN2o2 and hasLiquid and not purgeActive
  n2oActive3 = shouldUseN2o3 and hasLiquid and not purgeActive
  n2oActive4 = shouldUseN2o4 and hasLiquid and not purgeActive
  n2oActive5 = shouldUseN2o5 and hasLiquid and not purgeActive
  n2oActive6 = shouldUseN2o6 and hasLiquid and not purgeActive

  local torqueLookup1 = manualOverride and nitrousOxideOverrideTorqueLookup1 or nitrousOxideTorqueLookup1
  local torqueLookup2 = manualOverride and nitrousOxideOverrideTorqueLookup2 or nitrousOxideTorqueLookup2
  local torqueLookup3 = manualOverride and nitrousOxideOverrideTorqueLookup3 or nitrousOxideTorqueLookup3
  local torqueLookup4 = manualOverride and nitrousOxideOverrideTorqueLookup4 or nitrousOxideTorqueLookup4
  local torqueLookup5 = manualOverride and nitrousOxideOverrideTorqueLookup5 or nitrousOxideTorqueLookup5
  local torqueLookup6 = manualOverride and nitrousOxideOverrideTorqueLookup6 or nitrousOxideTorqueLookup6

  local noTorque1 = n2oActive1 and torqueLookup1[engineRPM] or 0
  local noTorque2 = n2oActive2 and torqueLookup2[engineRPM] or 0
  local noTorque3 = n2oActive3 and torqueLookup3[engineRPM] or 0
  local noTorque4 = n2oActive4 and torqueLookup4[engineRPM] or 0
  local noTorque5 = n2oActive5 and torqueLookup5[engineRPM] or 0
  local noTorque6 = n2oActive6 and torqueLookup6[engineRPM] or 0

  M.isArmed = isArmed
  M.isActive1 = n2oActive1 and 1 or 0
  M.isActive2 = n2oActive2 and 1 or 0
  M.isActive3 = n2oActive3 and 1 or 0
  M.isActive4 = n2oActive4 and 1 or 0
  M.isActive5 = n2oActive5 and 1 or 0
  M.isActive6 = n2oActive6 and 1 or 0

  electrics.values[noActiveName] = n2oActive1
  electrics.values[noActiveName] = n2oActive2
  electrics.values[noActiveName] = n2oActive3
  electrics.values[noActiveName] = n2oActive4
  electrics.values[noActiveName] = n2oActive5
  electrics.values[noActiveName] = n2oActive6

  --assignedEngine.continuousAfterFireFuel = assignedEngine.continuousAfterFireFuel + (n2oActive and 100 * dt or 0)
  assignedEngine.nitrousOxideTorque = assignedEngine.nitrousOxideTorque + noTorque1 + noTorque2 + noTorque3 + noTorque4 + noTorque5 + noTorque6
  assignedEngine.engineVolumeCoef = assignedEngine.engineVolumeCoef * (noTorque1 > 0 and volumeCoef or 1)
  assignedEngine.invBurnEfficiencyCoef = assignedEngine.invBurnEfficiencyCoef * (n2oActive1 and 2 or 1)
end

local function registerStorage(storageName)
  local storage = energyStorage.getStorage(storageName)
  if storage and storage.storedEnergy > 0 then
    storageWithEnergyCounter = storageWithEnergyCounter + 1
    table.insert(registeredEnergyStorages, storageName)
    updateEnergyStorageRatios()
  end
  hasLiquid = true
  previousEnergyLevels[storageName] = storage.storedEnergy
end

local function reset()
  M.isArmed = false
  M.isActive1 = false
  M.isActive2 = false
  M.isActive3 = false
  M.isActive4 = false
  M.isActive5 = false
  M.isActive6 = false

  n2oActive1 = false
  n2oActive2 = false
  n2oActive3 = false
  n2oActive4 = false
  n2oActive5 = false
  n2oActive6 = false

  purgeActiveTime = 0

  storageWithEnergyCounter = 0
  registeredEnergyStorages = {}
  previousEnergyLevels = {}
  hasLiquid = true
  energyStorageRatios = {}
end

local function init(device, data)
  M.isArmed = false
  M.isActive1 = false
  M.isActive2 = false
  M.isActive3 = false
  M.isActive4 = false
  M.isActive5 = false
  M.isActive6 = false

  if data == nil then
    M.updateGFX = nop
    return
  end

  assignedEngine = device

  nitrousOxideTorqueLookup1 = {}
  nitrousOxideOverrideTorqueLookup1 = {}
  nitrousOxideTorqueLookup2 = {}
  nitrousOxideOverrideTorqueLookup2 = {}
  nitrousOxideTorqueLookup3 = {}
  nitrousOxideOverrideTorqueLookup3 = {}
  nitrousOxideTorqueLookup4 = {}
  nitrousOxideOverrideTorqueLookup4 = {}
  nitrousOxideTorqueLookup5 = {}
  nitrousOxideOverrideTorqueLookup5 = {}
  nitrousOxideTorqueLookup6 = {}
  nitrousOxideOverrideTorqueLookup6 = {}
  local addedPower1 = (tonumber(data.addedPower1 or 0)) * 1000
  local addedPower2 = (tonumber(data.addedPower2 or 0)) * 1000
  local addedPower3 = (tonumber(data.addedPower3 or 0)) * 1000
  local addedPower4 = (tonumber(data.addedPower4 or 0)) * 1000
  local addedPower5 = (tonumber(data.addedPower5 or 0)) * 1000
  local addedPower6 = (tonumber(data.addedPower6 or 0)) * 1000
  cutInRPM1 = min(max(tonumber(data.cutInRPM1) or assignedEngine.idleRPM, 1), assignedEngine.maxRPM * 0.9)
  cutInRPM2 = min(max(tonumber(data.cutInRPM2) or assignedEngine.idleRPM, 1), assignedEngine.maxRPM * 0.9)
  cutInRPM3 = min(max(tonumber(data.cutInRPM3) or assignedEngine.idleRPM, 1), assignedEngine.maxRPM * 0.9)
  cutInRPM4 = min(max(tonumber(data.cutInRPM4) or assignedEngine.idleRPM, 1), assignedEngine.maxRPM * 0.9)
  cutInRPM5 = min(max(tonumber(data.cutInRPM5) or assignedEngine.idleRPM, 1), assignedEngine.maxRPM * 0.9)
  cutInRPM6 = min(max(tonumber(data.cutInRPM6) or assignedEngine.idleRPM, 1), assignedEngine.maxRPM * 0.9)

  local cutInRange = data.cutInRange or 50
  local invCutInRange = 1 / cutInRange
  local cutInStart1 = cutInRPM1 - cutInRange
  local cutInStart2 = cutInRPM2 - cutInRange
  local cutInStart3 = cutInRPM3 - cutInRange
  local cutInStart4 = cutInRPM4 - cutInRange
  local cutInStart5 = cutInRPM5 - cutInRange
  local cutInStart6 = cutInRPM6 - cutInRange
  for i = 1, assignedEngine.maxRPM * 2, 1 do
  local adjustedAddedPower1 = min(max(addedPower1 * (i - cutInStart1) * invCutInRange, 0), addedPower1)
  nitrousOxideTorqueLookup1[i + 1] = adjustedAddedPower1 * 0.7457 / (i * rpmToAV) -- 1 horsepower = 0.7457 watts
  nitrousOxideOverrideTorqueLookup1[i + 1] = addedPower1 * 0.7457 / (i * rpmToAV)

  local adjustedAddedPower2 = min(max(addedPower2 * (i - cutInStart2) * invCutInRange, 0), addedPower2)
  nitrousOxideTorqueLookup2[i + 1] = adjustedAddedPower2 * 0.7457 / (i * rpmToAV)
  nitrousOxideOverrideTorqueLookup2[i + 1] = addedPower2 * 0.7457 / (i * rpmToAV)

  local adjustedAddedPower3 = min(max(addedPower3 * (i - cutInStart3) * invCutInRange, 0), addedPower3)
  nitrousOxideTorqueLookup3[i + 1] = adjustedAddedPower3 * 0.7457 / (i * rpmToAV)
  nitrousOxideOverrideTorqueLookup3[i + 1] = addedPower3 * 0.7457 / (i * rpmToAV)

  local adjustedAddedPower4 = min(max(addedPower4 * (i - cutInStart4) * invCutInRange, 0), addedPower4)
  nitrousOxideTorqueLookup4[i + 1] = adjustedAddedPower4 * 0.7457 / (i * rpmToAV)
  nitrousOxideOverrideTorqueLookup4[i + 1] = addedPower4 * 0.7457 / (i * rpmToAV)

  local adjustedAddedPower5 = min(max(addedPower5 * (i - cutInStart5) * invCutInRange, 0), addedPower5)
  nitrousOxideTorqueLookup5[i + 1] = adjustedAddedPower5 * 0.7457 / (i * rpmToAV)
  nitrousOxideOverrideTorqueLookup5[i + 1] = addedPower5 * 0.7457 / (i * rpmToAV)

  local adjustedAddedPower6 = min(max(addedPower6 * (i - cutInStart6) * invCutInRange, 0), addedPower6)
  nitrousOxideTorqueLookup6[i + 1] = adjustedAddedPower6 * 0.7457 / (i * rpmToAV)
  nitrousOxideOverrideTorqueLookup6[i + 1] = addedPower6 * 0.7457 / (i * rpmToAV)
end


  noArmName = data.electricsArmName or "nitrousOxideArm"
  noOverrideName = data.electricsOverrideName or "nitrousOxideOverride"
  noActiveName = data.electricsActiveName or "nitrousOxideActive"
  minimumGear1 = tonumber(data.minimumGear1) or 0
  minimumGear2 = tonumber(data.minimumGear2) or 0
  minimumGear3 = tonumber(data.minimumGear3) or 0
  minimumGear4 = tonumber(data.minimumGear4) or 0
  minimumGear5 = tonumber(data.minimumGear5) or 0
  minimumGear6 = tonumber(data.minimumGear6) or 0
  volumeCoef = data.volumeCoef or 1.5

  n2oActive1 = false
  n2oActive2 = false
  n2oActive3 = false
  n2oActive4 = false
  n2oActive5 = false
  n2oActive6 = false

  purgeActiveTime = 0
  purgeValveNodes = {}
  local valveNodes = data.purgeValves_nodes or {}
  local valveCount = #valveNodes - (#valveNodes % 2)
  for i = 1, valveCount, 2 do
    local cid1 = valveNodes[i]
    local cid2 = valveNodes[i + 1]
    if type(cid1) == "number" and type(cid2) == "number" then
      table.insert(purgeValveNodes, {cid1 = cid1, cid2 = cid2})
    end
  end

  storageWithEnergyCounter = 0
  registeredEnergyStorages = {}
  previousEnergyLevels = {}
  hasLiquid = true
  energyStorageRatios = {}

  M.updateGFX = updateGFX
  M.updateSounds = updateSounds
end

local function initSounds()
end

local function resetSounds()
end

local function getAddedTorque()
  local addedTorque = {}
  for k, _ in pairs(assignedEngine.torqueCurve) do
    if type(k) == "number" and k < assignedEngine.maxRPM then
      local rpm = floor(k)
      addedTorque[k + 1] = nitrousOxideTorqueLookup1[rpm] or 0
    end
  end
  return addedTorque
end

-- public interface
M.init = init
M.initSounds = initSounds
M.updateSounds = nop
M.reset = reset
M.resetSounds = resetSounds
M.updateGFX = nop
M.getAddedTorque = getAddedTorque
M.registerStorage = registerStorage
M.getTankRatio = getTankRatio
M.purgeLines = purgeLines

return M
