local M = {}

-- رقم الكفر
local wheelIndex = 1

-- إعدادات التخفيف
local transitionSpeed = 140 -- km/h
local slowdownFactor = 1.8

-- معامل التنعيم: كل ما زاد، كانت الإبرة أبطأ
local smoothingFactor = 0.15

-- القيمة السابقة (نبدأها بـ 0)
local smoothedSpeed = 0

local function updateGFX(dt)
    local wheelsTable = wheels.wheels
    if not wheelsTable or not wheelsTable[wheelIndex] then return end

    local wheel = wheelsTable[wheelIndex]
    local angularVelocity = wheel.angularVelocity or 0
    local radius = wheel.radius or 0.3

    local linearSpeed = angularVelocity * radius
    local rawSpeed = math.abs(linearSpeed * 3.6)

    -- نطبق التخفيف بعد transitionSpeed
    local adjustedSpeed
    if rawSpeed <= transitionSpeed then
        adjustedSpeed = rawSpeed
    else
        local excess = rawSpeed - transitionSpeed
        adjustedSpeed = transitionSpeed + (excess * slowdownFactor)
    end

    -- تنعيم السرعة باستخدام LERP (تدريج بين القيمة القديمة والجديدة)
    smoothedSpeed = smoothedSpeed + (adjustedSpeed - smoothedSpeed) * smoothingFactor

    -- نكتب القيمة في electrics
    electrics.values.gauge1 = smoothedSpeed
end

M.updateGFX = updateGFX
return M
