local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local maxGear
local minGear
local minRPM = 0
local maxRPM = 0
local multi = 0

local function updateGFX(dt)
   if maxRPM < 6000 then
	multi = 0.75
   else
	multi = 1
   end
   if electrics.values.throttle >= 0 and electrics.values.throttle < 0.2 then
	electrics.values.rpmlimit_up = 999999
	electrics.values.rpmlimit_down = -1
   elseif electrics.values.throttle >= 0.2 and electrics.values.throttle < 0.4 then
	electrics.values.rpmlimit_up = 2000 * multi
	electrics.values.rpmlimit_down = 1000 * multi
   elseif electrics.values.throttle >= 0.4 and electrics.values.throttle < 0.6 then
	electrics.values.rpmlimit_up = 3000 * multi
	electrics.values.rpmlimit_down = 1500 * multi 
   elseif electrics.values.throttle >= 0.6 and electrics.values.throttle < 0.8 then
	electrics.values.rpmlimit_up = 4000 * multi   
	electrics.values.rpmlimit_down = 2000 * multi   
   elseif electrics.values.throttle >= 0.8 and electrics.values.throttle < 1 then
	electrics.values.rpmlimit_up = 5000 * multi
	electrics.values.rpmlimit_down = 2500 * multi
   elseif electrics.values.throttle == 1 then
    electrics.values.rpmlimit_up = 6000 * multi
    electrics.values.rpmlimit_down = 3000 * multi
   end
	   if electrics.values.gear > 1 and electrics.values.gear < maxGear  then
			if electrics.values.rpm >= electrics.values.rpmlimit_up then
				electrics.values.shiftlight_up = 1
				electrics.values.shiftlight_down = 0
			elseif electrics.values.rpm >= electrics.values.rpmlimit_down and electrics.values.rpm < electrics.values.rpmlimit_up then
				electrics.values.shiftlight_up = 0
				electrics.values.shiftlight_down = 0
			else
				electrics.values.shiftlight_up = 0
				electrics.values.shiftlight_down = 1
			end
		elseif electrics.values.gear == 1 then
			electrics.values.shiftlight_down = 0
			if electrics.values.rpm >= electrics.values.rpmlimit_up then
				electrics.values.shiftlight_up = 1
			else
				electrics.values.shiftlight_up = 0
			end
		elseif electrics.values.gear == maxGear then
			electrics.values.shiftlight_up = 0
			if electrics.values.rpm <= electrics.values.rpmlimit_down then
				electrics.values.shiftlight_down = 1
			else
				electrics.values.shiftlight_down = 0
			end
		else
			electrics.values.shiftlight_up = 0
			electrics.values.shiftlight_down = 0
		end
end

local function init(jbeamData)
  maxRPM = 7000
  local rpmRange = jbeamData.rpmRange or 3000
  local gearbox = powertrain.getDevice("gearbox")
  if gearbox then
	maxGear = gearbox.maxGearIndex
	minGear = gearbox.minGearIndex
	if gearbox.type == "automaticGearbox" or gearbox.type == "cvtGearbox" then
		M.updateGFX = nop
	end
  else
	M.updateGFX = nop
  end
  if jbeamData.engineName and jbeamData.maxEngineRPMOffset then
    local engine = powertrain.getDevice(jbeamData.engineName)
    if engine then
      maxRPM = engine.maxRPM - jbeamData.maxEngineRPMOffset
    end
  end
  maxRPM = jbeamData.maxRPM or maxRPM
  minRPM = maxRPM - rpmRange
  minRPM = jbeamData.minRPM or minRPM
end

M.init = init
M.updateGFX = updateGFX

return M
