--Created by Inn0centJok3r
--DO NOT USE WITHOUT PERMISSION! ASK ME AT https://www.beamng.com/members/inn0centjok3r.318168/
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local gaugesScreenName = nil
local htmlPath = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS

local timerSlowTraffic = 0
local mileMoney = 0
local slowMoney = 0
local speedMin = 0.2
local speedMax = 600 --m/s, too fast, might be an instability
local milesDriven = 0
local timeOfDay = 0
local dayOfYear = 0
local weekDay = false
local initialMoney = 0
local guiMsgMoney = 0

local milecalcMoney = 0
local slowcalcMoney = 0

local mileinputMoney = 0
local slowinputMoney = 0
local initialinputMoney = 0

local function addMileMoney()
	milecalcMoney = milecalcMoney + mileinputMoney --money values here are in cents to make numbers align with screen background
end

local function addSlowMoney()
	slowcalcMoney = slowcalcMoney + slowinputMoney 
end

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS then
    local data = {}
	
		--data.statusTaxi = "HIRED"
		data.rateTaxi = 1
	
	if electrics.values["wheelspeed"] == nil then
		data.fareTaxi = initialinputMoney
		data.extrasTaxi = "050"
		
		guiMsgMoney = (tonumber(data.fareTaxi) + data.extrasTaxi) / 100
		
    htmlTexture.call(gaugesScreenName, "updateData", data)
    updateTimer = 0
	return
	end

	if electrics.values["wheelspeed"] <= 2.777 and electrics.values["wheelspeed"] >= -0.1388 then --below 10km/h and above -0.5km/h

		timerSlowTraffic = timerSlowTraffic + dt
		if timerSlowTraffic >= 60 then			--1 minute of "slow or stopped traffic"
		addSlowMoney()
		timerSlowTraffic = 0
		end
	end	
	
    if electrics.values["wheelspeed"] > speedMin and electrics.values["wheelspeed"] < speedMax then
      milesDriven = milesDriven + ((electrics.values["wheelspeed"] * dt) * 0.001) -- (m/s * time) = distance, * 0.001 = m to km
	  
	  if milesDriven >= 0.402336 then --0.4...km = 1/4 mile
		addMileMoney()
		milesDriven = 0
	  end
    end

    dayOfYear = os.date("%a")
    timeOfDay = tonumber(os.date("%H") .. os.date("%M")) --1600 = 4 o'clock (16:00), converted to number to be able to do the below
	
	if dayOfYear == "Mon" or dayOfYear == "Tue" or dayOfYear == "Wed" or dayOfYear == "Thu" or dayOfYear == "Fri" then	--to check whether it is the weekend or not
		weekDay = true
	else
		weekDay = false
	end
	
	if timeOfDay > 2000 and timeOfDay >= 600 then	--night surcharge, 8pm - 6am (20:00 - 6:00)
		data.extrasTaxi = "050"
		
		elseif timeOfDay >= 1600 and timeOfDay <= 2000 and weekDay == true then  		--weekday surcharge, 16:00 - 20:00, day taken from your PC date
			data.extrasTaxi = "100"
		else
			data.extrasTaxi = "000"
	end
	
		data.fareTaxi = initialMoney + milecalcMoney + slowcalcMoney

		guiMsgMoney = (tonumber(data.fareTaxi) + data.extrasTaxi) / 100

    --dump(data)
    htmlTexture.call(gaugesScreenName, "update", data)
    updateTimer = 0
  end
end
--Created by Inn0centJok3r
local function init(jbeamData)
	gaugesScreenName = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 512
	local height = jbeamData.textureHeight or 256

    htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
    htmlTexture.call(gaugesScreenName, "init")
	
	timerSlowTraffic = 0
	initialMoney = jbeamData.initialMoney or 250
	mileMoney = jbeamData.mileMoney or 40
	slowMoney = jbeamData.slowMoney or 35
	
	initialinputMoney = initialMoney
	mileinputMoney = mileMoney
	slowinputMoney = slowMoney
end

local function reset() 
	guihooks.message("You have paid " .. guiMsgMoney .. "€ of taxi fare.", 4, "vehicle.sanderoTaxi.fare", "attach_money") 

	initialMoney = initialinputMoney
	mileMoney = mileinputMoney
	slowMoney = slowinputMoney
    milecalcMoney = 0
    slowcalcMoney = 0
end

M.reset = reset
M.init = init
M.updateGFX = updateGFX

return M
