-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxilliary"
M.relevantDevice = nil

local speedThresholdNormalPosition = 33
local speedThresholdLowPosition = 17
local speedThresholdHighPosition = 8
local brakeThresholdHighPosition = 99999.0

local awspoilerLow = 0
local awspoilerNormal = 0.58
local awspoilerHigh = 1

local function updateGFX(dt)
  local awspoiler = electrics.values.awspoiler
  local speed = electrics.values.wheelspeed

  if electrics.values.brake > brakeThresholdHighPosition then --check for brake input
    awspoiler = speed >= speedThresholdHighPosition and awspoilerHigh or awspoilerLow
  elseif speed >= speedThresholdNormalPosition then --we are not braking, check for normal awspoiler mode speed
    awspoiler = awspoilerNormal --(we are above the normal awspoiler position speed, so set the awspoiler to normal)
  else --we are not braking AND below the normal position speed
    awspoiler = (awspoiler == awspoilerNormal and speed >= speedThresholdLowPosition) and awspoilerNormal or awspoilerLow
  end

  electrics.values.awspoiler = awspoiler
end

local function init()
  electrics.values.awspoiler = 0
end

local function setParameters(parameters)
  if parameters.awspoilerLow then
    awspoilerLow = parameters.awspoilerLow
  end
  if parameters.awspoilerNormal then
    awspoilerNormal = parameters.awspoilerNormal
  end
  if parameters.awspoilerHigh then
    awspoilerHigh = parameters.awspoilerHigh
  end
end

M.init = init
M.updateGFX = updateGFX

M.setParameters = setParameters

return M
