ScriptName SFMovement Extends Quest
inputEnableLayer FarTravel
inputEnableLayer GravLayer
inputEnableLayer TakeOff
inputEnableLayer LocalSystemTravel

Import CassiopeiaPapyrusExtender

Quest Property DialogueShipServices Auto Const
Actor Property PlayerRef Auto Const
ObjectReference Property FLAStop Auto Const  
Location Property LastCurrentLoc Auto
Location Property CurrentLoc Auto
Location Property CurrentLocShip Auto
Location Property LastLocShip Auto
Planet Property CurrentPlanet Auto
Planet Property LastPlanet Auto
Perk Property LowValue Auto Const
Perk Property HighValue Auto Const
ReferenceAlias Property PlayerShip Auto mandatory
ReferenceAlias Property PlayerShipPilotSeat Auto mandatory
LocationAlias Property playerShipInteriorLocation Auto Const mandatory
SpaceshipReference CPS
SpaceshipReference CSF
Keyword Property LocTypeOrbit Auto Const
Keyword Property UCSpace Auto Const
Keyword Property FeestarSpace Auto Const
Keyword Property SettledSpace Auto Const
Keyword Property locTypeShipInterior Auto Const
Keyword Property ClassA Auto Const ; 0026FE57 
Keyword Property ClassB Auto Const ; 0026Fe56 
Keyword Property ClassC Auto Const ; 0026FE55 
Keyword Property ClassM Auto Const ; 0026Fe54
Keyword Property ShipRepairKW Auto Const
MiscObject Property BasicKit Auto Const mandatory
MiscObject Property AdvanceKit Auto Const mandatory
MiscObject Property Heavykit Auto Const mandatory
MiscObject Property RebuildKit Auto Const mandatory
MiscObject Property InorgCommonHelium3 Auto Const mandatory
MiscObject Property NuclearFuelRod  Auto Const mandatory ;00246B79
MiscObject Property Credits  Auto Const mandatory ;0000000f
Potion Property ShipActivatorItem Auto Const mandatory
ActorValue Property Cargo Auto ; 000002dc
ActorValue Property SpaceshipMass Auto
ActorValue Property SpaceshipGravThrust Auto
ActorValue Property SpaceshipGravJumpFuel Auto
ActorValue Property SpaceshipMaxAvailablePower Auto
ActorValue Property SpaceshipGravJumpCalculation Auto  ;0000821e
ActorValue Property SpaceshipBoostFuel Auto ; 00001885 
ActorValue Property SpaceshipBoostActive Auto ; 000188D
ActorValue Property Health Auto; 000002d4
ActorValue Property ShipSystemGravDriveHealth Auto; 001ef0cb
ActorValue Property GaswhenParked Auto
ActorValue Property PlayerFlownShip Auto
ActorValue Property SpaceshipGravJumpCurrentPower Auto
ActorValue Property spaceshipboostspeed Auto
ActorValue Property spaceshipenginepartmaxforwardspeed Auto
ActorValue Property spaceshipforwardspeedmult Auto
GlobalVariable Property GasInTank Auto
GlobalVariable Property OGTank Auto
GlobalVariable Property OGGenSize Auto
GlobalVariable Property ShipUtilityGlobal Auto
GlobalVariable Property AdvanceMode Auto
GlobalVariable Property GasToLoad Auto
GlobalVariable Property CanLand Auto
GlobalVariable Property MaintenanceMode Auto
GlobalVariable Property CrewPay Auto
GlobalVariable Property DynamicMode Auto
GlobalVariable Property CrewDebt Auto
GlobalVariable Property PreviouslyUpdated Auto
GlobalVariable Property AlertSound Auto
GlobalVariable Property BattleDamage Auto
GlobalVariable Property GameDaysPassed Auto ;39
GlobalVariable Property Gamehour Auto; 38
GlobalVariable Property FALFunction Auto
GlobalVariable Property EXPShipTakeover Auto
GlobalVariable Property AutoJumpCost Auto
GlobalVariable Property WeeklyCrewPay Auto
ReferenceAlias Property PlayerShipSpaceshipInventory Auto Const mandatory
Int Inspace
Int GasCostToJump 
int Costtofly
Int JustJumped = 0
Int Landed = 0
Int TakenOff = 0
Float Gastoreturn
Int GastoAdd
ActorValue Property Flighttime Auto
Float FlighttimeC
ActorValue Property RebuildAV Auto
Perk Property RebuildStop Auto Const
Float Rebuild
ActorValue Property AdvanceMAV Auto
Perk Property AdvanceMStop Auto Const
Float AdvanceM
ActorValue Property BasicMAV Auto
Perk Property BasicMStop Auto Const
Float BasicM
ActorValue Property HeavyMAV Auto
Perk Property HeavyMStop Auto Const
Float HeavyM
ActorValue Property NuclearFuel Auto
Float CurrentNFuel
Int NukeTankSize 
Int DefaultNukePolled = 0
Float CurrentGenPower
Float CurrentGenPowerRedux
Float CurrentJumpRange
Message Property ShipRepairMenu Auto Const
Message Property JumpMenu100msg Auto Const
Message Property JumpMenu10msg Auto Const
Message Property JumpMenu1msg Auto Const
Message Property Instructions Auto Const
Message Property BasicModeInstructions Auto Const
Message Property ImmersiveModeInstructions Auto Const
Message Property SettingsMenu Auto Const
Message Property CrewPayModeInstructions Auto Const
Message Property DynamicValueInstructions Auto Const
Message Property CostToFlyMSG Auto Const
Message Property NFRtakeOff Auto Const
Message Property GasInTankMSG Auto Const
Message Property OGTankMSG Auto Const
Message Property OFGMsg Auto Const
Message Property NFRRanout Auto Const
Message Property GasintankLoadMSG Auto Const
Message Property CurrentNfuelMSG Auto Const
Message Property DTVMsg Auto Const
Message Property ETVMsg Auto Const
Message Property ATVMsg Auto Const
Message Property BWMmsg Auto Const
Message Property BMmsg Auto Const
Message Property AMWmsg Auto Const
Message Property AMmsg Auto Const
Message Property HMWmsg Auto Const
Message Property HMmsg Auto Const
Message Property RWmsg Auto Const
Message Property Rmsg Auto Const
Message Property WeeklyCrewMsg Auto Const
Message Property JumpcostMSG Auto Const
Message Property FALengage Auto Const
Message Property FALOff Auto Const
Message Property EXPshipCapture Auto Const
Message Property HomeshipWarning Auto Const
Message Property AutoJumpMode Auto Const
Faction Property ConstellationFaction Auto Const
Float FROL
Int FRtR
Cell ShipInterior
Int Property ShipSFXDamage auto
wwiseevent Property ShipDamageAlarm Auto Const ; BoardingAlarm 000FD7c6 003f8f3e
wwiseevent Property FLAStopped Auto Const ; ShipACargoBayAClose 001e2ad8
wwiseevent Property FLACruise Auto Const ; AMBShipGravDriveJump 001e2adb
wwiseevent Property FLAPowerUp Auto Const ; PowerCell_power_up 002e22d5
Int Property ShipFLASFX auto
LocationRefType Property Ship_PilotSeat_RefType Auto Const


Event OnQuestInit() 
	String sScriptName = "SFMovement"
	String sEventName = "OnPlayerPlotRoute"
	RegisterForNativeEvent(sScriptName, sEventName)
  GravLayer = inputEnableLayer.Create() 
  FarTravel = inputEnableLayer.Create()
  Takeoff = inputEnableLayer.Create()  
  Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnLocationChange") 
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnLocationChange")  
RegisterForPlayerSleep()
 RegisterForPlayerwait()
RegisterForMenuOpenCloseEvent("shipcrewmenu")
  Self.RegisterForMenuOpenCloseEvent("DataMenu") 
  Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipGravJump")	 
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnEnterShipInterior") 
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnExitShipInterior") 
  Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipLanding") 
  Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipTakeOff") 
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerModifiedShip")
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnHomeShipSet")
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "Onsit")
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "Ongetup")
 Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipFarTravel")
Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipSystemPowerChange")
RegisterForRemoteEvent(PlayerRef, "OnItemEquipped")
  Self.StartTimer(5.0, 1) 
StartTimerGameTime(1, 2)	
Currentplanet = PlayerRef.GetCurrentPlanet()
Lastplanet = PlayerRef.GetCurrentPlanet()
CurrentLocShip = PlayerShip.GetRef().GetCurrentLocation()
LastLocShip = PlayerShip.getRef().GetCurrentLocation()	
EndEvent

Int PSS = 0

Event Actor.OnSit(Actor akSender, ObjectReference akFurniture)
If akSender == PlayerRef
	IF EXPShipTakeover.getvalue() == 1
		If akFurniture.HasRefType(Ship_PilotSeat_RefType)
		;Debug.Notification("Sit detected")
   		CSF = Game.GetPlayer().GetCurrentShipRef()
			IF PSS == 0
			;Game.TrySetPlayerHomeSpaceShip(CSF)
			PSS = 1 
			Debug.Notification("EXP Capture Running")
			GetDefaultGas()
			DefaultNukePolled = 0
			GetdefaultReactorSize()	
			Costtofly = GasCostToJump

			If Cps.getvalue(PlayerFlownShip) == 0
			RandomGas()
			CheckNuclearFuel()
			Endif 
	
			IF AdvanceMode.getvalue()== 0 
			;GasCostToJump = Math.Round((CPS.GetBaseValue(SpaceshipMass) + CPS.GetValue(Cargo)) / CPS.GetBaseValue(SpaceshipGravThrust))	
			GasCostToJump = Math.Round(CPS.GetBaseValue(SpaceshipMass) / CPS.GetBaseValue(SpaceshipGravThrust))
			Costtofly = GasCostToJump
	
				IF Gasintank.GetvalueInt() >= GasCostToJump 
				EnableGravJump()
				endif
		
				If Gasintank.GetvalueInt() < GasCostToJump 
				DisableGravJump()
				CosttoFlyMSG.show(Costtofly, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
				;Debug.Notification("You need " + Costtofly + " Helium3 to preform a Gravjump")  
				Endif

	
			Endif


	
			IF AdvanceMode.getvalue()== 1 && inspace == 1
			EnableGravJump()
				If CPS.getValue(NuclearFuel) > 0
				EnableSpaceTravel()
				EnableTakeoff()
					IF FALStarted == 0
					EnableGravJump()
					EnableSpaceTravel()
					EnableGroundTravel()
					endif
				endif

				IF FALStarted == 1
				DisableGravJump() 
				DisableSpaceTravel()
				DisableGroundTravel()
				endif
			endif

			IF AdvanceMode.getvalue()== 2 
				EnableGravJump()
			endif

			If CPS.getValue(NuclearFuel) > 0
			EnableSpaceTravel()
			EnableTakeoff()
			EnableGroundTravel()
			endif
		
			If CPS.getValue(NuclearFuel) <= 0 || CPS.hasperk(RebuildStop)
			NFRtakeOff.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
				;Debug.Notification("You need a Nuclear Fuel Rod to take off and fly at sublight speeds")
			DisableSpaceTravel()
			DisableTakeoff()
			DisableGravJump()
			DisableGroundTravel()
			endif 
			
			endif
		endif
	endif
	
endif

EndEvent

Event Actor.Ongetup(Actor akSender, ObjectReference akFurniture)
If akSender == PlayerRef
IF EXPShipTakeover.getvalue() == 1
	If akFurniture.HasRefType(Ship_PilotSeat_RefType)
	;Debug.Notification("Stand Up Detected")
		IF PSS == 1
		;Debug.Notification("Pss = 1")
		StoreGas() 
		ReturnToStock() 
		CPS = none
		PSS = 0
		endif
	endif
endif
endif
endevent
	
Int FALon = 0
Int FALStarted = 0

Event ReferenceAlias.OnShipSystemPowerChange(ReferenceAlias akSender, ActorValue akSystem, Bool abAddPower, Bool abDamagedRelated)
If AkSender == PlayerShip
If FALFunction.getvalue() == 1	
	IF CPS.GetValue(SpaceshipGravJumpCurrentPower) == 1 && FALon == 0 && FALStarted == 0 && GravJumping == 0 && CurrentLoc == playerShipInteriorLocation.GetLocation()
	FALStarted = 1 
	ShipFLASFX = FLAPowerUp.Play(PlayerRef, none, none)
	Self.StartTimer(4.5, 3) 
	IF GravJumping == 0
	FALengage.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	endif
	endif
	
	If CPS.GetValue(SpaceshipGravJumpCurrentPower) != 1 && FALStarted == 1 
	FALStarted = 0
	CancelTimer(3)
	wwiseevent.StopInstance(ShipFLASFX)
	ShipFLASFX = FLAStopped.Play(PlayerRef, none, none)
	FALOff.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		IF FALon == 1
		CPS.Modvalue(spaceshipboostspeed, -299792458)
		CPS.Modvalue(spaceshipenginepartmaxforwardspeed,-299792458) 
		CPS.Modvalue(spaceshipforwardspeedmult, -299792458)
		FALon = 0
		Self.StartTimer(1, 7) 
		endif
	endif
endif
endif
endevent


Int StartSleeptime
Int Endsleeptime
Int TimeSpentSleeping
Int DaysSlept
Float Sleepvaluetomodify
Int SleepDayStart
Int SleepDayEnd
Float NFZ

Event OnPlayerSleepStart(float afSleepStartTime, float afDesiredSleepEndTime, ObjectReference akBed)
	If inspace == 1 && CurrentLoc == playerShipInteriorLocation.GetLocation()
	CancelTimerGameTime(1)
	SleepDayStart = GameDaysPassed.Getvalueint()	
	StartSleeptime = GameHour.Getvalueint()
	endif
endevent

Event OnPlayerSleepStop(bool abInterrupted, ObjectReference akBed)
If inspace == 1 && CurrentLoc == playerShipInteriorLocation.GetLocation() 
SleepDayEnd = GameDaysPassed.Getvalueint()	
EndSleeptime = GameHour.Getvalueint()

CurrentNFuel = CPS.getValue(NuclearFuel)
BasicM = CPS.GetValue(BasicMAV)
AdvanceM = CPS.GetValue(AdvanceMAV)
HeavyM = CPS.GetValue(HeavyMAV)
Rebuild = CPS.GetValue(RebuildAV)

	IF SleepDayStart == SleepDayEnd
	Sleepvaluetomodify = EndSleeptime as float - StartSleeptime as float
	endif

	IF SleepDayStart != SleepDayEnd
	
	Sleepvaluetomodify = (24 - StartSleeptime) + EndSleeptime

	endif

CurrentNFuel = CPS.getValue(NuclearFuel) - Sleepvaluetomodify
	
	IF CurrentNFuel > 0
	CPS.Modvalue(NuclearFuel, - Sleepvaluetomodify)
	endif


	IF CurrentNFuel <= 0
	NFZ = CPS.GetValue(NuclearFuel)
	CPS.ModValue(NuclearFuel, - NFZ)
	CurrentNFuel = 0
	endif

BasicM = CPS.GetValue(BasicMAV) + Sleepvaluetomodify
CPS.ModValue(BasicMav, Sleepvaluetomodify)
AdvanceM = CPS.GetValue(AdvanceMAV) + Sleepvaluetomodify
CPS.ModValue(AdvanceMav, Sleepvaluetomodify)
HeavyM = CPS.GetValue(HeavyMAV) + Sleepvaluetomodify
CPS.ModValue(HeavyMAV, Sleepvaluetomodify)
Rebuild = CPS.GetValue(RebuildAV) + Sleepvaluetomodify
CPS.ModValue(RebuildAV, Sleepvaluetomodify)
CurrentNfuelMSG.show(CurrentNFuel, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
StartTimerGameTime(1, 1)
	
	IF CPS.getValue(NuclearFuel) == 0
	NFRRanout.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	CPS.ModValue(SpaceshipMaxAvailablePower, - CurrentGenPower)
	DisableGroundTravel()
	ShipInterior = PlayerRef.GetParentCell()
	ShipInterior.setGravityscale(0.0)
	ShipSFXDamage = ShipDamageAlarm.Play(PlayerShipPilotSeat.GetRef(), none, none)
	Starttimer(12, 6)
	CancelTimerGameTime(1)
	endif

endif
endevent

Event OnPlayerWaitStart(float afWaitStartTime, float afDesiredWaitEndTime)
	If inspace == 1 && CurrentLoc == playerShipInteriorLocation.GetLocation()
	CancelTimerGameTime(1)
	SleepDayStart = GameDaysPassed.Getvalueint()	
	StartSleeptime = GameHour.Getvalueint()
	endif
endevent

Event OnPlayerWaitStop(bool abInterrupted)
If inspace == 1 && CurrentLoc == playerShipInteriorLocation.GetLocation() || PSS == 1
SleepDayEnd = GameDaysPassed.Getvalueint()	
EndSleeptime = GameHour.Getvalueint()

IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif

CurrentNFuel = CPS.getValue(NuclearFuel)
BasicM = CPS.GetValue(BasicMAV)
AdvanceM = CPS.GetValue(AdvanceMAV)
HeavyM = CPS.GetValue(HeavyMAV)
Rebuild = CPS.GetValue(RebuildAV)

	IF SleepDayStart == SleepDayEnd
	Sleepvaluetomodify = EndSleeptime as float - StartSleeptime as float
	endif

	IF SleepDayStart != SleepDayEnd
	
	Sleepvaluetomodify = (24 - StartSleeptime) + EndSleeptime

	endif

CurrentNFuel = CPS.getValue(NuclearFuel) - Sleepvaluetomodify

	IF CurrentNFuel > 0
	CPS.Modvalue(NuclearFuel, - Sleepvaluetomodify)
	endif

	IF CurrentNFuel <= 0
	NFZ = CPS.GetValue(NuclearFuel)
	CPS.ModValue(NuclearFuel, - NFZ)
	CurrentNFuel = 0
	endif

BasicM = CPS.GetValue(BasicMAV) + Sleepvaluetomodify
CPS.ModValue(BasicMav, Sleepvaluetomodify)
AdvanceM = CPS.GetValue(AdvanceMAV) + Sleepvaluetomodify
CPS.ModValue(AdvanceMav, Sleepvaluetomodify)
HeavyM = CPS.GetValue(HeavyMAV) + Sleepvaluetomodify
CPS.ModValue(HeavyMAV, Sleepvaluetomodify)
Rebuild = CPS.GetValue(RebuildAV) + Sleepvaluetomodify
CPS.ModValue(RebuildAV, Sleepvaluetomodify)
CurrentNfuelMSG.show(CurrentNFuel, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
StartTimerGameTime(1, 1)
	
	IF CPS.getValue(NuclearFuel) == 0
	NFRRanout.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	CPS.ModValue(SpaceshipMaxAvailablePower, - CurrentGenPower)
	DisableGroundTravel()
	ShipInterior = PlayerRef.GetParentCell()
	ShipInterior.setGravityscale(0.0)
	ShipSFXDamage = ShipDamageAlarm.Play(PlayerShipPilotSeat.GetRef(), none, none)
	Starttimer(12, 6)
	CancelTimerGameTime(1)
	endif

endif
endevent
	
Event Actor.OnItemEquipped(Actor akSender, Form akBaseObject, ObjectReference akReference)
	if akSender == PlayerRef
	;Debug.Notification("item detected")
	IF akBaseObject.haskeyword(ShipRepairKW)
	;Debug.Notification("Keyword detected")
		IF PlayerRef.getitemcount(ShipActivatorItem) <= 0
		PlayerRef.Additem(ShipActivatorItem, 1, True)
		endif
	OpenRepairMenu()
	endif
	Endif	
endevent

Function OpenRepairMenu()

IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif

GasInTank.SetValueInt(CPS.GetvalueInt(SpaceshipGravJumpFuel))
CurrentNFuel = CPS.getValue(NuclearFuel)
BasicM = CPS.GetValue(BasicMAV)
AdvanceM = CPS.GetValue(AdvanceMAV)
HeavyM = CPS.GetValue(HeavyMAV)
Rebuild = CPS.GetValue(RebuildAV)
GasInTank.GetValueInt()
Costtofly = GasCostToJump
CPW = WeeklyCrewPay.getvalueInt()
StoreGas()
Int Button = ShipRepairMenu.show(CurrentNFuel, GasInTank.GetValueInt(), Costtofly, BasicM, AdvanceM, HeavyM, Rebuild, CPW, 0.0)

IF button == 0 
CPS.RemoveItem(BasicKit as Form, 1, False, None)
CPS.ModValue(BasicMAV, - BasicM)

IF CPS.hasperk(BasicMStop)
CPS.removeperk(BasicMStop)
	If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
	CPS.ModValue(SpaceshipMaxAvailablePower, CurrentGenPowerRedux)
	CurrentGenPower = CurrentGenPower + CurrentGenPowerRedux
	endif

	If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
	Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
	CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
	CurrentGenPower = CurrentGenPower - Tomuchpower
	endif
endif
OpenRepairMenu()
endif

IF button == 1
CPS.RemoveItem(AdvanceKit as Form, 1, False, None)
CPS.ModValue(AdvanceMAV, - AdvanceM)
CPS.ModValue(BasicMAV, - BasicM)
	IF CPS.hasperk(AdvanceMStop)
	CPS.removeperk(AdvanceMStop)
		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*2))
		CurrentGenPower = CurrentGenPower + (CurrentGenPowerRedux *2)
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		endif
	endif

	IF CPS.hasperk(BasicMStop)
	CPS.removeperk(BasicMStop)
		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, CurrentGenPowerRedux)
		CurrentGenPower = CurrentGenPower + CurrentGenPowerRedux
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		endif
	endif

OpenRepairMenu()
endif

IF button == 2
CPS.RemoveItem(HeavyKit as Form, 1, False, None)
CPS.ModValue(HeavyMAV, - HeavyM)
CPS.ModValue(AdvanceMAV, - AdvanceM)
CPS.ModValue(BasicMAV, - BasicM)
	IF CPS.hasperk(HeavyMStop)
	CPS.removeperk(HeavyMStop)
		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*3))
		CurrentGenPower = CurrentGenPower + (CurrentGenPowerRedux *3)
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		endif

	endif

	IF CPS.hasperk(AdvanceMStop)
	CPS.removeperk(AdvanceMStop)
	
		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*2))
		CurrentGenPower = CurrentGenPower + (CurrentGenPowerRedux *2)
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		endif
	endif

	IF CPS.hasperk(BasicMStop)
	CPS.removeperk(BasicMStop)
		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, CurrentGenPowerRedux)
		CurrentGenPower = CurrentGenPower + CurrentGenPowerRedux
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		endif
	endif

OpenRepairMenu()
endif

IF button == 3
	CPS.ModValue(AdvanceMAV, - AdvanceM)
	CPS.ModValue(BasicMAV, - BasicM)
	CPS.ModValue(HeavyMAV, - HeavyM)
	CPS.RemoveItem(RebuildKit as Form, 1, False, None)
	CPS.ModValue(RebuildAV, - Rebuild)
	
	IF CPS.hasperk(RebuildStop)
		CPS.removeperk(RebuildStop)

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*4))
		CurrentGenPower = CurrentGenPower + (CurrentGenPowerRedux *4)
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		endif

	ShipInterior = PlayerRef.GetParentCell()
	ShipInterior.setGravityscale(1)
	Canceltimer(6)
	Endif

	IF CPS.hasperk(HeavyMStop)
	CPS.removeperk(HeavyMStop)
		
		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*3))
		CurrentGenPower = CurrentGenPower + (CurrentGenPowerRedux *3)
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		Endif
	endif

	IF CPS.hasperk(AdvanceMStop)
	CPS.removeperk(AdvanceMStop)

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*2))
		CurrentGenPower = CurrentGenPower + (CurrentGenPowerRedux *2)
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		endif
	endif

	IF CPS.hasperk(BasicMStop)
	CPS.removeperk(BasicMStop)

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) > CurrentGenPower
		CPS.ModValue(SpaceshipMaxAvailablePower, CurrentGenPowerRedux)
		CurrentGenPower = CurrentGenPower + CurrentGenPowerRedux
		endif

		If CPS.GetbaseValue(SpaceshipMaxAvailablePower) < CurrentGenPower
		Float Tomuchpower = CurrentGenPower - CPS.GetbaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, - Tomuchpower)
		CurrentGenPower = CurrentGenPower - Tomuchpower
		endif
	endif

	
OpenRepairMenu()
Endif

IF button == 4
ChangeShipGas()
IF AdvanceMode.getvalue()== 0 
		Costtofly = GasCostToJump 
		IF Gasintank.GetvalueInt() >= Costtofly
		EnableGravJump()
		endif
		
		if Gasintank.GetvalueInt() < Costtofly || CPS.hasperk(RebuildStop)
		DisableGravJump()
		CosttoFlyMSG.show(Costtofly, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;Debug.Notification("You need " + Costtofly +  " Helium3 to preform a Gravjump")  
		Endif
	endif

IF CPS.Getvalue(SpaceshipGravJumpFuel) < 0
;Debug.Notification("negative correction")
;Debug.Notification(("Your ship has " + CPS.Getvalue(SpaceshipGravJumpFuel) + " units of Helium3 in the gas tank"))
CPS.RestoreValue(SpaceshipGravJumpFuel, - CPS.Getvalue(SpaceshipGravJumpFuel))
endif
StoreGas()
OpenRepairMenu()
endif

IF button == 5
GetdefaultReactorSize()
CheckNuclearFuel()
CurrentNFuel = CPS.getValue(NuclearFuel)
	If CPS.getValue(NuclearFuel) > 0
	EnableGroundTravel()
	EnableSpaceTravel()
	EnableTakeoff()
	
	IF AdvanceMode.getvalue()== 1
		DisableSpaceTravel() 
		IF inspace == 1
		EnableSpaceTravel()
		endif
	endif

	IF inspace == 1
	StartTimerGameTime(1, 1)
	endif

	endif

	If CPS.getValue(NuclearFuel) <= 0 || CPS.hasperk(RebuildStop)
	NFRtakeOff.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	;Debug.Notification("You need a Nuclear Fuel Rod to take off and fly at sublight speeds")
	DisableSpaceTravel()
	DisableTakeoff()
	DisableGroundTravel()
	endif 
CurrentNFuel = CPS.getValue(NuclearFuel)
OpenRepairMenu()
endif

IF button == 6
Instructions.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
OpenRepairMenu()
endif

Int CurrentDebt

IF button == 7
CurrentDebt = CrewDebt.GetvalueInt()
	IF CurrentDebt <= PlayerRef.getitemcount(Credits)
	PlayerRef.removeitem(Credits as form, CurrentDebt, True, None)
	CrewDebt.setvalue(0)
	CurrentDebt = 0
	endif
endif


IF button == 8
OpenSettingsMenu()
endif



endfunction

Function OpenSettingsMenu()

Int Button = SettingsMenu.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

IF button == 0
	AdvanceMode.setvalue(1)
		If InSpace == 1
		EnableGravJump()
		EnableSpaceTravel()
		endif
		If InSpace == 0
		DisableGravJump()
		DisableSpaceTravel() 
		endif
ImmersiveModeInstructions.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

OpenSettingsMenu()
endif

IF button == 1
AdvanceMode.setvalue(0)
BasicModeInstructions.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
OpenSettingsMenu()
endif

IF button == 2
MaintenanceMode.setValue(1);Turn Maintenance Mode ON
OpenSettingsMenu()
endif

IF button == 3
MaintenanceMode.setValue(0);Turn Maintenance Mode OFF
OpenSettingsMenu()
endif

IF button == 4
CrewPay.SetValue(1)
CrewPayModeInstructions.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
OpenSettingsMenu()
endif

IF button == 5
CrewPay.SetValue(0)
OpenSettingsMenu()
endif

If Button == 6
DynamicMode.SetValue(1)
DynamicValueInstructions.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
OpenSettingsMenu()
endif

If Button == 7
DynamicMode.SetValue(0)
OpenSettingsMenu()
endif

If Button == 8
AlertSound.SetValue(1)
OpenSettingsMenu()
endif

If Button == 9
AlertSound.SetValue(0)
OpenSettingsMenu()
endif

If Button == 10
BattleDamage.SetValue(1)
OpenSettingsMenu()
endif

If Button == 11
BattleDamage.SetValue(0)
OpenSettingsMenu()
endif

If Button == 12 ;is on by default
FALFunction.SetValue(1)
OpenSettingsMenu()
endif

If Button == 13
FALFunction.SetValue(0)
FALStarted = 0
CancelTimer(3)
	IF FALon == 1
	wwiseevent.StopInstance(ShipFLASFX)
	ShipFLASFX = FLAStopped.Play(PlayerRef, none, none)
	CPS.Modvalue(spaceshipboostspeed, -299792458)
	CPS.Modvalue(spaceshipenginepartmaxforwardspeed,-299792458) 
	CPS.Modvalue(spaceshipforwardspeedmult, -299792458)
	FALon = 0
	Self.StartTimer(1, 7) 
	endif
OpenSettingsMenu()
endif

If Button == 14 ;ON switch is off by default
EXPShipTakeover.SetValue(1)
EXPshipCapture.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
OpenSettingsMenu()
endif

If Button == 15 ; OFF switch is off by default
EXPShipTakeover.SetValue(0)
OpenSettingsMenu()
endif


If Button == 16 ; Auto mod on
AdvanceMode.setvalue(2)
AutoJumpMode.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
OpenSettingsMenu()
endif

If Button == 17 ; Auto mod off
AdvanceMode.setvalue(0)
OpenSettingsMenu()
endif


endfunction

Float CurrentPlantDayLength

Event OnTimer(Int aiTimerID)
  If aiTimerID == 1 
	CPS = playerShip.getShipRef()
	CurrentPlantDayLength = Currentplanet.GetDayLength()
	StoreGas()
	GetDefaultGas()
	GetdefaultReactorSize()
    	CheckLocValueShip() 
	CPS.GetGravJumpRange()
	CurrentPlanet = PlayerRef.GetCurrentPlanet()
	CurrentLoc = PlayerRef.GetCurrentlocation()
	AdvanceMode.setvalue(2)
		If PreviouslyUpdated.getvalue() == 0
		AdditemsTolists()
		PreviouslyUpdated.setvalue(1)
		Instructions.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		BasicModeInstructions.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		CrewPayModeInstructions.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		DynamicValueInstructions.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		PlayerRef.AddItem(InorgCommonHelium3 as Form, 100, False)
		PlayerRef.AddItem(NuclearFuelRod as Form, 5, False)
		PlayerRef.Additem(ShipActivatorItem, 1, False)
			If CPS.getvalue(PlayerFlownShip) == 0
			Cps.Modvalue(PlayerFlownShip, 1)
			;RandomGas()
			Endif
		
		endif

	HomeshipWarning.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	IF CurrentLoc == playerShipInteriorLocation.GetLocation() == False
	DisableSpaceTravel()
	DisableTakeOff()
	DisableGravJump()
	endif

	IF CurrentLoc == playerShipInteriorLocation.GetLocation()
	GetDefaultGenPower()
	DefaultNukePolled = 1
	ShipInterior = PlayerRef.GetParentCell()
	StartTimerGameTime(1, 1)
		IF AdvanceMode.getvalue()== 0 
		;GasCostToJump = Math.Round((CPS.GetBaseValue(SpaceshipMass) + CPS.GetValue(Cargo)) / CPS.GetBaseValue(SpaceshipGravThrust))	
		GasCostToJump = Math.Round(CPS.GetBaseValue(SpaceshipMass) / CPS.GetBaseValue(SpaceshipGravThrust))
		Costtofly = GasCostToJump
	
			IF Gasintank.GetvalueInt() >= GasCostToJump 
			EnableGravJump()
			endif
		
			If Gasintank.GetvalueInt() < GasCostToJump 
			DisableGravJump()
			CosttoFlyMSG.show(Costtofly, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			;Debug.Notification("You need " + Costtofly + " Helium3 to preform a Gravjump")  
			Endif
		endif
	
	IF AdvanceMode.getvalue()== 2 
	EnableGravJump()
	endif
	
	
	If CPS.getValue(NuclearFuel) > 0
	EnableSpaceTravel()
	EnableTakeoff()
	EnableGroundTravel()
	endif

	If CPS.getValue(NuclearFuel) <= 0 || CPS.hasperk(RebuildStop)
	NFRtakeOff.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	;Debug.Notification("You need a Nuclear Fuel Rod to take off and fly at sublight speeds")
	DisableSpaceTravel()
	DisableTakeoff()
	DisableGravJump()
	DisableGroundTravel()
	endif 

  EndIf	

	
  EndIf
	If aiTimerID == 2

	PSS = 0 
	CPS = playerShip.getShipRef()
	CPS.SetPartPower(3, -3, 0)

	If Cps.getvalue(PlayerFlownShip) == 0
		GetDefaultGas()
		DefaultNukePolled = 0
		RandomGas()
		StoreGas()
	Endif
	If Cps.getvalue(PlayerFlownShip) == 1
		StoreGas()
		GetDefaultGas()
		DefaultNukePolled = 0
	Endif

	GetDefaultGas()
	DefaultNukePolled = 0
	;Debug.Notification("Home ship Timer trigger")
	GetdefaultReactorSize()	
	CurrentNFuel =  CPS.getValue(NuclearFuel)
	Costtofly = GasCostToJump
	(DialogueShipServices as DialogueShipServicesScript).UpdateFuelGlobals()
	endif

	If aiTimerID == 3 
	wwiseevent.StopInstance(ShipFLASFX)
	;ShipFLASFX = FLACruise.Play(PlayerRef, none, none)
	CPS.Modvalue(spaceshipboostspeed, 299792458)
	CPS.Modvalue(spaceshipenginepartmaxforwardspeed,299792458) 
	CPS.Modvalue(spaceshipforwardspeedmult, 299792458)
	FALon = 1
	endif	

	If aiTimerID == 4
		;GasCostToJump = Math.Round((CPS.GetBaseValue(SpaceshipMass) + CPS.GetValue(Cargo)) / CPS.GetBaseValue(SpaceshipGravThrust))
		GasCostToJump = Math.Round(CPS.GetBaseValue(SpaceshipMass) / CPS.GetBaseValue(SpaceshipGravThrust))
		CPS.DamageValue(SpaceshipGravJumpFuel, -GasCostToJump*3)
		Int GastoSet = Math.Round(CPS.GetValue(SpaceshipGravJumpFuel))
		GasInTank.SetValue(GasToSet)
		GasInTankMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;Debug.Notification(("You have " + GasInTank.GetValueInt() as String) + " Helium3 left in your ship's tank")
		IF CPS.getValue(SpaceshipGravJumpFuel) < 0
		Game.getplayer().kill(PlayerRef)
		endif
		Justjumped = 0 		
	endif

	If aiTimerID == 5

	IF AdvanceMode.getvalue()== 2
		IF AutoJumpCost.Getvalue() == 0
		GasCostToJump = Math.Round(CPS.GetBaseValue(SpaceshipMass) / CPS.GetBaseValue(SpaceshipGravThrust))
		AutoJumpCost.setvalue(GasCostToJump )
		endif
		CPS.DamageValue(SpaceshipGravJumpFuel, - AutoJumpCost.Getvalueint())
		Int GastoSet = Math.Round(CPS.GetValue(SpaceshipGravJumpFuel))
		GasInTank.SetValue(GasToSet)
		GasInTankMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;AutoJumpCost.setvalue(0)
		AutoJumpStarted = 0
		StoreGas()
	endif
	
	Justjumped = 0
	Endif

	If aiTimerID == 6
	ShipSFXDamage = ShipDamageAlarm.Play(PlayerShipPilotSeat.GetRef(), none, none)
	Starttimer(12, 6)
	;Debug.Notification("No nuke power alarm")
	endif

	If aiTimerID == 7
		IF CPS.GetBaseValue(spaceshipenginepartmaxforwardspeed) > CPS.getvalue(spaceshipenginepartmaxforwardspeed)
		IVMFS = CPS.getvalue(spaceshipenginepartmaxforwardspeed)
		IVBS = CPS.getvalue(spaceshipboostspeed)
		IVFSM = CPS.getvalue(spaceshipforwardspeedmult)
		CPS.ModValue(spaceshipenginepartmaxforwardspeed, IVMFS)
		CPS.ModValue(spaceshipenginepartmaxforwardspeed, IVBS)
		CPS.ModValue(spaceshipenginepartmaxforwardspeed, IVFSM)
		endif
	endif
	
	If aiTimerID == 8
	CPS.SetPartPower(3, -3, 12)
	endif
	
EndEvent


FLoat IVMFS 
FLoat IVBS
FLoat IVFSM 

Float WeekHoursTracker = 0
int CPW = 0
Int CTPC = 0

Event OnTimerGameTime(Int aiTimerID)
	If aiTimerID == 1
	StartTimerGameTime(1, 1)
		IF inspace == 1 
		;Debug.Notification("Operational Timer Triggered")
		ShipWear()
		endif
	endif


	If aiTimerID == 2
	StartTimerGameTime(1, 2)
		IF CrewPay.GetValue() == 1
		TrackCrew()
		WeekHoursTracker = WeekHoursTracker + 1
		CTPC = NC * 12
		WeeklyCrewPay.setvalue(WeeklyCrewPay.getvalue() + CTPC)
		CPW = WeeklyCrewPay.getvalueInt()

	
		IF WeekHoursTracker >= 168
			IF CPW <= PlayerRef.getitemcount(Credits)
			PlayerRef.removeitem(Credits as form,  CPW, True, None)
			WeeklyCrewMsg.show(CPW, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			;Debug.Notification("Weekly crew cost, " + CPW + " payed to active crew.")
			ElseIF CPW > PlayerRef.getitemcount(Credits)
			CrewDebt.setvalue(CPW - PlayerRef.getitemcount(Credits))
			DismissCrew()
			endif
		WeekHoursTracker = 0
		WeeklyCrewPay.setvalue(0)
		CPW = 0
		endif
		endif
	endif
endevent

Event Actor.OnHomeShipSet(Actor akSource, spaceshipReference akShip, spaceshipReference akPrevious)
  If akSource == PlayerRef
	Self.StartTimer(0.5, 2)	
  EndIf
EndEvent

Event Actor.OnPlayerModifiedShip(Actor akSource, spaceshipReference akShip)
	If akShip == Game.GetPlayerHomeSpaceShip() as ObjectReference
	CancelTimer(2)
	CPS = playerShip.getShipRef()
	StoreGas()
	GetDefaultGas() 
	FuelSwap() 
	GetdefaultReactorSize()
	Costtofly = GasCostToJump
	CurrentNFuel = CPS.getValue(NuclearFuel)
		If CurrentNFuel > NukeTankSize
		FROL = CurrentNFuel - NukeTankSize
		CPS.ModValue(NuclearFuel, -FROL)
		FROL =  Math.Round(FROL / 10)
		ShipUtilityGlobal.setvalue(FROL)
		FRtR = ShipUtilityGlobal.getvalueInt()
		CPS.AddItem(NuclearFuelRod as Form, FRtR, True)
		endif
	endif
EndEvent

Event Actor.OnEnterShipInterior(Actor akSender, ObjectReference akShip)

 If akSender == PlayerRef && akShip == playerShip.getShipRef() 
	CPS = playerShip.getShipRef()
	IF DefaultNukePolled == 0
	GetDefaultGenPower()
	DefaultNukePolled = 1
	endif
	GetdefaultReactorSize()
	GasInTank.SetValueInt(CPS.GetvalueInt(SpaceshipGravJumpFuel))
	CurrentNFuel =  CPS.getValue(NuclearFuel)
	StartTimerGameTime(1, 1)
	CurrentPlanet = PlayerRef.GetCurrentPlanet()
	ShipInterior = PlayerRef.GetParentCell()

	IF AdvanceMode.getvalue()== 0 
	GasCostToJump = Math.Round(CPS.GetBaseValue(SpaceshipMass) / CPS.GetBaseValue(SpaceshipGravThrust))	
	;GasCostToJump = Math.Round((CPS.GetBaseValue(SpaceshipMass) + CPS.GetValue(Cargo)) / CPS.GetBaseValue(SpaceshipGravThrust)	
	Costtofly = GasCostToJump
	;Debug.Notification("Operational Timer Started")
		IF Gasintank.GetvalueInt() >= GasCostToJump
		CosttoFlyMSG.show(Costtofly, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
		;Debug.Notification("Current cost for a gravjump is " + Costtofly +  " units of Helium3")  
		EnableGravJump()
		endif
		
		if Gasintank.GetvalueInt() < GasCostToJump 
		DisableGravJump()
		;Debug.Notification("You need " + Costtofly + " Helium3 to preform a Gravjump") 
		CosttoFlyMSG.show(Costtofly, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
		Endif
	endif

	IF AdvanceMode.getvalue()== 2 
	EnableGravJump()
	endif
	
	
	If CPS.getValue(NuclearFuel) > 0
	EnableSpaceTravel()
	EnableTakeoff()
	EnableGroundTravel()
	endif

	If CPS.getValue(NuclearFuel) <= 0 || CPS.hasperk(RebuildStop)
	NFRtakeOff.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	;Debug.Notification("You need a Nuclear Fuel Rod to take off and fly at sublight speeds")
	DisableSpaceTravel()
	DisableTakeoff()
	DisableGravJump()
	DisableGroundTravel()
	endif 

	IF AdvanceMode.getvalue()== 1
	DisableSpaceTravel()
	DisableGravJump()
	;DisableGroundTravel()
		If inspace == 1
		EnableGravJump()
			If CPS.getValue(NuclearFuel) > 0
			EnableSpaceTravel()
			EnableTakeoff()
			endif
		endif
	endif

endif
EndEvent

Event Actor.OnExitShipInterior(Actor akSender, ObjectReference akShip)
  If akSender == PlayerRef && akShip == playerShip.getShipRef()
	CPS = playerShip.getShipRef()
	PSS = 0
	ReturnToStock()
	StoreGas() 
	DisableTakeoff()
	DisableSpaceTravel()
	DisableGravJump()
	EnableGroundTravel()
	;Debug.Notification("Exit Ship")
	CancelTimerGameTime(1)
	Lastplanet = CurrentPlanet 
	CurrentPLanet = PlayerRef.GetCurrentPlanet()
	DefaultNukePolled = 0
EndIf
EndEvent

Event ReferenceAlias.OnShipTakeoff(ReferenceAlias akSender, Bool abComplete)
  If akSender == PlayerShip
	Inspace = 1
	ShipInterior = PlayerRef.GetParentCell()
	;Debug.Notification("Take off Detected")
   		IF TakenOff == 0
		StartTimerGameTime(1, 1)
		;Debug.Notification("Operational Timer Started")
		TakenOff = 1
		Landed = 0	
		endif
		IF AdvanceMode.getvalue()== 1
		EnableGravJump()
		EnableGroundTravel()
		EnableSpaceTravel()
		endif
		IF AdvanceMode.getvalue()== 2 
		EnableGravJump()
		endif
  EndIf
EndEvent



Event ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)  ; will trigger when on planet already
  If akSender == PlayerShip
	Inspace = 0
	TakenOff = 0
	IF Landed == 0
	;Debug.Notification("Landed Tigger")
	Landed = 1
		IF AdvanceMode.getvalue()== 1
		DisableGravJump()
			IF JustJumped == 1
			Game.getplayer().kill(PlayerRef)
			endif
		endif	
   	EndIf
	
endif
EndEvent


Event OnMenuOpenCloseEvent(String asMenuName, Bool abOpening)

IF asMenuName == "DataMenu" && (abOpening == True || abOpening == False)

	IF PSS == 0
	GasCostToJump = Math.Round(CPS.GetBaseValue(SpaceshipMass) / CPS.GetBaseValue(SpaceshipGravThrust))
	;GasCostToJump = Math.Round((CPS.GetBaseValue(SpaceshipMass) + CPS.GetValue(Cargo))  / CPS.GetBaseValue(SpaceshipGravThrust))	 
	IF CurrentLoc == playerShipInteriorLocation.GetLocation() == false	
	;Debug.Notification("Menu open off ship")
	DisableSpaceTravel()
	DisableTakeoff()
	DisableGravJump()
	EnableGroundTravel()
	Endif	

	If CurrentLoc == playerShipInteriorLocation.GetLocation()	
	;Debug.Notification("Menu open on ship")

		If CPS.getValue(NuclearFuel) <= 0 || CPS.hasperk(RebuildStop)		
		;Debug.Notification("You need a Nuclear Fuel Rod to take off and fly at sublight speeds")
		DisableSpaceTravel()
		DisableTakeoff()
		DisableGroundTravel()
		CanLand.setvalue(0)
		endif


		If CPS.getValue(NuclearFuel) > 0 		
		EnableSpaceTravel()
		EnableTakeoff()
		EnableGroundTravel()
		CanLand.setvalue(1)
			IF FALStarted == 0
			EnableSpaceTravel()
			EnableGroundTravel()
			endif

			IF FALStarted == 1 
			DisableSpaceTravel()
			DisableGroundTravel()
			endif

		endif 
	
		IF AdvanceMode.getvalue()== 0 	 				
			Costtofly = GasCostToJump
			IF Gasintank.GetvalueInt() >= Costtofly
			EnableGravJump()
				IF FALStarted == 0
				enableGravJump()
				endif

				IF FALStarted == 1 
				DisableGravJump()
				endif
			
			;Debug.Notification("Current cost for a gravjump is" + Costtofly +  " units of Helium3")  			
			endif
	
			if Gasintank.GetvalueInt() < Costtofly || CPS.hasperk(RebuildStop)
			DisableGravJump()
			;Debug.Notification("You need " + Costtofly +  " Helium3 units to preform a Gravjump")  
			Endif
		Endif

		IF AdvanceMode.getvalue()== 1 && inspace == 1
		EnableGravJump()
			If CPS.getValue(NuclearFuel) > 0
			EnableSpaceTravel()
			EnableTakeoff()
				IF FALStarted == 0
				EnableGravJump()
				EnableSpaceTravel()
				EnableGroundTravel()
				endif

				IF FALStarted == 1
				DisableGravJump() 
				DisableSpaceTravel()
				DisableGroundTravel()
				endif
			endif
		endif

		IF AdvanceMode.getvalue()== 2 
		EnableGravJump()
			If CPS.getValue(NuclearFuel) > 0
			EnableSpaceTravel()
			EnableTakeoff()
				IF FALStarted == 0
				EnableGravJump()
				EnableSpaceTravel()
				EnableGroundTravel()
				endif

				IF FALStarted == 1
				DisableGravJump() 
				DisableSpaceTravel()
				DisableGroundTravel()
				endif
			endif
		endif
			

	Endif	
	Endif
endif

IF asMenuName == "shipcrewmenu" && abOpening == False
	TrackCrew()
	Debug.Notification("You have " + NC + " Non Constellation Crew Members")
	If CrewDebt.GetvalueInt() > 0
	DismissCrew()
	endif
endif

EndEvent

Int GravJumping = 0

Event ReferenceAlias.OnShipGravJump(ReferenceAlias akSender, Location aDestination, Int aState)
  If akSender == PlayerShip
	If aState == 0 
	GasInTank.SetValueInt(CPS.GetvalueInt(SpaceshipGravJumpFuel))
	;Debug.Notification("Grav Jump Triggered") ; count down started
	CancelTimer(3)
	GravJumping = 1
		If FALStarted == 1
		FALStarted = 0
		CancelTimer(3)
		wwiseevent.StopInstance(ShipFLASFX)
		ShipFLASFX = FLAStopped.Play(PlayerRef, none, none)
		FALOff.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		endif

		IF FALon == 1
		CPS.Modvalue(spaceshipboostspeed, -299792458)
		CPS.Modvalue(spaceshipenginepartmaxforwardspeed,-299792458) 
		CPS.Modvalue(spaceshipforwardspeedmult, -299792458)
		FALon = 0
		Self.StartTimer(1, 7) 
		endif

	
		IF AdvanceMode.getvalue()== 0 
			GasCostToJump = Math.Round(CPS.GetBaseValue(SpaceshipMass) / CPS.GetBaseValue(SpaceshipGravThrust))
			IF Inspace == 1	
			JumpcostMSG.show(Costtofly, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			;Debug.Notification("Current cost for a gravjump is " + Costtofly +  " units of Helium3")
			Landed = 0
			endif

			IF Inspace == 0
			Landed = 1
			endif
		endif

		IF AdvanceMode.getvalue()== 1
		StartTimer(1.5, 8)
		CPS.SetPartPower(3, -3, 0)
		JumpMenu100()		
 	 	EndIf

		IF AdvanceMode.getvalue()== 1 && AutoJumpStarted == 0
		
		endif
	endif	
	
	If aState == 1 
	;Debug.Notification("Grav Jump Started") ;enter warp Skipped on fast travel
	endif

	If aState == 2 
	GravJumping = 0
		IF AdvanceMode.getvalue()== 0 
			IF Inspace == 1	
			
			CPS.DamageValue(SpaceshipGravJumpFuel, -GasCostToJump)
			Int GastoSet = Math.Round(CPS.GetValue(SpaceshipGravJumpFuel))
			GasInTank.SetValue(GasToSet)
			GasInTankMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			;Debug.Notification(("You have " + GasInTank.GetValueInt() as String) + " Helium3 left in your ship's tank")
				IF CPS.getValue(SpaceshipGravJumpFuel) < 0
				CPS.kill(CPS)
				Game.getplayer().kill(PlayerRef)
				endif
			endif

			IF Inspace == 0
			Landed = 1
			CPS.DamageValue(SpaceshipGravJumpFuel, -(GasCostToJump*3))
			Int GastoSet = Math.Round(CPS.GetValue(SpaceshipGravJumpFuel))
			GasInTank.SetValue(GasToSet)
			GasInTankMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			;Debug.Notification(("You have " + GasInTank.GetValueInt() as String) + " Helium3 left in your ship's tank")
				IF CPS.getValue(SpaceshipGravJumpFuel) < 0
				Game.getplayer().kill(PlayerRef)
				endif
			endif
		endif

		IF AdvanceMode.getvalue()== 1
		CPS.DamageValue(SpaceshipGravJumpFuel, - Gastoload.Getvalue())
		Int GastoSet = Math.Round(CPS.GetValue(SpaceshipGravJumpFuel))
		GasInTank.SetValue(GasToSet)
		GasInTankMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;Debug.Notification(("You have " + GasInTank.GetValueInt() as String) + " Helium3 left in your ship's tank")
		StartTimer(3, 5)
		Justjumped = 1
			IF CPS.getValue(SpaceshipGravJumpFuel) < 0
			CPS.kill(CPS)
			Game.getplayer().kill(PlayerRef)
			endif
			If Inspace == 0
			Game.getplayer().kill(PlayerRef)
			endif
		endif

		IF AdvanceMode.getvalue()== 2
		StartTimer(1, 5)
		endif
	StoreGas()
	endif	

endif	

EndEvent

Event ReferenceAlias.OnLocationChange(ReferenceAlias akSender, Location akOldLoc, Location akNewLoc)
  If akSender == PlayerShip 
    CurrentLocShip = akNewLoc 
    LastLocShip = akOldLoc 
    Self.CheckLocValueShip()
	IF AdvanceMode.getvalue()== 1
		IF Inspace == 1
		;DisableGroundTravel()
		endif
	endif
 EndIf
EndEvent

Event Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
	IF akSender == PlayerRef
	GasCostToJump = Math.Round(CPS.GetBaseValue(SpaceshipMass) / CPS.GetBaseValue(SpaceshipGravThrust))
	CurrentLoc = AKnewLoc
	LastCurrentLoc = akOldLoc
	endif
EndEvent

Int lowvalueLoc = 0

Function CheckLocValueShip()

	IF CurrentLocShip.GetParentLocations(UCspace) || CurrentLocShip.GetParentLocations(FeestarSpace)
      	PlayerRef.RemovePerk(HighValue) 
      	PlayerRef.RemovePerk(LowValue)
		If Lowvalueloc == 0
		DTVMsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		lowvalueloc = 1
		;Debug.Notification("You are in a Core System Items Buy and Sell standard rate") 
		endIF
	endif
  
    If CurrentLocShip.GetParentLocations(SettledSpace) && CurrentLocShip.GetParentLocations(UCspace) == False && CurrentLocShip.GetParentLocations(FeestarSpace) == False
      	PlayerRef.RemovePerk(HighValue) 
     		 If PlayerRef.HasPerk(LowValue) == False
		lowvalueloc = 0
      		  PlayerRef.AddPerk(LowValue, False)
		ETVMsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
		endif
	 ;Debug.Notification("You are in a independent settled system Buy and Sell prices are mid level")
	endif

    If CurrentLocShip.GetParentLocations(SettledSpace) == False
      PlayerRef.RemovePerk(LowValue) 
     		 If PlayerRef.HasPerk(HighValue) == False 
      	 	 PlayerRef.AddPerk(HighValue, False)
		ATVMsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		lowvalueloc = 0 
     		 EndIf
      ;Debug.Notification("You are in a independent unsettled system Buy and Sell prices are high level")
    EndIf

EndFunction


Float GWP

Function GetDefaultGas()
IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif

GWP = CPS.Getvalue(GasWhenParked)

OGTank.SetValue(CPS.GetbaseValue(SpaceshipGravJumpFuel))
CPS.DamageValue(SpaceshipGravJumpFuel, -OGTank.GetvalueInt()) ; Zero out Gas

IF CPS.Getvalue(SpaceshipGravJumpFuel) < 1
;debug.Notification("negative correction")
;Debug.Notification(("Your ship has " + CPS.Getvalue(SpaceshipGravJumpFuel) + " units of Helium3 in the gas tank"))
CPS.RestoreValue(SpaceshipGravJumpFuel, - CPS.Getvalue(SpaceshipGravJumpFuel))
endif

IF GWP > 0
CPS.Restorevalue(SpaceshipGravJumpFuel, GWP) ;return gas already loaded
endif

Int GasToSet = CPS.getvalueInt(SpaceshipGravJumpFuel)
GasInTank.SetValueInt(GasToSet)
OGTankMSG.show(OGTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
EndFunction

Function GetDefaultGenPower()

OGGenSize.Setvalue(CPS.GetBaseValue(SpaceshipMaxAvailablePower))
CurrentGenPower = OGGenSize.Getvalue()
CurrentGenPowerRedux = OGGenSize.Getvalue() / 4
CPS.ModValue(SpaceshipMaxAvailablePower, -CurrentGenpower)
IF CPS.GetValue(NuclearFuel) > 1
CPS.ModValue(SpaceshipMaxAvailablePower, CurrentGenPower)
endif
;Debug.Notification("Setting Default Power")
CurrentNFuel =  CPS.getValue(NuclearFuel)
FlighttimeC = CPS.GetValue(FlightTime)
BasicM = CPS.GetValue(BasicMAV)
AdvanceM = CPS.GetValue(AdvanceMAV)
HeavyM = CPS.GetValue(HeavyMAV)
Rebuild = CPS.GetValue(RebuildAV)
EndFunction

Function ChangeShipGas()

IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif

GasInTank.SetValueInt(CPS.GetvalueInt(SpaceshipGravJumpFuel))
GastoAdd = OGTank.GetValueInt() - GasInTank.GetValueInt()
	
If GasInTank.GetValueInt() < OGTank.GetValueInt() 
	;need to add gas
	If GastoAdd > CPS.GetItemCount(InorgCommonHelium3 as Form)
	GastoAdd = CPS.GetItemCount(InorgCommonHelium3 as Form)
		IF GastoAdd > 0 
		GasInTank.SetValueInt(GasInTank.GetValueInt() + GastoAdd) ; Need current spaceshipgravejumpfuel
		CPS.RemoveItem(InorgCommonHelium3 as Form, GastoAdd, False, None)
		CPS.RestoreValue(SpaceshipGravJumpFuel, GastoAdd)	
			IF GasInTank.GetvalueInt() <= 0 
			GasInTank.SetValueint(0)
			OFGMsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			;Debug.Notification("Your Ship is out of Helium3, add Helium3 to you Cargo Hold")
			Endif
			If GasInTank.GetValueInt() >= 1
			GasInTankLoadMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
			;Debug.Notification(("Your ship has " + GasInTank.GetValueInt() as String) + " units of Helium3 in the gas tank")
			EndIf
		endif
	Endif

	If GastoAdd <= CPS.GetItemCount(InorgCommonHelium3 as Form) && CPS.GetItemCount(InorgCommonHelium3 as Form) != 0

	GastoAdd = OGTank.GetValueInt() - GasInTank.GetValueInt()
	GasInTank.SetValueInt(GasInTank.GetValueInt() + GastoAdd) 
	CPS.RemoveItem(InorgCommonHelium3 as Form, GastoAdd, False, None)
	CPS.RestoreValue(SpaceshipGravJumpFuel, GastoAdd)	
	GasInTankLoadMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
	;Debug.Notification(("Helium3 filled up " + GasInTank.GetValueInt() as String) + " Helium3 in your ship's tank")
	EndIf

Endif

EndFunction

Int NukeFueltoRemove

Function CheckNuclearFuel()

IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif

ShipUtilityGlobal.setvalue(NukeTankSize - CPS.getValue(NuclearFuel))
Int NuketoAdd = ShipUtilityGlobal.getvalueint()
CurrentNFuel =  CPS.getValue(NuclearFuel)

IF NukeTankSize > CPS.getValue(NuclearFuel)
	;add gas

	IF NuketoAdd > (CPS.GetItemCount(NuclearFuelRod) * 10)
	NukeFueltoRemove = CPS.GetItemCount(NuclearFuelRod as Form)
	CPS.ModValue(NuclearFuel, (NukeFueltoRemove*10))
	CPS.RemoveItem(NuclearFuelRod as Form, NukeFueltoRemove, False, None)
	CurrentNFuel =  CPS.getValue(NuclearFuel)

		IF CurrentNFuel <= 0 
		CPS.SetValue(NuclearFuel, 0)
		NFRRanout.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;Debug.Notification("Your Ship is out of Nuclear Fuel Rods and without power, add a Nuclear Fuel Rod to you Cargo Hold")
		Endif

		If CurrentNFuel >= 1
		ShipUtilityGlobal.setvalue(CurrentNFuel)
		CurrentNfuelMSG.show(CurrentNFuel, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
		;Debug.Notification("Your ship has " + ShipUtilityGlobal.GetvalueInt() + " hours of flight") 
			If CPS.GetValue(SpaceshipMaxAvailablePower) < CPS.GetBaseValue(SpaceshipMaxAvailablePower)	
			CPS.ModValue(SpaceshipMaxAvailablePower, CurrentGenPower)
				IF Inspace == 1
				ShipInterior = PlayerRef.GetParentCell()
				ShipInterior.setGravityscale(1)
				Canceltimer(6)
				Debug.Notification("In space detected timer cancelled") 
				endif
			endif
		endif
	Endif

	IF NuketoAdd <= (CPS.GetItemCount(NuclearFuelRod as Form) * 10) && CPS.GetItemCount(NuclearFuelRod as Form) != 0 
	CPS.ModValue(NuclearFuel, NuketoAdd)
	NukeFueltoRemove = Math.Round(NuketoAdd/10) 	
	CPS.RemoveItem(NuclearFuelRod as Form, NukeFuelToRemove, False, None)
	CurrentNFuel =  CPS.getValue(NuclearFuel)
	ShipUtilityGlobal.setvalue(CurrentNFuel)
	CurrentNfuelMSG.show(CurrentNFuel, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)   
		If CPS.GetValue(SpaceshipMaxAvailablePower) < CPS.GetBaseValue(SpaceshipMaxAvailablePower)
		CPS.ModValue(SpaceshipMaxAvailablePower, CurrentGenPower)
			IF Inspace == 1
			ShipInterior = PlayerRef.GetParentCell()
			ShipInterior.setGravityscale(1)
			Canceltimer(6)
			;Debug.Notification("In space detected timer cancelled") 
			endif
		endif
	endif
endif

If CurrentNFuel > NukeTankSize
FROL = CurrentNFuel - NukeTankSize
CPS.ModValue(NuclearFuel, -FROL)
FROL =  Math.Round(FROL / 10)
ShipUtilityGlobal.setvalue(FROL)
FRtR = ShipUtilityGlobal.getvalueInt()
CPS.AddItem(NuclearFuelRod as Form, FRtR, True)
endif
		
EndFunction


Function FuelSwap()

GWP = CPS.Getvalue(GasWhenParked)


IF GWP > CPS.GetbaseValue(SpaceshipGravJumpFuel)
	Gastoreturn = GWP - OGTank.GetValue()
	CPS.AddItem(InorgCommonHelium3, Gastoreturn as int, False) ; excess gas gets placed back in the ship inventory
	CPS.DamageValue(SpaceshipGravJumpFuel, OGTank.GetvalueInt()) ; zero it out
	CPS.RestoreValue(SpaceshipGravJumpFuel, OGTank.GetvalueInt()) ; max it back out
	GasInTankLoadMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	GasInTank.SetValue(CPS.getvalue(SpaceshipGravJumpFuel)) 
endif

Endfunction


Function StoreGas()
IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif
GWP = CPS.Getvalue(SpaceshipGravJumpFuel)
CPS.Setvalue(GaswhenParked, GWP)
endFunction


Function ReturnToStock()
IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif

IF CPS.getValue(NuclearFuel) <= 0
CPS.ModValue(SpaceshipMaxAvailablePower, OGGenSize.Getvalue())
endif

IF CPS.getValue(NuclearFuel) > 0
;Debug.Notification("Return to Stock")
endif

IF CPS.hasperk(RebuildStop)
CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*4))
endif

IF CPS.hasperk(HeavyMStop)
CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*3))
endif

IF CPS.hasperk(AdvanceMStop)
CPS.ModValue(SpaceshipMaxAvailablePower, (CurrentGenPowerRedux*2))
endif

IF CPS.hasperk(BasicMStop)
CPS.ModValue(SpaceshipMaxAvailablePower, CurrentGenPowerRedux) 
endif

CurrentGenPower = CPS.GetBaseValue(SpaceshipMaxAvailablePower)

Endfunction

Float ShipFuelSafety

Function ShipWear()

IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif

CurrentNFuel =  CPS.getValue(NuclearFuel)
CPS.ModValue(Flighttime, 1)
FlightTimeC = CPS.GetValue(Flighttime)
BasicM = CPS.GetValue(BasicMAV)
AdvanceM = CPS.GetValue(AdvanceMAV)
HeavyM = CPS.GetValue(HeavyMAV)
Rebuild = CPS.GetValue(RebuildAV)


IF MaintenanceMode.getvalue() == 1
CPS.ModValue(BasicMAV, 1)
CPS.ModValue(AdvanceMAV, 1)
CPS.ModValue(HeavyMAV, 1)
CPS.ModValue(RebuildAV, 1)
endif

IF CPS.getValue(NuclearFuel) >= 1
CPS.ModValue(NuclearFuel, -1)
CurrentNFuel =  CPS.getValue(NuclearFuel)
	IF CPS.getValue(NuclearFuel) <= 0
	CPS.SetValue(NuclearFuel, 0)
	NFRRanout.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		IF CPS.getValue(NuclearFuel) == 0
		CPS.ModValue(SpaceshipMaxAvailablePower, - CurrentGenPower)
		DisableGroundTravel()
			IF Inspace == 1
			ShipInterior = PlayerRef.GetParentCell()
			ShipInterior.setGravityscale(0.0)
			ShipSFXDamage = ShipDamageAlarm.Play(PlayerShipPilotSeat.GetRef(), none, none)
			Starttimer(12, 6)
			CancelTimerGameTime(1)
			endif
		endif
	endif

	If CPS.getValue(NuclearFuel) > 0
	ShipUtilityGlobal.setvalue(CurrentNFuel)
	CurrentNfuelMSG.show(CurrentNFuel, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
	endif
endif

	IF playerShip.getShipRef().getValue(NuclearFuel) != 0 

		If BasicM >= 48 && BasicM <= 40
		BWMmsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;Debug.Notification("Basic maintiance is due soon")
		Endif
		
		If BasicM >= 49 && CPS.hasperk(BasicMStop) == False ;50
		CPS.Addperk(BasicMStop, False)
		ShipFuelSafety = CurrentGenPower - CurrentGenPowerRedux
			IF ShipFuelSafety >= 0 
			CurrentGenPower = CurrentGenPower - CurrentGenPowerRedux
			CPS.ModValue(SpaceshipMaxAvailablePower, - CurrentGenPowerRedux)
			endif
		
			IF ShipFuelSafety < 0
			CPS.ModValue(SpaceshipMaxAvailablePower, -CurrentGenPower)
			CurrentGenPower = CurrentGenPower - CurrentGenPower ; zero'ed out
			endif
		
		;Debug.Notification(("Basic maintiance is due WARNING POWER OUTPUT REDUCED max Power " + CurrentGenPower as Int) + " ")	
		BMmsg.show(CurrentGenPower, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		endif

		If AdvanceM >= 108 && advanceM <= 100
		AMWmsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;Debug.Notification("Advanced maintiance is due soon")
		endif

		If AdvanceM >= 109 && CPS.hasperk(AdvanceMStop) == False ;110
		CPS.Addperk(AdvanceMStop, False)
		
			ShipFuelSafety = CurrentGenPower - (CurrentGenPowerRedux * 2)
			IF ShipFuelSafety >= 0 
			CurrentGenPower = CurrentGenPower - (CurrentGenPowerRedux * 2)
			CPS.ModValue(SpaceshipMaxAvailablePower, - (CurrentGenPowerRedux * 2))
			endif
		
			IF ShipFuelSafety < 0
			CPS.ModValue(SpaceshipMaxAvailablePower, -CurrentGenPower)
			CurrentGenPower = CurrentGenPower - CurrentGenPower ; zero'ed out
			endif
		;Debug.Notification(("Advance maintiance is due WARNING POWER OUTPUT REDUCED max Power " + CurrentGenPower as String) + " ")
		AMmsg.show(CurrentGenPower, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		Endif
		
		If HeavyM >= 518 && advanceM <= 500
		HMWmsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;Debug.Notification("Heavy maintiance is due soon")
		endif
	
		
		If HeavyM >= 519 && CPS.hasperk(HeavyMStop) == False ;520
		CPS.Addperk(HeavyMStop, False)

			ShipFuelSafety = CurrentGenPower - (CurrentGenPowerRedux * 3)
			IF ShipFuelSafety >= 0 
			CurrentGenPower = CurrentGenPower - (CurrentGenPowerRedux * 3)
			CPS.ModValue(SpaceshipMaxAvailablePower, - (CurrentGenPowerRedux * 3))
			endif
		
			IF ShipFuelSafety < 0
			CPS.ModValue(SpaceshipMaxAvailablePower, -CurrentGenPower)
			CurrentGenPower = CurrentGenPower - CurrentGenPower ; zero'ed out
			endif
			HMmsg.show(CurrentGenPower, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			;Debug.Notification(("Heavy maintiance is due WARNING POWER OUTPUT REDUCED max Power " + CurrentGenPower as String) + " ")
		endif
	
		If Rebuild >= 998 && advanceM <= 990
		RWmsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		;Debug.Notification("Your reactor requires a rebuild fail to rebuild the reactor will result in all lose of power")
		endif
	
		If Rebuild >= 999 && CPS.hasperk(RebuildStop) == False ;100
		CPS.Addperk(RebuildStop, False)

			ShipFuelSafety = CurrentGenPower - (CurrentGenPowerRedux * 4)
			IF ShipFuelSafety >= 0 
			CurrentGenPower = CurrentGenPower - (CurrentGenPowerRedux * 4)
			CPS.ModValue(SpaceshipMaxAvailablePower, - (CurrentGenPowerRedux * 4))
			endif
		
			IF ShipFuelSafety < 0
			CPS.ModValue(SpaceshipMaxAvailablePower, -CurrentGenPower)
			CurrentGenPower = CurrentGenPower - CurrentGenPower ; zero'ed out	
			endif
		Rmsg.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		endif

		If CurrentGenPower == 0
		DisableSpaceTravel()
		DisableTakeoff()
		DisableGravJump()
		DisableGroundTravel()
		ShipInterior = PlayerRef.GetParentCell()
		ShipInterior.setGravityscale(0.0)
		ShipSFXDamage = ShipDamageAlarm.Play(PlayerShipPilotSeat.GetRef(), none, none)
		Starttimer(12, 6)
		CancelTimerGameTime(1)
		endif
	endif

Endfunction

Function GetdefaultReactorSize()
IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif

Float Fueltotake = CPS.getValue(NuclearFuel)

NukeTankSize = 100

IF CPS.GetReactorClassKeyword() == ClassA
NukeTankSize = 50
endif

IF CPS.GetReactorClassKeyword() == ClassB
NukeTankSize = 100
endif

IF CPS.GetReactorClassKeyword() == ClassC
NukeTankSize = 150
endif

IF CPS.GetReactorClassKeyword() == ClassM
NukeTankSize = 300
endif

Endfunction

Function JumpMenu100()
Int Button = JumpMenu100msg.show(GasInTank.GetvalueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
gastoload.SetValue(0)

IF button == 0
JumpMenu10()
endif

IF button == 1
gastoload.SetValue(100)
GasInTank.SetValueInt(GasInTank.Getvalueint() -100)
JumpMenu10()
endif

IF button == 2
gastoload.SetValue(200)
GasInTank.SetValueInt(GasInTank.Getvalueint() -200)
JumpMenu10()
endif

IF button == 3
gastoload.SetValue(300)
GasInTank.SetValueInt(GasInTank.Getvalueint() -300)
JumpMenu10()
endif

endfunction

Function JumpMenu10()
Int Button = JumpMenu10msg.show(GasInTank.GetValueInt(), Gastoload.getvalueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

IF button == 0
JumpMenu1()
Endif

IF button == 1
gastoload.SetValue(Gastoload.getvalue() + 10)
GasInTank.SetValueInt(GasInTank.Getvalueint() -10)
JumpMenu1()
endif

IF button == 2
gastoload.SetValue(Gastoload.getvalue() + 20)
GasInTank.SetValueInt(GasInTank.Getvalueint() -20)
JumpMenu1()
endif

IF button == 3
gastoload.SetValue(Gastoload.getvalue() + 30)
GasInTank.SetValueInt(GasInTank.Getvalueint() -30)
JumpMenu1()
endif

IF button == 4
gastoload.SetValue(Gastoload.getvalue() + 40)
GasInTank.SetValueInt(GasInTank.Getvalueint() -40)
JumpMenu1()
endif

IF button == 5
gastoload.SetValue(Gastoload.getvalue() + 50)
GasInTank.SetValueInt(GasInTank.Getvalueint() -50)
JumpMenu1()
endif

IF button == 6
gastoload.SetValue(Gastoload.getvalue() + 60)
GasInTank.SetValueInt(GasInTank.Getvalueint() -60)
JumpMenu1()
endif

IF button == 7
gastoload.SetValue(Gastoload.getvalue() + 70)
GasInTank.SetValueInt(GasInTank.Getvalueint() -70)
JumpMenu1()
endif

IF button == 8
gastoload.SetValue(Gastoload.getvalue() + 80)
GasInTank.SetValueInt(GasInTank.Getvalueint() -80)
JumpMenu1()
endif

IF button == 9
gastoload.SetValue(Gastoload.getvalue() + 90)
GasInTank.SetValueInt(GasInTank.Getvalueint() -90)
JumpMenu1()
endif

Endfunction

Function JumpMenu1()

Int Button = JumpMenu1msg.show(GasInTank.GetValueInt(), Gastoload.getvalueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

IF button == 0
Endif

IF button == 1
gastoload.SetValue(Gastoload.getvalue() + 1)
GasInTank.SetValueInt(GasInTank.Getvalueint() -1)
endif

IF button == 2
gastoload.SetValue(Gastoload.getvalue() + 2)
GasInTank.SetValueInt(GasInTank.Getvalueint() -2)
endif

IF button == 3
gastoload.SetValue(Gastoload.getvalue() + 3)
GasInTank.SetValueInt(GasInTank.Getvalueint() -3)
endif

IF button == 4
gastoload.SetValue(Gastoload.getvalue() + 4)
GasInTank.SetValueInt(GasInTank.Getvalueint() -4)
endif

IF button == 5
gastoload.SetValue(Gastoload.getvalue() + 5)
GasInTank.SetValueInt(GasInTank.Getvalueint() -5)
endif

IF button == 6
gastoload.SetValue(Gastoload.getvalue() + 6)
GasInTank.SetValueInt(GasInTank.Getvalueint() -6)
endif

IF button == 7
gastoload.SetValue(Gastoload.getvalue() + 7)
GasInTank.SetValueInt(GasInTank.Getvalueint() -7)
endif

IF button == 8
gastoload.SetValue(Gastoload.getvalue() + 8)
GasInTank.SetValueInt(GasInTank.Getvalueint() -8)
endif

IF button == 9
gastoload.SetValue(Gastoload.getvalue() + 9)
GasInTank.SetValueInt(GasInTank.Getvalueint() -9)
endif

;StartTimer(2, 3)
Endfunction

Function EnableGravJump()
	GravLayer.EnableGravJump(True) 
	GravLayer.Reset()
	GravLayer.Delete()
	GravLayer = inputEnableLayer.Create()
	GravLayer.EnableGravJump(True)
Endfunction

Function DisableGravJump()
	GravLayer = inputEnableLayer.Create()
	GravLayer.Reset()
	GravLayer.Delete() 
	GravLayer = inputEnableLayer.Create()
	GravLayer.EnableGravJump(False)
endfunction

Function EnableSpaceTravel()
	Fartravel.EnableFarTravel(True)
	FarTravel.reset()
	FarTravel.Delete()
	FarTravel = inputEnableLayer.Create()
	Fartravel.EnableFarTravel(True)
endfunction

Function DisableSpaceTravel()
	Fartravel.EnableFarTravel(False)
	FarTravel.reset()
	FarTravel.Delete()
	FarTravel = inputEnableLayer.Create()
	Fartravel.EnableFarTravel(False)
Endfunction

Function EnableTakeoff()
	Takeoff.EnableTakeoff(True)
	Takeoff.Reset()
	Takeoff.delete()
	Takeoff = inputEnableLayer.Create()
	Takeoff.EnableTakeoff(True)
Endfunction

Function DisableTakeOff()
	Takeoff.EnableTakeoff(False)
	Takeoff.Reset()
	Takeoff.delete()
	Takeoff = inputEnableLayer.Create()
	Takeoff.EnableTakeoff(False)
Endfunction


Function EnableGroundTravel()
	LocalSystemTravel.EnableFastTravel(True)
	LocalSystemTravel.reset()
	LocalSystemTravel.delete()
	LocalSystemTravel= inputEnableLayer.Create()
	LocalSystemTravel.EnableFastTravel(True)
Endfunction

Function DisableGroundTravel()
	LocalSystemTravel.EnableFastTravel(False)
	LocalSystemTravel.reset()
	LocalSystemTravel.delete()
	LocalSystemTravel= inputEnableLayer.Create()
	LocalSystemTravel.EnableFastTravel(False)
Endfunction

LeveledItem Property LL_ShipResources Auto Const
LeveledItem Property LLD_shipItemOnDeath Auto Const
LeveledItem Property LL_Standard_Common_Helium3_extra Auto Const
LeveledItem Property LL_ShipResources_ship_Services_Outposts Auto Const

LeveledItem Property LLC_Any_TradeAuthority Auto Const
LeveledItem Property LLS_Vendor_ShipRepairKits Auto Const
LeveledItem Property LLS_Vendor_Crafting_inorg_Standard_common_helium3 Auto Const
LeveledItem Property LL_DeathItem_Ship_Cargo_A Auto Const
LeveledItem Property LL_DeathItem_Ship_Cargo_B Auto Const
LeveledItem Property LL_DeathItem_Ship_Cargo_C Auto Const
LeveledItem Property LL_DeathItem_Ship_Combat_A Auto Const
LeveledItem Property LL_DeathItem_Ship_Combat_B Auto Const
LeveledItem Property LL_DeathItem_Ship_Combat_C Auto Const
LeveledItem Property LL_DeathItem_Ship_Transport_A Auto Const
LeveledItem Property LL_DeathItem_Ship_Transport_B Auto Const
LeveledItem Property LL_DeathItem_Ship_Transport_C Auto Const
LeveledItem Property LL_DeathItem_Ship_Tanker_A Auto Const
LeveledItem Property LL_DeathItem_Ship_Tanker_C Auto Const

LeveledItem Property LL_Vendor_Radiant_General Auto Const ;001c8e62
LeveledItem Property LL_Vendor_Radiant_Military Auto Const ;001c8e63
LeveledItem Property LL_Vendor_Radiant_Settler Auto Const ;001c8e66
LeveledItem Property LL_Vendor_Radiant_Scum Auto Const ;001c8e60
LeveledItem Property LL_Vendor_Radiant_SoldierOfFortune Auto Const ; 001c8e61
LeveledItem Property LLC_Vendor_Any_list Auto Const ; 001C93DF

Function AdditemsTolists()
LL_DeathItem_Ship_Cargo_A.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Cargo_B.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Cargo_C.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Combat_A.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Combat_B.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Combat_C.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Transport_A.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Transport_B.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Transport_C.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Tanker_A.addform(LLD_shipItemOnDeath, 1, 1)
LL_DeathItem_Ship_Tanker_C.addform(LLD_shipItemOnDeath, 1, 1)
LLC_Any_TradeAuthority.addform(LL_ShipResources, 1, 1)
LLS_Vendor_ShipRepairKits.addform(LL_ShipResources, 1, 1)
LLS_Vendor_Crafting_inorg_Standard_common_helium3.addform(LL_Standard_Common_Helium3_extra, 1, 1)
LL_Vendor_Radiant_General.addform(LL_ShipResources_ship_Services_Outposts, 1, 1)
LL_Vendor_Radiant_Military.addform(LL_ShipResources_ship_Services_Outposts, 1, 1)
LL_Vendor_Radiant_Settler.addform(LL_ShipResources_ship_Services_Outposts, 1, 1)
LL_Vendor_Radiant_Scum.addform(LL_ShipResources_ship_Services_Outposts, 1, 1)
LL_Vendor_Radiant_SoldierOfFortune.addform(LL_ShipResources_ship_Services_Outposts, 1, 1)
LLC_Vendor_Any_LIST.addform(LL_ShipResources_ship_Services_Outposts, 1, 1)

endFunction 

Int CM = 0 
Int NC = 0

Function TrackCrew()
CM = 0 

NC = 0

Actor[] crewList = CPS.GetAllCrewMembers() 
      If crewList == None 
        crewList = new Actor[0] 
      EndIf

While CM < crewList.Length ; #DEBUG_LINE_NO:294
        Actor crew = crewList[CM]
	CM = CM + 1
		If Crew.isinfaction(ConstellationFaction) == False
		NC = NC + 1
		
		endif
endwhile

;Debug.Notification("You have " + CM + " Crew Members")	

;Debug.Notification("You have " + NC + " Non Constellation Crew Members") ;000191DC 

endfunction


Function DismissCrew()
Int i = 0
Actor[] crewList = CPS.GetAllCrewMembers() 
      If crewList == None 
        crewList = new Actor[0] 
      EndIf
	
While i < crewList.Length
	Actor crew = crewList[I]
	i = i + 1
		If Crew.isinfaction(ConstellationFaction) == False
		CPS.UnassignCrew(Crew)
		endif
endwhile

Endfunction

Int RNGnukeFuel
Int RNGH3 
Int Maxh3

Function RandomGas()  ; runs when player captures ship or swaps into ship they have never flown before

IF PSS == 1 
CPS = Game.GetPlayer().GetCurrentShipRef()
endif
IF PSS == 0
CPS = playerShip.getShipRef()
endif


ShipUtilityGlobal.setvalue(CPS.GetbaseValue(SpaceshipGravJumpFuel))
GetdefaultReactorSize()
Maxh3 = ShipUtilityGlobal.getvalueint() 
;rng gases
RNGNukeFuel = Utility.RandomInt(10, NukeTankSize) 
RNGH3 = Utility.RandomInt(10, Maxh3)
;setRNG gases

CPS.RestoreValue(SpaceshipGravJumpFuel, RNGH3)
GasInTank.SetValueInt(CPS.GetvalueInt(SpaceshipGravJumpFuel))
CPS.ModValue(NuclearFuel, RNGnukeFuel)
CPS.Modvalue(PlayerFlownShip, 1)
GasInTankLoadMSG.show(GasInTank.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 

CurrentNFuel =  CPS.getValue(NuclearFuel)
;run default checks to ensure value is not ourside vanilla range
StoreGas()
FuelSwap()

If CurrentNFuel > NukeTankSize
FROL = CurrentNFuel - NukeTankSize
CPS.ModValue(NuclearFuel, -FROL)
FROL =  Math.Round(FROL / 10)
ShipUtilityGlobal.setvalue(FROL)
FRtR = ShipUtilityGlobal.getvalueInt()
endif

endfunction

Int AutoJumpStarted = 0

Function OnPlayerPlotRoute(ObjectReference akHomeshipRef, Int aeFailedPlotReason, Int aiJumps, Float afShipGravJumpRange, Float afDistance, Float afCargoWeight, Float afCargoCapacity, Float afFuelConsumption, Float afMaxFuel)
afFuelConsumption = Math.Round(afFuelConsumption) 
	
	IF afFuelConsumption == 0
	afFuelConsumption = 1
	endif

Int ShipGas = afFuelConsumption as int
Debug.MessageBox("AFMovement value passed")
AutoJumpCost.setvalueint(ShipGas)
AutoJumpStarted = 1
EndFunction
