@echo off
REM =======================================================================
REM |  This batch file is part of UsableAnimationMarkers, and is used to  |
REM |  switch between different versions of the plugin. It should be run  |
REM |  from within your Starfield/data directory.                         |
REM =======================================================================
set "missingesm="
if not exist "UsableAnimationMarkers.esm.on" set "missingesm=1"
if not exist "UsableAnimationMarkers.esm.off" set "missingesm=1"
if not exist "UsableAnimationMarkers.esm.red" set "missingesm=1"
if defined missingesm (
  set "missingesm="
  echo One or more UsableAnimationMarkers plugins are missing. 
  echo.
  echo Please re-download the mod version that includes all three plugins and
  echo this batch file.
  goto exit
)
2>nul net session>nul
if errorlevel 1 (
  echo Batch file not running as admin. Switching the plugin will fail if the
  echo user does not have write permission for the Starfield data directory.
  echo.
)
ver>nul
echo Choose UsableAnimationMarkers version:
echo.
echo 1. Markers usable and not visible (normal)
echo 2. Markers not usable and not visible (vanilla)
echo 3. Markers usable and with a visible indicator (red tile)
echo.
:choose
set /p esm="Enter 1, 2 or 3: "
2>nul call :option_%esm%
if errorlevel 1 call :option_none
exit /b

:option_1
copy /y /l "UsableAnimationMarkers.esm.on" "UsableAnimationMarkers.esm"
if exist "UsableAnimationMarkers_SS.esm.on" copy /y /l "UsableAnimationMarkers_SS.esm.on" "UsableAnimationMarkers_SS.esm"
if exist "UsableAnimationMarkers_LandingCrew.esm.on" copy /y /l "UsableAnimationMarkers_LandingCrew.esm.on" "UsableAnimationMarkers_LandingCrew.esm"
echo.
echo Now using: Markers usable and not visible (normal)
goto exit

:option_2
copy /y /l "UsableAnimationMarkers.esm.off" "UsableAnimationMarkers.esm"
if exist "UsableAnimationMarkers_SS.esm.off" copy /y /l "UsableAnimationMarkers_SS.esm.off" "UsableAnimationMarkers_SS.esm"
if exist "UsableAnimationMarkers_LandingCrew.esm.off" copy /y /l "UsableAnimationMarkers_LandingCrew.esm.off" "UsableAnimationMarkers_LandingCrew.esm"
echo.
echo Now using: Markers not usable and not visible (vanilla)
goto exit

:option_3
copy /y /l "UsableAnimationMarkers.esm.red" "UsableAnimationMarkers.esm"
if exist "UsableAnimationMarkers_SS.esm.red" copy /y /l "UsableAnimationMarkers_SS.esm.red" "UsableAnimationMarkers_SS.esm"
if exist "UsableAnimationMarkers_LandingCrew.esm.red" copy /y /l "UsableAnimationMarkers_LandingCrew.esm.red" "UsableAnimationMarkers_LandingCrew.esm"
echo.
echo Now using: Markers usable and with a visible indicator (red tile)
goto exit

:option_none
echo Not a valid option
echo.
ver>nul
goto choose

:exit
set "esm="
timeout 5