local M = {}

local lights_on = nil
local volume = 0
local evening = 0.22
local morning = 0.78

local function dynamic_lights()
    local tod = scenetree.tod
    if not tod then return end

    local time = tod.time
    local value = false

    if time < morning and time > evening then
        value = true
    end

    if lights_on == value then return end
    lights_on = value

    if scenetree.dynamic_lights then
        for i = 0, scenetree.dynamic_lights.obj:getCount(), 1 do
            local id = scenetree.dynamic_lights.obj:idAt(i)
            local obj = scenetree.findObjectById(id)
            if obj and obj.obj:isSubClassOf('LightBase') then
                obj.obj:setLightEnabled(value)
            end
        end
    end
end

local function night_sounds()
    local tod = scenetree.tod
    if not tod then return end

    local time = tod.time
    local value = 0

    if time < morning and time > evening then
        value = 1.00
    end

    if volume == value then return end
    volume = value

    if scenetree.night_sound then
        for i = 0, scenetree.night_sound.obj:getCount(), 1 do
            local id = scenetree.night_sound.obj:idAt(i)
            local obj = scenetree.findObjectById(id)

            if obj and obj.obj:isSubClassOf('SFXEmitter') then
                if volume == 0 then
                    obj.obj:stop()
                else
                    obj.obj:play()
                end
            end
        end
    end
end

local function onUpdate()
    dynamic_lights()
    night_sounds()
end

M.onUpdate = onUpdate

return M