-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local playerInstance = 'scenario_player0'

local running = false
local playerVehId = nil
local startPosition = nil
local lastValidVehiclePos = nil
local bridgeStartPos = nil
local bridgeEndPos = nil
local maxTargetDist = nil
local maxPoints = nil
local crossedStartingPoint = false

local windTick = 0

local function reset()
  running = false
  playerVehId = nil
  startPosition = nil
  windTick = 0
  crossedStartingPoint = false
  lastValidVehiclePos = nil
end

local function updateWind(factor)
  if windTick < 25 then
    windTick = windTick + 1
  else
    local randx = math.random(-5,5) * factor
    local randz = math.random(-2,2) * factor
    local cmd = 'obj:setWind('..randx..', 0, '..randz..')'

    local bridge = scenetree.findObject('bridgeObject')
    bridge:queueLuaCommand(cmd)

    local vehicle = scenetree.findObject(playerInstance)
    vehicle:queueLuaCommand(cmd)
    windTick = 0
  end
end

local function onBeamNGTrigger(data)
  if data.subjectName == playerInstance then
    if  data.event == 'exit' and data.triggerName and data.triggerName == 'bridge_start' then
      crossedStartingPoint = true
    end

    if data.triggerName == "bridge_end" then
      scenario_scenarios.endScenario()
    end
  end
end

local function onRaceStart()
  reset()
  running = true

   local vehicle = scenetree.findObject(playerInstance)
   playerVehId = vehicle:getID()
   startPosition = vehicle:getPosition()

   local bidgeStart = scenetree.findObject('bridge_start')
   bridgeStartPos = bidgeStart:getPosition()

   local bidgeEnd = scenetree.findObject('bridge_end')
   bridgeEndPos = bidgeEnd:getPosition()

   maxTargetDist = (bridgeEndPos - startPosition):len() * 1.05
   maxPoints=scenario_scenarios.getScenario().customData.maxPoints

  local data = {
                enabled = false,
      maxPoints = maxPoints
    }

  statistics_statistics.setStatProgress(playerVehId, 'ui.stats.distance', playerInstance, data)
  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance, {waitTimerLimit = 5, vehMomentumLimit = 0.05})
end

local function onRaceTick(raceTickTime, raceTime)
  if not running then return end

  local vehicle = scenetree.findObject(playerInstance)
  local vehiclePos = vehicle:getPosition()
  local distZ = vehiclePos.z - startPosition.z
  local distToTarget = (bridgeEndPos - vehiclePos):len()
  local distFactor = 2 - (distToTarget / maxTargetDist)
  updateWind(distFactor)

  if distToTarget > maxTargetDist then
    statistics_statistics.setGoalProgress(playerVehId, "Bridge advance", playerInstance, {status='failed', maxPoints=nil})
    scenario_scenarios.finish({failed = "scenarios.utah.chapter_1.chapter_1_bridge.distance.fail.msg"})
    running = false
  end

  if distZ < -15 then
    lastValidVehiclePos = vehiclePos
    running = false
  end
end

local function onRaceResult()
  local vehiclePos = lastValidVehiclePos
  if not vehiclePos then
    local vehicle = scenetree.findObject(playerInstance)
    vehiclePos = vehicle:getPosition()
  end

  if not crossedStartingPoint then
    vehiclePos = bridgeStartPos
  end

  local bridgeDistance = (bridgeEndPos - bridgeStartPos):len()
  local dist = (vehiclePos - bridgeStartPos):len()

  if dist > 0 then
    local points = math.floor((dist / bridgeDistance) * maxPoints)
    if points > maxPoints then
      points = maxPoints
    end
    local data = {
        value=dist,
          points=points
        }
    statistics_statistics.setStatProgress(playerVehId, 'ui.stats.distance', playerInstance, data)
    scenario_scenarios.finish({msg = "Well done!"})
  else
    statistics_statistics.setGoalProgress(playerVehId, "Bridge advance", playerInstance, {status='failed', maxPoints=nil})
    scenario_scenarios.finish({failed = "scenarios.utah.chapter_1.chapter_1_bridge.distance.fail.msg"})
  end

  reset()
end

local function onVehicleStoppedMoving(vehicleID)
  local playerVehicle = scenetree.findObject(playerInstance)
  if vehicleID == playerVehicle:getID() then
    running = false
    scenario_scenarios.endScenario(0)
  end
end

M.onRaceStart = onRaceStart
M.onRaceTick = onRaceTick
M.onRaceResult = onRaceResult
M.onBeamNGTrigger = onBeamNGTrigger
M.onVehicleStoppedMoving = onVehicleStoppedMoving

return M
