-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local logTag = 'cannon'

local M = {}

local triggeredImpactCam = false
local inSlowMo = false
local impactTimer = 0
local running = false
local missedDelay = 0
local hitTime = nil
local targetStartingPos = nil

local function reset()
  running = false
  triggeredImpactCam = false
  inSlowMo = false
  impactTimer = 0
  missedDelay = 0
  hitTime = nil
  targetStartingPos = nil
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function pass(reason)
  scenario_scenarios.finish({msg = reason})
  reset()
end

local function onRaceStart()
  reset()
  running = true
  scenario_scenarios.trackVehicleMovementAfterDamage('clone0')

  local target = scenetree.findObject('clone0')
  targetStartingPos = target:getPosition()
end

local function onRaceResult()
  reset()
end

local function onCannonFired(vehicleID)
  log('A',logTag,'Cannon has been fired: '..vehicleID..' with state '..scenario_scenarios.getScenario().lastModeName)
  --switch cameras
  core_camera.setByName(0, 'orbit')
  core_camera.exitCinematicCamera()
end

local function onPreRender(dt)
  if not running then
    return
  end

  local vehicle = scenetree.findObject('scenario_player0')
  local target = scenetree.findObject('clone0')
  local playerVehicleID = vehicle:getID()

  --TODO(AK): getActivemode is returning requested mode so the call to setTargetmode might be missed
  core_camera.setRefNodes(playerVehicleID, 0, 92, 76, 0)
  core_camera.setTargetMode(playerVehicleID, 'ref', vec3(0,0,0))

   if vehicle and target then
    local nodePos = vehicle:getPosition() + vehicle:getNodePosition(0)

    local targetPos = target:getPosition()
    local distanceToTarget = (targetPos - nodePos):len()

    local distanceCannonToTarget = (targetPos - vehicle:getPosition()):len()
    local distanceCannonToCannonBall = (nodePos - vehicle:getPosition()):len()

    if distanceToTarget < 35 and not inSlowMo then
        simTimeAuthority.set(1/15)
        inSlowMo = true
        guihooks.trigger('ShowApps', false)
    end

    --Cannon has passed the vehicle without hitting it
    if inSlowMo and not hitTime and distanceCannonToCannonBall >  distanceCannonToTarget then
      missedDelay = missedDelay + dt
      if missedDelay >= 2.0 then
        fail({txt='scenarios.utah.chapter_1.chapter_1_cannon.fail.msg'})
      end
    elseif hitTime then
      if triggeredImpactCam == false then
        triggeredImpactCam = true
        scenario_scenarios.stopRaceTimer()
        -- disabled because broken
        --core_camera.onTrigger( {  cameraOnEnter = 'cinecam_impact',  cameraOnLeave = false,  event = "enter", subjectID = playerVehicleID,
        --subjectName = "scenario_player0",  triggerEvent = 0, triggerID = 3659 + 120,  triggerName = "trigger from cannon"})
      end
      impactTimer = impactTimer + dt
      if impactTimer > 3 then
        local targetDisplacement = (targetPos - targetStartingPos):len()
        if targetDisplacement < 0.45 then
          -- impact was not enough to register movement by tracking system
          local hitTimeStr = string.format("%0.2f", hitTime or 0)
          pass({txt= "scenarios.utah.chapter_1.chapter_1_cannon.damage.msg",context = {timeStr = hitTimeStr}})
        end
        simTimeAuthority.set(1)
        running = false
      end
     end
   end
end

local function onVehicleStoppedMoving(vehicleID)
  local target = scenetree.findObject('clone0')
  if vehicleID == target:getID() then
    running = false
    local hitTimeStr = string.format("%0.2f", hitTime or 0)
    pass({txt= "scenarios.utah.chapter_1.chapter_1_cannon.damage.msg",context = {timeStr = hitTimeStr}})
  end
end

local function onObjectCollision(objA, objB)
  -- log('A',logTag,'onObjectCollision called.. '..objA..' , ' ..objB)
  if not hitTime then
    hitTime = scenario_scenarios.getScenario().timer
  end
end

M.onRaceResult = onRaceResult
M.onRaceStart = onRaceStart
M.onCannonFired = onCannonFired
M.onPreRender = onPreRender
M.onVehicleStoppedMoving = onVehicleStoppedMoving
M.onObjectCollision = onObjectCollision
return M
