-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local playerInstance = 'scenario_player0'
local running = false
local vehicle = nil

local downTheCliff = false
local initialVehZPos = nil
local vehZMovement = nil

--
local minimumDropAltitude = 30
local jumpGoalMsg = nil
local jumpGoalStatus = nil

local function reset()
  running = false
  vehicle = nil

  downTheCliff = false
  initialVehZPos = nil
end

local function success(reason)
    scenario_scenarios.finish({msg = reason})
    running = false
end

local function fail(reason)
    scenario_scenarios.finish({failed = reason})
    running = false
end

local function onRaceStart()
  reset()
  vehicle = scenetree.findObject(playerInstance)
  if vehicle  == nil then
    running = false
    log('E', 'chapter_1_cliffjump', 'vehicle position not found')
    return
  end

  running = true
  initialVehZPos = vehicle:getPosition().z
  jumpGoalMsg = string.format("Drop At least %.0f m", minimumDropAltitude)

  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance)  
end

local function onPreRender(dt)
  -- has everything been initialized? 
  if running == false then
    return
  end

  --what is the current position of the vehicle?
  local currentVehPos = vehicle:getPosition()
  
  --is the vehicle down the cliff yet?
  vehZMovement = math.abs(currentVehPos.z - initialVehZPos)
  if vehZMovement > 10 then 
    downTheCliff =true
  end 
end

local function onRaceResult()
  if jumpGoalStatus == "passed" then
    success("scenarios.utah.chapter_1.chapter_1_cliffjump.pass.msg")
  end
  
  statistics_statistics.setGoalProgress(vehicle:getID(), jumpGoalMsg, playerInstance, {status=jumpGoalStatus, maxPoints=nil})
  reset()
end

local function onFailureTimerFired(failureTime)
 -- has the vehicle made it down the cliff within allowed time?
  if not downTheCliff then
    jumpGoalStatus = "failed"
    local failmsg ={txt= "scenarios.utah.chapter_1.chapter_1_cliffjump.timeLimit.msg",context = {failureTime = failureTime}}
    --"You have not left the top area in within " ..failureTime.." seconds!"
    fail(failmsg)
  end
end

local function onVehicleStoppedMoving(vehicleID)
  local playerVehicle = scenetree.findObject(playerInstance)
  if vehicleID == playerVehicle:getID() then
    running = false
    if downTheCliff then
      if vehZMovement  < minimumDropAltitude then
        jumpGoalStatus = "failed"
        fail({ txt = "scenarios.utah.chapter_1.chapter_1_cliffjump.altitude.fail.msg", context = {altitude =vehZMovement}})
      else
        jumpGoalStatus = "passed"
        success("scenarios.utah.chapter_1.chapter_1_cliffjump.pass.msg")
      end
    end    
  end
end

M.onRaceStart = onRaceStart
M.onPreRender = onPreRender
M.onFailureTimerFired = onFailureTimerFired
M.onRaceResult = onRaceResult
M.onVehicleStoppedMoving = onVehicleStoppedMoving
return M