-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local running = false
local playerVehId = nil
local triggerScored = {}
local goalName = 'Triggers scored'
local playerInstance = 'scenario_player0'

local function reset()
  running = false
  triggerScored = {}
end

local function onRaceStart()
  reset()
  running = true

  local vehicle = scenetree.findObject(playerInstance)
  playerVehId = vehicle:getID()

  local triggers = scenetree.findClassObjects('BeamNGTrigger')
  local triggerCount = 0
  for _,name in ipairs(triggers) do
    local trigger = scenetree.findObject(name)
    if trigger and trigger.isPathCheckpoint then
      triggerCount = triggerCount + 1
    end     
  end

  local data = {
    decimals = 1,
    enabled = true,
    label='ui.stats.pathAdvance',
    maxPoints=triggerCount *scenario_scenarios.getScenario().customData.PointsPerTrigger
  }

  statistics_statistics.setStatProgress(playerVehId, goalName, playerInstance, data)

  -- put vehicle in low range so it has a chance at climbing the hill
  vehicle:queueLuaCommand('if controller.getController("4wd") then controller.getController("4wd").setRangeMode("low") end')
end

local function onBeamNGTrigger(data)
  if data.isPathCheckpoint then
    triggerScored[data.triggerID] = true

    if data.triggerName == "checkpoint_05" then
      scenario_scenarios.endScenario()
    end
  end
end

local function onRaceResult()
  if running == false then
    return
  end

  local triggerCount = tableSize(triggerScored)
  if triggerCount == 0 then
    statistics_statistics.setGoalProgress(playerVehId, goalName, playerInstance, {status='failed', maxPoints=nil})
    scenario_scenarios.finish({failed = "scenarios.utah.chapter_1.chapter_1_crawl.fail.msg"})
  else
    statistics_statistics.setGoalProgress(playerVehId, goalName, playerInstance, {status='pass', maxPoints=nil})
  end

  local data = {
    points=triggerCount * scenario_scenarios.getScenario().customData.PointsPerTrigger,
    value=triggerCount
  }
  statistics_statistics.setStatProgress(playerVehId, goalName, playerInstance, data)
  reset()
end

M.onRaceStart = onRaceStart
M.onBeamNGTrigger = onBeamNGTrigger
M.onRaceResult = onRaceResult

return M
