-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local helper = require('scenario/scenariohelper')

local running = false
local breakgroupTimer = 0
local groupsToBreak = {}
local groupBreakCounter = 1
local breakGroups = false

local function shuffle(array)
  local n, j, k = #array
  for _ = 1, n do
    j, k = math.random(n), math.random(n)
    array[j], array[k] = array[k], array[j]
  end
  return array
end

local function reset()
  running = false
  breakgroupTimer = 0
  groupBreakCounter = 1
  breakGroups = false
end

local function getData(vehicleID, fuelRatio, fuelLevel, fuelTankCapacity)
  local value = fuelRatio or 0
  log('A','chapter_1_drag','VID: ' ..vehicleID ..' Fuel percentage: '..value)
  local usedAmount = (1.0 - value) * fuelTankCapacity
  statistics_statistics.setStatProgress(vehicleID, "fuelUsage", vehicleID, {label = 'ui.stats.fuelConsumption', value = usedAmount, predefinedUnit='ltr', decimals = 2})
  scenario_scenarios.getScenario().fuelCallback = nil
end

local function getFuelLevel(scenario, vehicle)
  scenario.fuelCallback = getData
  local command = string.format("obj:queueGameEngineLua('scenario_chapter_1_drag.getData(%s,'.. electrics.values.fuel..','..drivetrain.fuel..','..drivetrain.fuelCapacity.. ')')", vehicle:getID())
  log('A','chapter_1_drag','getFuelLevel command: '..command)
  helper.queueLuaCommand(vehicle, command)
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function onRaceStart()
  reset()

  local doors = {"barstow_doorlatch_R", "barstow_doorlatch_L",
                 "barstow_doorhinge_b_L","barstow_doorhinge_b_R",
                 "barstow_doorhinge_a_L","barstow_doorhinge_a_R"}

  local wheels = {"wheel_FL", "wheel_FR", "wheel_RL", "wheel_RR"}

  local rest = {"barstow_bumper_R_a_L", "barstow_bumper_R_a_R", "barstow_bumper_F_a_L", "barstow_bumper_F_a_R"}

  math.randomseed(os.time()) -- init random with a somewhat random seed
  doors = shuffle(doors)
  rest = shuffle(rest)
  wheels = shuffle(wheels)

  groupsToBreak = {}

  for _, g in pairs(doors) do
    table.insert(groupsToBreak, g)
  end

  for _, g in pairs(rest) do
    table.insert(groupsToBreak, g)
  end

  for _, g in pairs(wheels) do
    table.insert(groupsToBreak, g)
  end

  local arg = {vehicleName = 'clone0', waypoints = {'scenario_finish1'}, speeds = {scenario_finish1 = 300}, aggression = 1.5}
  helper.setAiPath(arg)

  running = true
  breakGroups = true

  scenario_scenarios.trackVehicleMovementAfterDamage('scenario_player0')
end

local function onRaceTick(raceTickTime)
  if not running then
    return
  end

  breakgroupTimer = breakgroupTimer + raceTickTime
  if breakGroups and breakgroupTimer >= 1.2 then
    helper.breakBreakGroup("clone0", groupsToBreak[groupBreakCounter])
    helper.queueLuaCommandByName("clone0", [[for k,v in pairs(v.data.beams) do
                                              if v.breakGroup == "]]..groupsToBreak[groupBreakCounter]..[[" then
                                                obj:addParticleByNodesRelative(v.id1, v.id2, 20, 1, 0, 20)
                                                obj:addParticleByNodesRelative(v.id2, v.id1, 10, 1, 0, 20)
                                                obj:addParticleByNodesRelative(v.id1, v.id2, 5, 1, 0, 20)
                                                obj:addParticleByNodesRelative(v.id2, v.id1, 10, 1, 0, 1)
                                                obj:addParticleByNodesRelative(v.id1, v.id2, 10, 1, 0, 1)
                                                obj:addParticleByNodesRelative(v.id2, v.id1, 10, 1, 0, 1)
                                              end
                                            end]])
    breakgroupTimer = 0
    groupBreakCounter = groupBreakCounter + 1

    if groupBreakCounter > #groupsToBreak then
      breakGroups = false
    end
  end

  if groupBreakCounter == 4 then
    helper.queueLuaCommandByName("clone0", 'fire.igniteRandomNodeMinimal()')
  end

  if groupBreakCounter >= 11 then
    helper.queueLuaCommandByName('clone0', 'fire.explodeVehicle()')
    helper.setAiMode('clone0', 'stop')
  end
end

local function onVehicleStoppedMoving(vehicleID)
  local playerVehicleID = be:getPlayerVehicleID(0)
  if vehicleID == playerVehicleID then
    scenario_scenarios.endRace(1)
  end
end

local function onScenarioFinished(scenario)
  log('D', 'chapter_1_drag', 'onScenarioFinished called....')
  if scenario and scenario.vehicles then
    for vehicleName, vehicleData in pairs(scenario.vehicles) do
      local vehicle = scenetree.findObject(vehicleName)
      if vehicle then
        getFuelLevel(scenario, vehicle)
      end
    end
  end
end

M.onRaceStart = onRaceStart
M.onRaceTick = onRaceTick
M.onScenarioFinished = onScenarioFinished
M.getData = getData
M.onVehicleStoppedMoving = onVehicleStoppedMoving

return M
