-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local running = false
local startPosition = nil
local trailerPosition = nil

local function reset()
  running = false
  startPosition = nil
  trailerPosition = nil
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function onRaceStart()
  reset()
  scenario_scenarios.trackVehicleMovementAfterDamage('scenario_player0')

  startPosition = scenetree.findObject('scenario_player0'):getPosition()
  trailerPosition = scenetree.findObject('clone1'):getPosition()

  local data = { enabled = false, maxPoints = 1000 }
  local vehicleID = scenetree.findObject('scenario_player0'):getID()
  statistics_statistics.setStatProgress(vehicleID, 'distance', 'scenario_player0', data)
  running = true
end

local function onVehicleStoppedMoving(vehicleID)
  if running then
    local pos = scenetree.findObject('scenario_player0'):getPosition()
    local trailerMovement = (scenetree.findObject('clone1'):getPosition() - trailerPosition):len()
    local distFromStart = (pos - startPosition):len()
    local distFromTrailer = (pos - trailerPosition):len()
    local distFromStartToTrailer = (trailerPosition - startPosition):len()
    if trailerMovement > 1 then
      return fail("You crashed into the trailer")
    end
    if (distFromStart - 10) < distFromStartToTrailer then -- require 10 meters after trailer to pass the scenario
      return fail("You didn't pass the trailer")
    end

    local endPoint = scenetree.findObject('checkpoint_scenario_end'):getPosition()
    local pointsDistanceRange = (endPoint - trailerPosition):len()
    local data = { enabled = true, value=distFromTrailer, points=math.max(0,math.min(1000,math.floor((distFromTrailer / pointsDistanceRange) * 1000))) }
    statistics_statistics.setStatProgress(vehicleID, 'distance', 'scenario_player0', data)
    scenario_scenarios.endScenario()
  end
end

local function onBeamNGTrigger(data)
  if data.triggerName == "checkpoint_scenario_end" then
    local vehicleID = scenetree.findObject('scenario_player0'):getID()
    onVehicleStoppedMoving(vehicleID)
  end
end

M.onRaceStart = onRaceStart
M.onVehicleStoppedMoving = onVehicleStoppedMoving
M.onBeamNGTrigger = onBeamNGTrigger
return M
