-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

--local helper = require('scenario/scenariohelper')
local logTag = 'chapter_1_hilldrop'
local playerInstance = 'scenario_player0'
local endInstance= 'endPointMarker'
local running = false -- has the scenario already started?

--local vehicle = nil
local initialVehPos = nil
local endMarkerPos = nil
local maxTargetDist = nil
local maxPoints = nil

local function reset()
  initialVehPos = nil
  endMarkerPos = nil
  maxTargetDist = nil
  maxPoints = nil
  running = false
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function onFailureTimerFired(failureTime)
  log('A', logTag,'onFailureTimerFired called..'..failureTime)

 -- has the vehicle  moved?
  local vehicle = scenetree.findObject(playerInstance)
  if vehicle then
    log('A', logTag,' (vehicle:getPosition() - initialVehPos):len(): '.. (vehicle:getPosition() - initialVehPos):len())

    if (vehicle:getPosition() - initialVehPos):len() < 1 then
      local failmsg ={txt= "scenarios.utah.chapter_1.chapter_1_hilldrop.fail.msg",context = {timeLimit = failureTime}}
      fail(failmsg)
    end
  end
end

local function onRaceStart()
  reset()
  running = true
 
  local vehicle = scenetree.findObject(playerInstance)
  if vehicle then
    initialVehPos = vehicle:getPosition()
  else
    log('E', logTag, 'vehicle position not found')
    running = false
  end

  local endMarker = scenetree.findObject(endInstance)
  if endMarker then
    endMarkerPos = endMarker:getPosition()
  else
    log('E', logTag, 'end marker position not found')
    running = false
  end

  if endMarkerPos and initialVehPos then
   maxTargetDist = (endMarkerPos - initialVehPos):len() * 1.05
  end
  
  maxPoints=scenario_scenarios.getScenario().statistics['distance'].maxPoints   

  local data = {
      enabled = false,
      maxPoints = maxPoints
    }

   statistics_statistics.setStatProgress(vehicle:getID(), 'distance', playerInstance, data)
end

local function onRaceTick(raceTickTime)
  --make sure that code is only executed after onRaceStart() has been called
  if not running then
    return true
  end
  
  local vehicle = scenetree.findObject(playerInstance)
  if vehicle then
    local distToTarget = (endMarkerPos - vehicle:getPosition()):len()

    if distToTarget > maxTargetDist then
      statistics_statistics.setGoalProgress(playerVehId, "Drive down hill", playerInstance, {status='failed', maxPoints=nil})
      fail({failed = "Wrong direction, drive down the hill."})
    end
  end
end

local function onRaceResult()
  local vehicle = scenetree.findObject(playerInstance)
  if vehicle then
    local playerVehId = vehicle:getID()
    local maxDistance = (endMarkerPos - initialVehPos):len()
    local dist = (vehicle:getPosition() - initialVehPos):len()

    if dist > 0 then
      local points = math.floor((dist / maxDistance) * maxPoints)
      -- log('A', logTag, 'dist: '..dist..', MaxDist: '..maxDistance..', points: '..points..', maxPoints: '..maxPoints)
      if points > maxPoints then
        points = maxPoints
      end

      local data = {value=dist, points=points}
      statistics_statistics.setStatProgress(playerVehId, 'distance', playerInstance, data)   
      scenario_scenarios.finish({msg = "Well done!"})
    else
      statistics_statistics.setGoalProgress(playerVehId, "Drive down hill", playerInstance, {status='failed', maxPoints=nil})
      fail({failed = "Wrong direction, drive down the hill."})
    end
  end
  reset()
end

M.onRaceStart = onRaceStart
M.onRaceTick = onRaceTick
M.onRaceResult = onRaceResult
M.onFailureTimerFired = onFailureTimerFired
return M