-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

--local helper = require('scenario/scenariohelper')
local logTag = 'chapter_1_jump'
local playerInstance = 'scenario_player0'
local targetMarkerInstance= 'targetPointMarker'
local otherVehicleInstance= 'clone0'

local running = false -- has the scenario already started?
local targetMarkerPos = nil
local accuracyMaxPoints = nil
local waitTimer = 0
local hasJumped = false
local damageAtJump = 0
local jumpPosition = nil
local landPosition = nil
local vehicleBSphereRadius = nil
local playerHitTheTarget = false
local hitTimeStr = ''

local function reset()
  landPosition = nil
  jumpPosition = nil
  hasJumped = false
  waitTimer = 0
  accuracyMaxPoints = nil
  targetMarkerPos = nil
  running = false
  damageAtJump = 0
  vehicleBSphereRadius = nil
  playerHitTheTarget = false
  hitTimeStr = ''
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function pass(reason)
  scenario_scenarios.finish({msg = reason})
  reset()
end

local function onFailureTimerFired(failureTime)
 --  log('A', logTag,'onFailureTimerFired called..'..failureTime)

 -- -- has the vehicle  moved?
 --  local vehicle = scenetree.findObject(playerInstance)
 --  if vehicle then
 --    log('A', logTag,' (vehicle:getPosition() - initialVehPos):len(): '.. (vehicle:getPosition() - initialVehPos):len())

 --    if (vehicle:getPosition() - initialVehPos):len() < 1 then
 --      local failmsg ={txt= "scenarios.utah.chapter_1.chapter_1_hilldrop.fail.msg",context = {timeLimit = failureTime}}
 --      fail(failmsg)
 --    end
 --  end
end

local function onObjectCollision(objA, objB)
  -- log('I', logTag, 'onObjectCollision called objA : '..objA..', objB: '..objB)
  local target = scenetree.findObject(otherVehicleInstance)
  local scenario = scenario_scenarios.getScenario()
  if target and scenario then
    local targetID = target:getID()
    if targetID == objA or targetID == objB then
      playerHitTheTarget = true

      local hitTime = scenario.maxTime - scenario.timer
      if hitTime < 0 then
        hitTime = scenario.maxTime
      end

      local minutes = math.floor(hitTime / 60);
      local seconds = hitTime - (minutes * 60);
      if minutes > 0 then
          hitTimeStr = string.format("%02.0f:%05.2f", minutes, seconds)
      else
          hitTimeStr = string.format("%0.2f", seconds) .. 's'
      end
    end
  end
end

local function onRaceStart()
  reset()
  running = true

  local targetMarker = scenetree.findObject(targetMarkerInstance)
  if targetMarker then
    targetMarkerPos = targetMarker:getPosition()
  else
    log('E', logTag, 'target marker position not found')
    running = false
  end

  accuracyMaxPoints = scenario_scenarios.getScenario().statistics['accuracy'].maxPoints

  local data = {
    decimals = 1,
    enabled = true,
    label='ui.stats.accuracy',
    maxPoints=accuracyMaxPoints
  }

  local vehicle = scenetree.findObject(playerInstance)
  vehicleBSphereRadius = vehicle:getBSphereRadius()

  statistics_statistics.setStatProgress(vehicle:getID(), 'accuracy', playerInstance, data)

  local distData = {
      enabled = false
    }

   statistics_statistics.setStatProgress(vehicle:getID(), 'distance', playerInstance, distData)
end

local function onPreRender(dt)
  --make sure that code is only executed after onRaceStart() has been called
  if not running then
    return
  end

  local vehicle = scenetree.findObject(playerInstance)
  if hasJumped and vehicle then
    local vehicleData = map.objects[vehicle:getID()]
      -- wait till player's vehicle lands
    if vehicleData and (vehicleData.damage - damageAtJump) > 0 then
      local vehiclePos = vehicle:getPosition()
      local deltaPlayerZ = math.abs(targetMarkerPos.z - vehiclePos.z)
      -- local distTargetZ = math.abs(targetMarkerPos.z - jumpPosition.z)
      -- log('A', logTag, 'distTargetZ: ' ..distTargetZ.. ', deltaPlayerZ: '..deltaPlayerZ..', Diff: '..math.abs((distTargetZ - deltaPlayerZ))..', BSphereRadius: ' ..vehicleBSphereRadius)
      -- log('A', logTag, 'deltaPlayerZ: '..deltaPlayerZ..', Diff: '..deltaPlayerZ..', BSphereRadius: ' ..vehicleBSphereRadius)

      -- if math.abs((distTargetZ - deltaPlayerZ)) < vehicleBSphereRadius then
      if deltaPlayerZ < vehicleBSphereRadius then
        -- log('A', logTag, 'player has stopped falling...')
        if not landPosition then
          landPosition = vehiclePos
          scenario_scenarios.stopRaceTimer()
        end

        waitTimer = waitTimer + dt
        if waitTimer > 2 then
          scenario_scenarios.endScenario(0)
          running = false
        end
      end
    end
  end
end

local function onRaceResult()
  --log('A', logTag, 'onRaceResult called....')
  local vehicle = scenetree.findObject(playerInstance)
  local vehicleID = vehicle:getID()

  if not hasJumped then
      fail('scenarios.utah.chapter_1.chapter_1_jump.fail.msg')
      return
  end

  local radius = scenario_scenarios.getScenario().statistics['accuracy'].radius or 0
  landPosition.z = targetMarkerPos.z
  jumpPosition.z = targetMarkerPos.z
  local distanceToTarget = (targetMarkerPos - landPosition):len() - vehicleBSphereRadius
  local jumpDistance = (landPosition - jumpPosition):len()

  --log('A', logTag, 'distanceToTarget:' ..distanceToTarget)

  if distanceToTarget < 0 then
    distanceToTarget = 0
  end

  if distanceToTarget > radius then
    distanceToTarget = radius
  end

  local scaleFactor = 1.0 - ((distanceToTarget / radius) or 0)
  --log('A', logTag, 'scaleFactor:' ..scaleFactor..' Points: '..accuracyMaxPoints * scaleFactor)

  local data = {
    value = distanceToTarget,
    points=accuracyMaxPoints * scaleFactor
  }
  statistics_statistics.setStatProgress(vehicleID, 'accuracy', playerInstance, data)

  jumpPosition.z = landPosition.z
  local distData = {
    value = jumpDistance
  }
  -- dump(vec3(landPosition))
  -- dump(vec3(jumpPosition))
  -- dump(distData)
 statistics_statistics.setStatProgress(vehicleID, 'distance', playerInstance, distData)

  if playerHitTheTarget then
      pass({ txt = "scenarios.utah.chapter_1.chapter_1_jump.damage.msg", context = {timeStr = hitTimeStr}})
  end

  reset()
end

local function onVehicleStoppedMoving(vehicleID)
  -- local playerVehicle = scenetree.findObject(playerInstance)
  -- if vehicleID == playerVehicle:getID() then
  --   running = false
  --   scenario_scenarios.endScenario(0)
  -- end
end

local function onBeamNGTrigger(data)
  --log('A', logTag, 'onBeamNGTrigger called...')
  --dump(data)

  if data.subjectName == playerInstance and data.event == 'exit' and data.triggerName and data.triggerName == 'jumpPointTrigger' then
    hasJumped = true
    local playerVehicle = scenetree.findObject(playerInstance)
    jumpPosition = playerVehicle:getPosition()
    -- dump(vec3(jumpPosition))
    local vehicleData = map.objects[playerVehicle:getID()]
    damageAtJump =  vehicleData.damage
  end
end

M.onRaceStart = onRaceStart
M.onPreRender = onPreRender
M.onRaceResult = onRaceResult
M.onFailureTimerFired = onFailureTimerFired
M.onObjectCollision = onObjectCollision
-- M.onVehicleStoppedMoving = onVehicleStoppedMoving
M.onBeamNGTrigger = onBeamNGTrigger
return M