-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local targetStartPosition = nil
local playerStartPosition = nil
local playerInstance = 'scenario_player0'
local targetInstance = 'clone0'
local running = false

local function reset()
  targetStartPosition = nil
  playerStartPosition = nil
  running = false
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function success(reason)
  scenario_scenarios.finish({msg = reason})
  reset()
end

local function targetFellOffCliff()
  local targetPosition = scenetree.findObject(targetInstance):getPosition()
  return math.abs(targetPosition.z - targetStartPosition.z) > 10
end

local function playerFellOffCliff()
  local position = scenetree.findObject(playerInstance):getPosition()
  return math.abs(position.z - playerStartPosition.z) > 10
end

local function onRaceStart()
  reset()
  playerStartPosition = scenetree.findObject(playerInstance):getPosition()
  targetStartPosition = scenetree.findObject(targetInstance):getPosition()
  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance)
  running = true
end

local function onVehicleStoppedMoving(vehicleID)
  local playerVehicleID = be:getPlayerVehicleID(0)
  if running and vehicleID == playerVehicleID then
    if targetFellOffCliff() and playerFellOffCliff() then
      success('scenarios.utah.chapter_1.chapter_1_ramcliff.pass.msg')
    else
      fail('scenarios.utah.chapter_1.chapter_1_ramcliff.fail.msg')
    end
  end
end

local function onFailureTimerFired(failureTime)
  --is the vehicle down the cliff yet?
  if running then
    if not targetFellOffCliff() then
      fail('scenarios.utah.chapter_1.chapter_1_ramcliff.distance.fail.msg')
    end
  end
end

M.onRaceStart = onRaceStart
M.onVehicleStoppedMoving = onVehicleStoppedMoving
M.onFailureTimerFired = onFailureTimerFired

return M