-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local playerInstance = 'scenario_player0'
local wallInstance = 'clone1'
local goalName = 'Follow path'
local initialPlayerPos = nil
local numCheckpoints = 0
local crossedCheckpoints = {}
local running = false
local playerHitTheWall = false

local function reset()
  numCheckpoints = 0
  crossedCheckpoints = {}
  initialPlayerPos = nil
  running = false
  playerHitTheWall = false
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function onRaceStart()
  reset()
  
  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance)

  local vehicle = scenetree.findObject(playerInstance)
  initialPlayerPos = vehicle:getPosition()

  local triggers = scenetree.findClassObjects('BeamNGTrigger')
  for _,name in ipairs(triggers) do
    local trigger = scenetree.findObject(name)
    if trigger and trigger.chap1_suspension_checkpoint then
      numCheckpoints = numCheckpoints + 1
    end
  end

  local data = {
    decimals = 1,
    enabled = true,
    label='ui.stats.followPath',
    maxPoints=0
  }

  statistics_statistics.setStatProgress(vehicle:getID(), goalName, playerInstance, data)
  running = true
end

local function onVehicleStoppedMoving(vehicleID)
  local playerVehicle = scenetree.findObject(playerInstance)
  if vehicleID == playerVehicle:getID() then
    running = false
    scenario_scenarios.endScenario(0)
  end
end

local function onFailureTimerFired(failureTime)
  -- has the player moved at all?
  local numCrossedCheckpoints = tableSize(crossedCheckpoints)
  if numCrossedCheckpoints ~= numCheckpoints then
    local vehicle = scenetree.findObject(playerInstance)
    if (vehicle:getPosition() - initialPlayerPos):len() < 0.1 then
      fail('scenarios.utah.chapter_1.chapter_1_suspension.followpath.fail.msg')
    end
  end
end

local function onBeamNGTrigger(data)
  -- log('A','suspension', 'onBeamNGTrigger called..')
  if data.event == 'enter' and data.chap1_suspension_checkpoint then
    crossedCheckpoints[data.triggerID] = true  
  end
end

local function onRaceResult()
  local vehicle = scenetree.findObject(playerInstance)
  local playerVehId = vehicle:getID()
  local numCrossedCheckpoints = tableSize(crossedCheckpoints)
  -- log('A','suspension', 'onRaceResult Number checkpoints: ' ..numCheckpoints )
  -- log('A','suspension', 'onRaceResult Crossed checkpoints: ' ..numCrossedCheckpoints )
  if numCrossedCheckpoints ~= numCheckpoints then
    statistics_statistics.setGoalProgress(playerVehId, goalName, playerInstance, {status='failed', maxPoints=nil})
    scenario_scenarios.finish({failed = "scenarios.utah.chapter_1.chapter_1_suspension.fail.msg"})
  elseif not playerHitTheWall then
    statistics_statistics.setGoalProgress(playerVehId, goalName, playerInstance, {status='failed', maxPoints=nil})
    scenario_scenarios.finish({failed = "scenarios.utah.chapter_1.chapter_1_suspension.wall.fail.msg"})
  else
    scenario_scenarios.finish({msg = "scenarios.utah.chapter_1.chapter_1_suspension.pass.msg"})
    statistics_statistics.setGoalProgress(playerVehId, goalName, playerInstance, {status='pass', maxPoints=nil})
  end

  --points = time taken + damage received
  local data = {
    label='ui.stats.followPath',
    value=numCrossedCheckpoints
  }
  statistics_statistics.setStatProgress(playerVehId, goalName, playerInstance, data)
  reset()
end

local function onObjectCollision(objA, objB)
  -- log('A', logTag, 'onObjectCollision called objA : '..objA..', objB: '..objB)
  local wall = scenetree.findObject(wallInstance)
  if wall then
    local wallID = wall:getID()
    if wallID == objA or wallID == objB then
      playerHitTheWall = true
      scenario_scenarios.endScenario(3)
    end
  end
end

M.onBeamNGTrigger = onBeamNGTrigger
M.onRaceResult = onRaceResult
M.onRaceStart = onRaceStart
M.onVehicleStoppedMoving = onVehicleStoppedMoving
M.onFailureTimerFired = onFailureTimerFired
M.onObjectCollision = onObjectCollision

return M