-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local playerInstance = 'scenario_player0'
local wallInstance = 'clone1'
local logTag = 'chapter_1_walljump'

local initialVechiclePos = nil
local initialWallPos = nil --for now represented by the center of a bounding box
local running = false
local enabledDistanceTracking = nil
local timerStart = nil
local extraTime = 10
local distanceInitialPosToWallPos = nil
local playerJumpedPastWall = false
local missedWallDelay = 0
local playerHitTheWall = false

local function reset()
  running = false
  initialVechiclePos = nil
  initialWallPos = nil
  enabledDistanceTracking = nil
  timerStart = nil
  extraTime = 10
  distanceInitialPosToWallPos = nil
  playerJumpedPastWall = false
  missedWallDelay = 0
  playerHitTheWall = false
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  running = false
end

local function pass(reason)
  scenario_scenarios.finish({msg = reason})
  running = false
end

local function onPreRender(dt)
  if not running then 
    return
  end

  if timerStart then 
    local scenario = scenario_scenarios.getScenario()
    extraTime = math.max(0, extraTime - dt)   
    if extraTime <= 0 then
      --log('E', logTag, 'timerStart: '..timerStart..', endTime: '..scenario.timer..', Diff: '..(scenario.timer - timerStart))
      pass("scenarios.utah.chapter_1.chapter_1_walljump.win.msg")
    end
  end

  if playerJumpedPastWall then
      missedWallDelay = missedWallDelay - dt
      if missedWallDelay <= 0 then
        fail("scenarios.utah.chapter_1.chapter_1_walljump.fail.msg")
      end
  end
end

-- get initial bounding box center
local function onRaceStart()
  reset()
  
  local wall = scenetree.findObject(wallInstance)
  initialWallPos = wall:getBBCenter()
  if initialWallPos == nil then
    log('E', logTag, 'wall position not found')
  end

  local vehicle = scenetree.findObject(playerInstance)
  if vehicle then
    initialVechiclePos = vehicle:getPosition()
  else
    log('E', logTag, 'vehicle position not found')
  end

  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance)  
  
  if initialWallPos and  initialVechiclePos then
    distanceInitialPosToWallPos = (initialWallPos - initialVechiclePos):len()
    running = true
  end
end

--check whether won or failed mission
local function onRaceResult()
  if running == false then
    return
  end

  local wall = scenetree.findObject(wallInstance)
  local currentWallPos = wall:getBBCenter()
  local wallMovement = (initialWallPos-currentWallPos):len()

  if playerHitTheWall ~= true then    
    fail("scenarios.utah.chapter_1.chapter_1_walljump.fail.msg")
  end
end

local function onCountdownEnded()
  local vehicle = scenetree.findObject(playerInstance)
  statistics_statistics.disableStatisticTracking(vehicle:getID(),'distance')
end

local function onUpdate()
  if not running then return end

  if not enabledDistanceTracking then
    if playerHitTheWall == true then
      enabledDistanceTracking = true
      local playerVid = be:getPlayerVehicleID(0)
      statistics_statistics.enableStatisticTracking(playerVid,'distance')
      guihooks.trigger('ScenarioFlashMessage', {{'Keep Driving!', 2}} )
      local scenario = scenario_scenarios.getScenario()
      timerStart = scenario.timer      
    end
  end

  local vehicle = scenetree.findObject(playerInstance)
  if vehicle and not playerJumpedPastWall then
    local currentPos = vehicle:getPosition()
    local distanceFromStart = (currentPos - initialVechiclePos):len()
    if distanceFromStart > distanceInitialPosToWallPos and not playerHitTheWall then
      -- user jumped but failed to hit the wall
      playerJumpedPastWall = true
      missedWallDelay = 3
    end  
  end
end

local function onCameraModeChanged(modeName)
  -- log('A', 'WallJump',' onCameraModeChanged: '.. modeName)
  if enabledDistanceTracking and modeName ~= 'observer' then
    guihooks.trigger('ScenarioFlashMessage', {{'Keep Driving!', 2}} )
    local scenario = scenario_scenarios.getScenario()
    timerStart = scenario.timer
  end
end

local function onVehicleStoppedMoving(vehicleID)
  local playerVehicle = scenetree.findObject(playerInstance)
  if not playerHitTheWall and not playerJumpedPastWall then
    if vehicleID == playerVehicle:getID() then
      fail("scenarios.utah.chapter_1.chapter_1_walljump.fail.msg")
    end
  elseif playerHitTheWall then
      pass("scenarios.utah.chapter_1.chapter_1_walljump.win.msg")
  end
end

local function onObjectCollision(objA, objB)
  -- log('A', logTag, 'onObjectCollision called objA : '..objA..', objB: '..objB)
  local wall = scenetree.findObject(wallInstance)
  if wall then
    local wallID = wall:getID()
    if wallID == objA or wallID == objB then
      playerHitTheWall = true
    end
  end
end

M.onRaceStart = onRaceStart
M.onRaceResult = onRaceResult
M.onCountdownEnded = onCountdownEnded
M.onUpdate = onUpdate
-- M.onCameraModeChanged = onCameraModeChanged
M.onPreRender = onPreRender
M.onVehicleStoppedMoving = onVehicleStoppedMoving
M.onObjectCollision = onObjectCollision
return M