-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local state = {}
M.state = state
M.dependencies = {'scenario_scenarios'}
local playerInstance = 'scenario_player0'
local targetInstance = 'clone0'

local function reset()
  state.running = false
  state.playerStartPosition = nil
  state.targetStartPosition = nil
  state.playerFell = false
  state.targetHitTheGround = false
end

local function fail(reason)
  log('I', 'chapter_2_1_ram','fail called: '..reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function success(reason)
  log('I', 'chapter_2_1_ram','success called: '..reason)
  scenario_scenarios.finish({msg = reason})
  reset()
end

local function playerFellOffCliff()
  local playerPosition = scenetree.findObject(playerInstance):getPosition()
  return math.abs(playerPosition.z - state.playerStartPosition.z) > 1
end

local function targetFellOffCliff()
  local targetPosition = scenetree.findObject(targetInstance):getPosition()
  return math.abs(targetPosition.z - state.targetStartPosition.z) > 10
end

local function onRaceStart()
  log('I', 'chapter_2_1_ram','onRaceStart called')
  reset()
  state.targetStartPosition = scenetree.findObject(targetInstance):getPosition()
  scenario_scenarios.trackVehicleMovementAfterDamage(targetInstance, {vehMomentumLimit=0.05})

  state.playerStartPosition = scenetree.findObject(playerInstance):getPosition()
  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance, {vehMomentumLimit=0.05})
  state.running = true
end

local function onRaceResult()
  log('I', 'chapter_2_1_ram','onRaceResult called....')
  if state.playerFell then
    fail('scenarios.utah.chapter_2.chapter_2_1_ram.playerfall.fail.msg')
  elseif state.targetHitTheGround then
    success('scenarios.utah.chapter_2.chapter_2_1_ram.pass.msg')
  end
end

local function onVehicleStoppedMoving(vehicleID, damaged)
  if state.running then
    -- log('I', 'chapter_2_1_ram','onVehicleStoppedMoving called '..vehicleID)
    -- local playerVehicleID = scenetree.findObject(playerInstance):getID()
    if playerFellOffCliff() then
      fail('scenarios.utah.chapter_2.chapter_2_1_ram.playerfall.fail.msg')
      return
    end

    local playerVehicleID = scenetree.findObject(playerInstance):getID()
    local targetVehicleID = scenetree.findObject(targetInstance):getID()
    if vehicleID == targetVehicleID and state.targetHitTheGround then
      scenario_scenarios.endRace(0)
    elseif vehicleID == playerVehicleID and state.playerFell then
      scenario_scenarios.endRace(0)
    end
  end
end

local function onFailureTimerFired(failureTime)
  --is the vehicle down the cliff yet?
  local vehicle = scenetree.findObject(targetInstance)
  local distance = (vehicle:getPosition() - state.targetStartPosition):len()
  if distance < 1 then
    fail('scenarios.utah.chapter_2.chapter_2_1_ram.distance.fail.msg')
  end
end

local function onVehicleTakenDamage(vehicleID, damageTaken)
  -- log('I', 'chapter_2_1_ram','onVehicleTakenDamage called '..vehicleID..' damageTaken: '..damageTaken)
  if state.running then
    local playerVehicleID = scenetree.findObject(playerInstance):getID()
    local targetVehicleID = scenetree.findObject(targetInstance):getID()

    if vehicleID == playerVehicleID and playerFellOffCliff() then
      state.playerFell = true
    elseif vehicleID == targetVehicleID and targetFellOffCliff() and not playerFellOffCliff() then
      state.targetHitTheGround = true
    end
  end
end

local function onDeserialized(data)
  -- do not delete, used to signal to serialization system that we want to have our data serialized
end

M.onRaceStart             = onRaceStart
M.onRaceResult            = onRaceResult
M.onVehicleStoppedMoving  = onVehicleStoppedMoving
M.onFailureTimerFired     = onFailureTimerFired
M.onVehicleTakenDamage    = onVehicleTakenDamage
M.onDeserialized          = onDeserialized
return M