-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local helper = require('scenario/scenariohelper')
local logTag = 'chapter_2_2_mixed'

local firstWaypointName = 'scenario_wp_1'
local finalWaypointName = 'scenario_finish1'
local playerInstance = 'scenario_player0'
local aiInstance = 'scenario_opponent'
local aggression = 0.6
local running = false
local playerWon = false
local aiWon = false

local function reset()
    running = false
    playerWon = false
    aiWon = false
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function success(reason)
  scenario_scenarios.finish({msg = reason})
  reset()
end

local function onRaceStart()
  reset()

  local arg = {vehicleName = aiInstance,
               waypoints = {'scenario_wp_1', 'scenario_wp_2', 'scenario_wp_3', 'scenario_wp_4',
                            'scenario_wp_5', 'scenario_wp_6', 'scenario_wp_7', 'scenario_wp_8',
                            'scenario_wp_9', 'scenario_wp_10', 'scenario_wp_11', finalWaypointName,
                            'scenario_AILastTarget'},
                            aggression = 1
              }
  helper.setAiPath(arg)

  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance, {waitTimerLimit=2})
  running = true
end


local function onRaceWaypointReached(data)
  -- log('I', logTag,'onRaceWaypointReached called playerWon: '..tostring(playerWon)..' AIWon: '..tostring(aiWon))
  -- dump(data)
  if data.waypointName == finalWaypointName then
    if data.vehicleName == playerInstance and not aiWon then
      playerWon = true
    elseif data.vehicleName == aiInstance and not playerWon then
      aiWon = true
    end
  end

  if data.waypointName == firstWaypointName and data.vehicleName == aiInstance then
    helper.setAiAggression(aiInstance, aggression)
  end
end

local function onRaceResult()
  if playerWon then
    local scenario = scenario_scenarios.getScenario()
    if campaign_campaigns and campaign_campaigns.getCampaignActive() and scenario and scenario.scenarioKey then
      local scenarioData = campaign_campaigns.getActiveSubsectionLocationData(scenario.scenarioKey)
      local rewards = campaign_rewards.getScenarioReward(scenarioData, 'onSucceed')
      if rewards and #rewards > 0 then
        rewardMoney = rewards[1].value
      end
    end

    success({txt = "scenarios.utah.chapter_2.chapter_2_2_mixed.pass.msg", context = {reward = tostring(rewardMoney)}})
  else
    fail('scenarios.utah.chapter_2.chapter_2_2_mixed.fail.msg')
  end
end

local function onVehicleStoppedMoving(vehicleID, damaged)
  if not running then return end

  local playerVehicleID = scenetree.findObject(playerInstance):getID()
  if vehicleID == playerVehicleID and damaged then
    scenario_scenarios.endRace(0)
  end
end

M.onRaceStart = onRaceStart
M.onRaceResult = onRaceResult
M.onRaceWaypointReached = onRaceWaypointReached
M.onVehicleStoppedMoving = onVehicleStoppedMoving

return M