-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local helper = require('scenario/scenariohelper')
local logTag = 'chapter_2_3_crawl'

local finalWaypointName = 'scenario_finish1'
local playerInstance = 'scenario_player0'
local aiInstance = 'scenario_opponent'
local aggression = 0.5
local running = false
local playerWon = false
local aiWon = false

local function reset()
  running = false
  playerWon = false
  aiWon = false
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function success(reason)
  scenario_scenarios.finish({msg = reason})
  reset()
end

local function onRaceStart()
  reset()

  local arg = {vehicleName = aiInstance, waypoints = scenario_scenarios.getScenario().lapConfig,
              aggression = 1
              }

  helper.setAiPath(arg)

  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance, {waitTimerLimit=2})

  running = true
end

local function onRaceWaypointReached(data)
  --log('I', logTag,'onRaceWaypointReached called ')
  --dump(data)
  if data.waypointName == finalWaypointName then
    if data.vehicleName == playerInstance and not aiWon then
      playerWon = true
    elseif data.vehicleName == aiInstance and not playerWon then
      aiWon = true
    end
  end

  if data.waypointName == scenario_scenarios.getScenario().lapConfig[1] and data.vehicleName == aiInstance then
    helper.setAiAggression(aiInstance, aggression)
  end
end

local function onRaceResult()
  if playerWon then
    success('scenarios.utah.chapter_2.chapter_2_3_crawl.pass.msg')
  else
    fail('scenarios.utah.chapter_2.chapter_2_3_crawl.fail.msg')
  end
end

local function onVehicleStoppedMoving(vehicleID, damaged)
  if running then
    local playerVehicleID = scenetree.findObject(playerInstance):getID()
    if vehicleID == playerVehicleID and damaged then
      if not playerWon then
        fail('scenarios.utah.chapter_2.chapter_2_3_crawl.fail.msg')
      end
    end
  end
end

M.onRaceStart = onRaceStart
M.onRaceWaypointReached = onRaceWaypointReached
M.onRaceResult = onRaceResult
M.onVehicleStoppedMoving = onVehicleStoppedMoving

return M