//-----------------------------------------------------------------------------
// Copyright (c) 2012 GarageGames, LLC
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//-----------------------------------------------------------------------------

// This is the default save location for any ForestBrush(s) created in 
// the Forest Editor.
// This script is executed from ForestEditorPlugin::onWorldEditorStartup().

//--- OBJECT WRITE BEGIN ---
new SimGroup(ForestBrushGroup) {
   canSave = "1";
   canSaveDynamicFields = "1";

   new ForestBrush() {
      internalName = "Trees_Dead";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_dead_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_dead_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_dead_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_dead_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_dead_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_dead_b";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_dead_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_dead_a";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "ExampleForestBrush";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "ExampleElement";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "ExampleForestMesh";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2";
         scaleExponent = "0.2";
         sinkMin = "0";
         sinkMax = "0.1";
         sinkRadius = "0.25";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-10000";
         elevationMax = "10000";
            clumpCountExponent = "1";
            clumpCountMax = "1";
            clumpCountMin = "1";
            clumpRadius = "10";
      };
   };
   new ForestBrush() {
      internalName = "Grass_mesh";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "grass_field_filler";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grass_field_filler";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "grass_field_long";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grass_field_long";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "grass_field_sml";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grass_field_sml";
         probability = "10";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "grass_field_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grass_field_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "0";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "vines";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "vine_side_8m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_side_8m";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_side_4m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_side_4m";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_side_2m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_side_2m";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_side_1m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_side_1m";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_roof_wide";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_roof_wide";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_roof_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_roof_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_roof_end";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_roof_end";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_ground_medium";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_ground_medium";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_ground_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_ground_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_ground_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_ground_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_wide_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_wide_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_wide_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_wide_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_medium";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_medium";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_bush_wide";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_bush_wide";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_bush_wide_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_bush_wide_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_bush_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_bush_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_bush_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_bush_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Lush";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "lush_general_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_a";
         probability = "2";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_general_01_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_b";
         probability = "10";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_general_01_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_general_01_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_general_01_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_ferns_02_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_ferns_02_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_ferns_02_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_ferns_02_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_big_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_big_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_big_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_big_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "NeedFix";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "lush_grass_01_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_grass_01_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_grass_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_grass_01_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_grass_01_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_grass_01_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_oak";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "oak_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_a";
         probability = "0.3";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_b";
         probability = "0.7";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_forest_canopy_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_canopy_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_forest_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_forest_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_sml_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_sml_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_sml_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "oak_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_Aspen";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_large_a";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_large_b";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_low_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_low_group";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.7";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_low";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_low";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_d";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_c";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_b";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_a";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_forest_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_forest_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_forest_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_forest_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_overhang_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_overhang_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_Beech";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_beech_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_forest_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_forest_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_forest_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_forest_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "35";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.4";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "35";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_small_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_small_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.7";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "35";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_overhang_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_overhang_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_palm";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_palm_f";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_f";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_overhang_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_overhang_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_overhang_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_overhang_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_Blocker";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_blocker_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_blocker_a";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "1";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_blocker_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_blocker_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_blocker_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_blocker_a";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Ferns";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "lush_ferns_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_ferns_01_a";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_ferns_01_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_ferns_01_b";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "39.3042";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Bushes_huge";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_beech_bush_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.32";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Bushes_large";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_b";
         probability = "3";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_c";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Bushes_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_a";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "rocks_01_a_large";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "rock_01_a_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "rocks_01_a_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "rock_01_a_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrushElement() {
      internalName = "utah_greybush_01";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "utah_greybush_01";
      probability = "1";
      rotationRange = "360";
      scaleMin = "1";
      scaleMax = "1.5";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrush() {
      internalName = "utah_rocks_big";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "utah_rock_big_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_big_c";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "utah_rock_big_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_big_d";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "utah_rock_big_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_big_b";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "utah_rock_big_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_big_a";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "utah_rocks_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "utah_rock_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_small_a";
         probability = "0.3";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "utah_rock_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "utah_rock_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "utah_rock_small_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_small_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "utah_rock_small_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "utah_rock_small_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "utah_cliffs_big";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "Utah_cliff_stand_01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_stand_01";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_straight_50";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_straight_50";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_straight_25";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_straight_25";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_straight_50_concave";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_straight_50_concave";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_straight_50_convex";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_straight_50_convex";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_straight_150";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_straight_150";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_straight_150b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_straight_150b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_slope_50a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_slope_50a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_slope_50b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_slope_50b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_slope_50c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_slope_50c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_slope_50d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_slope_50d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "utah_cliffs_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "Utah_cliff_s_slope_23b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_slope_23b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_slope_23a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_slope_23a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_straight_50";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_straight_50";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_straight_20";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_straight_20";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_straight_10";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_straight_10";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_single_04";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_single_04";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_single_03";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_single_03";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_single_02";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_single_02";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_single_01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_single_01";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_90_convex";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_90_convex";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Utah_cliff_s_90_concave";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Utah_cliff_s_90_concave";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
};
//--- OBJECT WRITE END ---
