-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- In other words, if you are a modder feel free to reuse this code with above license

--If you reload Lua with CTRL+L use thise in the GE console `

local windowOpen = ui_imgui.BoolPtr(true)

local M = {}
M.dependencies = {"ui_imgui"}
local im = ui_imgui
local ffi = require("ffi")
local imguiUtils = require('ui/imguiUtils')

local internal = not shipping_build or not string.match(beamng_windowtitle, "RELEASE")

local TorqueScriptLua = TorqueScriptLua

--independent GUI
local showUI = nil
local tempFloat = nil
local pos = im.ImVec2(0, 0)
local sizeMin = im.ImVec2(0, 0)
local sizeMax = im.ImVec2(-1, -1)
local lastValue

--scenetree
local objects = nil

local shadowvalue = nil

local tod = nil

--light
local light = nil

local waitForFrame = 0
local offsetBias = im.FloatPtr(0)
local offsetval
local frameval
local frameBias = im.FloatPtr(0)

local lightmgr
local shadowdisable = 0
local dynLight = true
local enableShadows = false
local smartShadows = true

local playerPosDebugEnabled = false
local skipCameraEnabled = false
local skipRealTime = false

local lastjobCount

--weather
local rainamnt = nil
local fogscaleval = nil
local colorval = nil
local sunval = nil
local ambientval = nil
local fogamnt = nil
local vol = nil
local fogatm = nil

local roughnessVal = nil 
local groundVal = nil
local emissiveVal = nil
local winVal = nil
local isWet = 0
local isSnow = 0

local decalroad = nil

--lod stuff
local LOD
local LODDEF
local lodBias = im.FloatPtr(0)

--renderdistance
local renderBias = im.FloatPtr(0)
local defaultDistance

--speed trap
local speed
local speedLimit = nil
local location = ""
local data
local speedData
local unit = tostring( settings.getValue("uiUnitLength") )
local speedtrapFilePath
local showBoard = false
local oldversion = nil
local changed_version = false

--bigmap
local bigmapvalue = 0

--teleport
local otherLevelPath = "/levels/whsd/info.json"
local otherLevelPath2 = "/levels/whsd/info.json"
local playerisintrigger = nil
local promptTitle = "Teleport"
local teleportTempFile = "/temp/spb_teleport.json"

--level data
local levelfolder = nil
local levelname =  nil
local tool_version = "2.0"
local appTitle = " CK Map Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch
local speedTitle = "Speedcamera - Leaderboard ".. "no-init"


local toolWindowName = 'map_controller'

local function onClientStartMission()
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  log('I', '', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  --print(levelname)
  log('I', '', 'Level is loaded' )
  levelfolder = ("/levels/" .. levelname .. "/")
  appTitle = " CK Map Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
  speedTitle = "Speedcamera - Leaderboard ".. levelname
  if TorqueScriptLua then
    log("I", "", "onCLientStartMission get LOD variable")
    LOD = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust"))
    LODDEF = LOD
    defaultDistance = scenetree.theLevelInfo.visibleDistance
    speedtrapFilePath = 'settings/cloud/ck-'..levelname..'-speedtrap.json'
    speedData = jsonReadFile(speedtrapFilePath)
    lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
    log('I', '', lightmgr )
    shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
    log('I','', shadowdisable )
  end
end

--get scene tree all objects
local function getSimObjects(fileName)
  local ret = {}
  local objs = scenetree.getAllObjects()
  --log('E', '', '# objects existing: ' .. tostring(#scenetree.getAllObjects()))
  for _, objName in ipairs(objs) do
    local o = scenetree.findObject(objName)
    if o and o.getFileName then
      if o:getFileName() == fileName then
        table.insert(ret, o)
      end
    end
  end
  return ret
  --log('E', '', '# objects left: ' .. tostring(#scenetree.getAllObjects()))
end

local function getFontList()
  local fonts = {}
  for i = 0, im.IoFontsGetCount() - 1 do
    table.insert(fonts,
    {
      name = ffi.string(im.IoFontsGetName(i))
    })
  end
  return fonts
end

--Hide Elements of map

local function setHiddenRec(object, hidden)
  object.hidden = hidden
  if object:isSubClassOf("SimSet") then
    for i=0, object:size() - 1 do
      setHiddenRec(object:at(i), hidden)
    end
  end
end

local function hideGroup(groupName, hidden)
  if not groupName then
    log('E', "", "Group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Group is missing, please contact level author', icon = "goat"})
  else
  local group = scenetree.findObject(groupName)
  if group then setHiddenRec(group, hidden) end
  end
end

--change material data
local function setMaterialProperty(material, property, layer, value)
  --guihooks.trigger('menuHide')
  --guihooks.trigger('app:waiting', true)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material.___type == "class<Material>" then
    material:setField(property, layer, value)
    --we do not want to flush materials
    --material:flush()
    --print("reloading material")
    material:reload()
    --guihooks.trigger('app:waiting', false) -- shows the loading icon
    return true
  else
    log('E', "", "Given object is not a material.")
    return false
  end
end
local lightTable = {}

--Dynamic Lights
local function setAllLightsEnabled(group, value)
  if not group then
    log('E', "", "Night lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Night lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj.obj:isSubClassOf('LightBase') then
          obj.obj:setLightEnabled( value )
      end
  end
end
end

--DynamicPositionBasedLights
local function setAllLightsPosEnabled(job, group, value, pos1, pos2, shdwpos1, shdwpos2, shadowvalue)
  if not group then
    log('E', "", "Lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Lights group is missing, please contact level author', icon = "goat"})
  else
  --reset table every refresh
  lightTable = {}
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      job.sleep(0.00001) -- sleep for one frame, evens impact on performance

      if obj and obj.obj:isSubClassOf('LightBase') then
        local pos = string.split(obj.obj:getField('position', 0))
        local posX = tonumber(pos[1])
        local posY = tonumber(pos[2])
        local posZ = tonumber(pos[3])
        if posX > pos1.x and posY > pos1.y and posZ > pos1.z and posX < pos2.x and posY < pos2.y and posZ < pos2.z then
          obj.obj:setLightEnabled( value )
          --get position of enabled lights
          if playerPosDebugEnabled == true then
            local pos = string.split(obj.obj:getField('position', 0))
            local posX = tonumber(pos[1])
            local posY = tonumber(pos[2])
            local posZ = tonumber(pos[3])
            local lightpos = vec3(posX, posY, posZ)
            table.insert(lightTable, lightpos)
          end
          if smartShadows == true then
            if posX > shdwpos1.x and posY > shdwpos1.y and posZ > shdwpos1.z and posX < shdwpos2.x and posY < shdwpos2.y and posZ < shdwpos2.z then
              obj.castShadows = shadowvalue
            else
              obj.castShadows = false
            end
          end
        else
          obj.obj:setLightEnabled( false )
        end
      end
    end
  end
end

--DynamicShadows
local function setAllLightsShadowsEnabledDisabled(group, shadowvalue)
  if not group then
    log('E', "", "Night lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Night lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    light = scenetree.findObjectById(id)
    light.castShadows = shadowvalue
  end
  guihooks.trigger('Message', {ttl = 10, msg = 'Shadows Changed', icon = "goat"})
end
end

--debug stuph
local OffsetA
local OffsetB
local ShdwOffsetA
local ShdwOffsetB
local playerPos
local playerRot
local freeCam

local function onPlayerPosition(group, value)
  --fallback offset
  local offset = vec3(1000,1000,1000)
  local shdwoffset = vec3(256,256,256)
  --debug offset for now
  --local offset = vec3(data,data,data)
  local veh
  veh = be:getPlayerVehicle(0)
  --would be nice to know if user is using free cam for photos/gameplay
  freeCam = commands.isFreeCamera()
  --update pos every 100 frames
  if waitForFrame <= 0 then
    waitForFrame = 100
    if frameval then
      waitForFrame = frameval
    end
  end
  if veh or freeCam then
    if skipCameraEnabled == true and playerPosDebugEnabled == true and veh then
      playerPos = vec3(veh:getPosition())
      local matrix = veh:getRefNodeMatrix()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    elseif freeCam then
      playerPos = vec3(getCameraPosition())
      local camera = commands.getCamera()
      local controlId = camera:getID()
      local sobj = scenetree[controlId]
      local matrix = sobj:getTransform()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    else
      playerPos = vec3(veh:getPosition())
      local matrix = veh:getRefNodeMatrix()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    end
    if playerPos then
      if offsetval then
        offset = vec3(offsetval,offsetval,offsetval)
      end
      --print(playerRot)
      if playerRot <= 340 and playerRot >= 250 or playerRot <= 150 and playerRot >= 60 then
        shdwoffset = vec3(256,128,24)
      end
      if playerRot <= 250 and playerRot >= 150 or playerRot <= 60 or playerRot >= 340 then
        shdwoffset = vec3(128,256,24)
      end
      OffsetA = playerPos - offset
      OffsetB = playerPos + offset
      ShdwOffsetA = playerPos - shdwoffset
      ShdwOffsetB = playerPos + shdwoffset
      --local relativePosWid = relativePos:width()
      --we set lights through background task to reduce stutter
      extensions.core_jobsystem.create(setAllLightsPosEnabled, 1, group, value, OffsetA, OffsetB, ShdwOffsetA, ShdwOffsetB, true)
    end
  end
end


--get player vehicle
local function getCurrentVehicle()
  local result = nil
  if gameplay_walk and gameplay_walk.isWalking() then
    return result
  end

  -- get the current vehicle to load it in the garage
  local vehicle = be:getPlayerVehicle(0)
  local playerVehicleData = core_vehicle_manager.getPlayerVehicleData()
  if vehicle and playerVehicleData then
    local config = serialize(playerVehicleData.config) -- when using "vehicle.partConfig" here, the color of the vehicle will be wrong if you use a custom default config
    local model = vehicle.JBeam
    result = { model, {config=config} }
  end
  return result
end


--player position debug
local function playerPosDebug()
  if freeCam and skipCameraEnabled == false then
  else
    debugDrawer:drawSphere(playerPos, 0.5, ColorF(0, 1, 0, 0.5))
    debugDrawer:drawTextAdvanced((playerPos),
    "Last player position",
    ColorF(1,1,1,1),true, false, ColorI(0,0,0,255))
  end
  --offset
  local debugoffsetA1 = vec3(OffsetA.x,OffsetB.y,OffsetA.z)
  local debugoffsetA2 = vec3(OffsetB.x,OffsetA.y,OffsetA.z)
  local debugoffsetA3 = vec3(OffsetB.x,OffsetB.y,OffsetA.z)

  local debugoffsetB1 = vec3(OffsetB.x,OffsetA.y,OffsetB.z)
  local debugoffsetB2 = vec3(OffsetA.x,OffsetB.y,OffsetB.z)
  local debugoffsetB3 = vec3(OffsetA.x,OffsetA.y,OffsetB.z)

  --debug drawing
  debugDrawer:drawCylinder(OffsetA, debugoffsetA1, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(OffsetA, debugoffsetA2, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetA2, debugoffsetA3, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetA1, debugoffsetA3, 1, ColorF(0,0,1,0.3))

  debugDrawer:drawCylinder(OffsetB, debugoffsetB1, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(OffsetB, debugoffsetB2, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetB2, debugoffsetB3, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetB1, debugoffsetB3, 1, ColorF(0,0,1,0.3))

  debugDrawer:drawCylinder(debugoffsetB2, debugoffsetA1, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(OffsetA, debugoffsetB3, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(OffsetB, debugoffsetA3, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetB1, debugoffsetA2, 1, ColorF(0,0,1,0.3))

  if smartShadows == true then
      --offset
  local shdwdebugoffsetA1 = vec3(ShdwOffsetA.x,ShdwOffsetB.y,ShdwOffsetA.z)
  local shdwdebugoffsetA2 = vec3(ShdwOffsetB.x,ShdwOffsetA.y,ShdwOffsetA.z)
  local shdwdebugoffsetA3 = vec3(ShdwOffsetB.x,ShdwOffsetB.y,ShdwOffsetA.z)

  local shdwdebugoffsetB1 = vec3(ShdwOffsetB.x,ShdwOffsetA.y,ShdwOffsetB.z)
  local shdwdebugoffsetB2 = vec3(ShdwOffsetA.x,ShdwOffsetB.y,ShdwOffsetB.z)
  local shdwdebugoffsetB3 = vec3(ShdwOffsetA.x,ShdwOffsetA.y,ShdwOffsetB.z)

  --debug drawing
  debugDrawer:drawCylinder(ShdwOffsetA, shdwdebugoffsetA1, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(ShdwOffsetA, shdwdebugoffsetA2, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetA2, shdwdebugoffsetA3, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetA1, shdwdebugoffsetA3, 1, ColorF(0,1,1,0.3))

  debugDrawer:drawCylinder(ShdwOffsetB, shdwdebugoffsetB1, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(ShdwOffsetB, shdwdebugoffsetB2, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetB2, shdwdebugoffsetB3, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetB1, shdwdebugoffsetB3, 1, ColorF(0,1,1,0.3))

  debugDrawer:drawCylinder(shdwdebugoffsetB2, shdwdebugoffsetA1, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(ShdwOffsetA, shdwdebugoffsetB3, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(ShdwOffsetB, shdwdebugoffsetA3, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetB1, shdwdebugoffsetA2, 1, ColorF(0,1,1,0.3))
  end

  for k,v in pairs(lightTable) do
    debugDrawer:drawSphere(v, 0.5, ColorF(1, 0, 0, 0.5))
  end
end

--Gameengine decal road workaround
local function fixDecalRoad(group)
  if not group then
    log('E', "", "Night reflection group is missing, please contact level author")
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    decalroad = scenetree.findObjectById(id)
    decalroad.renderPriority = 9
    decalroad.renderPriority = 10
  end
end
end

--DynamicWeather
local function setWeather(fogscaleval, colorval, sunval, ambientval, fogamnt, group, rainamnt, vol, fogatm)
    core_environment.setFogScaleGradientFile(fogscaleval)
    core_environment.setColorizeGradientFile(colorval)
    core_environment.setSunScaleGradientFile(sunval)
    core_environment.setAmbientScaleGradientFile(ambientval)
    core_environment.setTimeOfDay(tod)
    core_environment.setFogDensity(fogamnt)
    core_environment.setFogAtmosphereHeight(fogatm)
    --core_environment.setPrecipitation(rainamnt)
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local precipitation = scenetree.findObjectById(id)
      local sfx = scenetree.findObjectById(id)
      precipitation.numDrops = rainamnt
      sfx.volume = vol
      sfx:postApply()
    end
    guihooks.trigger('Message', {ttl = 10, msg = 'Weather Changed', icon = "goat"})
end

--DYNAMIC MATERIALS SYSTEM - 2022 Car_Killer
--WET/DRY Section
local function setDryWetMaterials(roughnessVal, groundVal)
  log('I', "", "Switching Materials...")
  if levelname == nil then
    log('E', "", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
  local materialFiles = FS:findFiles(levelfolder, "road.materials.json", -1, true, false)
  log('D', '', dumps(materialFiles))
  for _, fn in ipairs(materialFiles) do
    local dir, basefilename, ext = path.splitWithoutExt(fn)

    if string.find(fn, 'materials.cs$') then
      TorqueScript.exec(fn)
      objects = getSimObjects(fn)
    elseif string.find(fn, 'materials.json$') then
      loadJsonMaterialsFile(fn)
      objects = getSimObjects(fn)
    end

    if not tableIsEmpty(objects) then
      log('I', '', 'parsing all materials file: ' .. tostring(fn))

      for _, obj in ipairs(objects) do
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Roughness: ' .. tostring(obj:getField('roughnessFactor', 0)) )
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - GroundType: ' .. tostring(obj:getField('groundType', 0)) )
        setMaterialProperty(obj:getName(), 'roughnessFactor', 0, roughnessVal)
        setMaterialProperty(obj:getName(), 'groundType', 0, groundVal)
      end

    end
  end
  be:reloadCollision()
  log('I', "", "Switching Done!")
end
end
--emission Section
local function setEmissionMaterials(emissiveVal)
  log('I', "", "Switching Materials...")
  if levelname == nil then
    log('E', "", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
  local materialFiles = FS:findFiles(levelfolder, "emission.materials.json", -1, true, false)
  log('D', '', dumps(materialFiles))
  for _, fn in ipairs(materialFiles) do
    local dir, basefilename, ext = path.splitWithoutExt(fn)

    if string.find(fn, 'materials.cs$') then
      TorqueScript.exec(fn)
      objects = getSimObjects(fn)
    elseif string.find(fn, 'materials.json$') then
      loadJsonMaterialsFile(fn)
      objects = getSimObjects(fn)
    end

    if not tableIsEmpty(objects) then
      log('I', '', 'parsing all materials file: ' .. tostring(fn))

      for _, obj in ipairs(objects) do
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Layers: ' .. tostring(obj:getField('activeLayers', 0)) )
        setMaterialProperty(obj:getName(), 'activeLayers', 0, emissiveVal)
      end

    end
  end
  log('I', "", "Switching Done!")
end
end
-- winter experiment
local function setWinterMaterials(winVal, groundVal)
  log('I', "", "Switching Materials...")
  if levelname == nil then
    log('E', "", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
  local materialFiles = FS:findFiles(levelfolder, "road.materials.json", -1, true, false)
  log('D', '', dumps(materialFiles))
  for _, fn in ipairs(materialFiles) do
    local dir, basefilename, ext = path.splitWithoutExt(fn)

    if string.find(fn, 'materials.cs$') then
      TorqueScript.exec(fn)
      objects = getSimObjects(fn)
    elseif string.find(fn, 'materials.json$') then
      loadJsonMaterialsFile(fn)
      objects = getSimObjects(fn)
    end

    if not tableIsEmpty(objects) then
      log('I', '', 'parsing all materials file: ' .. tostring(fn))

      for _, obj in ipairs(objects) do
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Layers: ' .. tostring(obj:getField('activeLayers', 0)) )
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - GroundType: ' .. tostring(obj:getField('groundType', 0)) )
        setMaterialProperty(obj:getName(), 'activeLayers', 0, winVal)
        setMaterialProperty(obj:getName(), 'groundType', 0, groundVal)
      end

    end
  end
  be:reloadCollision()
  log('I', "", "Switching Done!")
end
end

--speed trap
local function onSpeedTrap(data, speedLimit, location)
  --we need to ticket players only
  local playerveh = be:getPlayerVehicleID(0)
  local veh
  local user
  --check if steam is working
  if Steam and Steam.isWorking and Steam.accountLoggedIn then
    user = Steam.playerName
  end
  if data.subjectID == playerveh then
    veh = be:getObjectByID(data.subjectID)
    local vehname
    if user == nil then
      user = veh:getDynDataFieldbyName("licenseText", 0)
    end
    local conditions
    --prevent leaking internal vehicles to online leaderboard
    if internal then
      vehname = "INTERNAL BUILD"
    else
      local currentVehicle = core_vehicles.getCurrentVehicleDetails()
      if currentVehicle.model and currentVehicle.model.Name then
        if currentVehicle.model.Brand then
          vehname = currentVehicle.model.Brand .. " " .. currentVehicle.model.Name
        else
          vehname = currentVehicle.model.Name
        end
      end
      --print(vehname)
    end

    --get condition data
    if isWet == 1 then
      conditions = "Rain"
    else
      conditions = "Dry"
    end
    if isSnow == 1 then
      conditions = "Snow"
    else
      conditions = "Dry"
    end

    speedLimit = speedLimit /3.6
    local speedVec = vec3(veh:getVelocity(veh:getRefNodeId()) )
    local dir = vec3(veh:getDirectionVector())
    --log("D", "", "speedVec = "..dumps(speedVec))
    --log("D", "", "dir = "..dumps(dir))
    speed = dir:dot(speedVec) -- we use the speed on the axis of the camera only
    if speed > speedLimit * 1.05 then --added a few KMH so the limit is not too strict
      Engine.Audio.playOnce('AudioGui', "/levels/c1/art/sound/trap.ogg")
      local msgRadar = "speeding!!!"
      if ( unit or 'metric') == "metric" then
        msgRadar = string.format("You are speeding %0.1f km/h instead of %0.1f km/h", speed*3.6, speedLimit*3.6)
      else
        msgRadar = string.format("You are speeding %0.1f mph instead of %0.1f mph", speed*2.23694, speedLimit*2.23694)
      end
      guihooks.trigger('Message', {ttl = 5, msg = msgRadar.. " on " ..location.. " with "..vehname, category = "speedtrap", icon = "photo_camera"})

      --generate file if it doesnt exist
      if speedtrapFilePath ~= nil then
        speedData = jsonReadFile(speedtrapFilePath) or {}
        if not speedData.speedtrap then
          speedData.speedtrap = {}
          speedData.version = tool_version
        end
        if not speedData.version then
          speedData.speedtrap = {}
          changed_version = true
          oldversion = "0"
          log('W', "", "unable to detect version, resetting data")
          speedData.version = tool_version
          local res = jsonWriteFile(speedtrapFilePath, speedData, true)
          if not res then
            log('W', "", "unable to save speed")
          end
        end

        if speedData.version ~= tool_version then
          oldversion = speedData.version
          speedData.speedtrap = {}
          changed_version = true
          log('W', "", "version mismatch, resetting data")
          speedData.version = tool_version
          local res = jsonWriteFile(speedtrapFilePath, speedData, true)
          if not res then
            log('W', "", "unable to save speed")
          end
        end
        --if there is no location, add it to the file
        if not speedData.speedtrap[location] then
          speedData.speedtrap[location] = {}
          speedData.speedtrap[location].vehicle = vehname
          speedData.speedtrap[location].conditions = conditions
          speedData.speedtrap[location].speed = speed
          speedData.speedtrap[location].user = user
          speedData.speedtrap[location].speedLimit = speedLimit
          local res = jsonWriteFile(speedtrapFilePath, speedData, true)
          if not res then
            log('W', "", "unable to save speed")
          end

          --get amount of all speed traps
          local locationamnt = scenetree.trap:getCount()

          local count = 0
          for _ in pairs(speedData.speedtrap) do count = count + 1 end
          print(count)
          guihooks.trigger('Message', {ttl = 10, msg = "Speedtraps found: "..count.."/"..locationamnt, category = "newtrap", icon = "plus_one"})
        end
        --dump(speedData.speedtrap)
        --if new personal best, save to file
        if speed > speedData.speedtrap[location].speed then
          local oldspeed = speedData.speedtrap[location].speed
          local diffspeed = speed - oldspeed
          speedData.speedtrap[location].vehicle = vehname
          speedData.speedtrap[location].conditions = conditions
          speedData.speedtrap[location].speed = speed
          speedData.speedtrap[location].user = user
          speedData.speedtrap[location].speedLimit = speedLimit
          local res = jsonWriteFile(speedtrapFilePath, speedData, true)
          if not res then
            log('W', "", "unable to save speed")
          end
          local msgPb = "new pb"
          if ( unit or 'metric') == "metric" then
            msgPb = string.format("New record! %0.1f km/h vs %0.1f km/h, +%0.1f km/h", speed*3.6, oldspeed*3.6, diffspeed*3.6)
          else
            msgPb = string.format("New record! %0.1f mph vs %0.1f mph, +%0.1f mph", speed*2.23694, oldspeed*2.23694, diffspeed*2.23694)
          end
          guihooks.trigger('Message', {ttl = 10, msg = msgPb, category = "newpb", icon = "flag"})
          Engine.Audio.playOnce('AudioGui','event:>UI>Generic>Click_Tonal_Small')
        end
      end
    end
  end
end

--simple dynamic level cubemap experiment
local cubemapname

local function setCubemap(cubemapname)
  if cubemapname then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "", "Enabling cubemap " ..cubemapname)
      levelinf:setField('globalEnviromentMap', 0, cubemapname)
      levelinf:postApply()
    else
      log("W", "", "Enabling fallback cubemap " ..cubemapname)
      setConsoleVariable("$defaultLevelEnviromentMap", cubemapname)
    end
  end
end

local function toUnit(speed)
  if ( unit or 'metric') == "metric" then
    --im.Text(tostring(math.ceil(speed*3.6)).." km/h")
    im.Text(string.format("%g",string.format("%.1f",speed*3.6)).." km/h")
  else
    im.Text(string.format("%g",string.format("%.1f",speed*2.23694)).." mph")
  end
end

local cubevalue = false

local function onUpdate(dtReal)
  if luaLoaded == false then
    extensions.mainLevel.onClientStartMission()
  end

  if playerisintrigger == 1 or playerisintrigger == 2 or playerisintrigger == 3 or playerisintrigger == 4 then
    local addonmap = nil
    if playerisintrigger == 1 then
      addonmap = FS:fileExists(otherLevelPath)
    elseif playerisintrigger == 2 then
      addonmap = FS:fileExists(otherLevelPath2)
    elseif playerisintrigger == 3 or playerisintrigger == 4 then
      addonmap = true
    end
    local win = im.GetMainViewport()

    local image2 = imguiUtils.texObj('/levels/spb/tp_whsd.png')
    local image2size = im.ImVec2(640, 480)
    -- set position
    pos.x = win.Pos.x + win.Size.x / 2
    pos.y = win.Pos.y + win.Size.y / 2
    im.SetNextWindowPos(pos, im.ImGuiCond_Always, im.ImVec2(0.5, 0.5))
    im.SetNextWindowBgAlpha(0.7)

    im.Begin(promptTitle, nil, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize+im.WindowFlags_NoMove+im.WindowFlags_NoCollapse+im.WindowFlags_NoDocking+im.WindowFlags_NoTitleBar)
    im.PushFont3("cairo_bold")
    if addonmap == true then
      im.SetWindowFontScale(2.0)
      im.Text("\n       Do you want to switch to another map?        \n ")
      if playerisintrigger == 1 then
        if im.Button("WHSD", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          local teleportTable = {targetPos = vec3(76.423, -91.743, -15.6), targetRot = quatFromEuler(0, 0, 0)}
          jsonWriteFile(teleportTempFile, teleportTable, true)
          freeroam_freeroam.startFreeroam(otherLevelPath, nil, nil, getCurrentVehicle())
        end
      elseif playerisintrigger == 2 then
        if im.Button("Central Stalburg Alleys", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          local teleportTable = {targetPos = vec3(-51.128, 272.256, -1.8), targetRot = quatFromEuler(0, 0, math.rad(-19))}
          jsonWriteFile(teleportTempFile, teleportTable, true)
          freeroam_freeroam.startFreeroam(otherLevelPath2, nil, nil, getCurrentVehicle())
        end
      elseif playerisintrigger == 3 then
        if im.Button("Shipyard", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          spawn.safeTeleport(be:getPlayerVehicle(0), vec3(10.794, 356.729, -0.89), quat(0,0,1,0) * quatFromEuler(0, 0, math.rad(-90)), nil, nil, nil, nil, false)
          playerisintrigger = 0
          core_camera.resetCamera(0)
        end
      elseif playerisintrigger == 4 then
        if im.Button("Train Tracks", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          spawn.safeTeleport(be:getPlayerVehicle(0), vec3(172.323, -150.711, -0.3), quat(0,0,1,0) * quatFromEuler(0, 0, math.rad(90)), nil, nil, nil, nil, false)
          playerisintrigger = 0
          core_camera.resetCamera(0)
        end
      end
      if im.Button("Stay Here", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
        playerisintrigger = 0
      end
    else
      im.SetWindowFontScale(1.65)
      if playerisintrigger == 1 then
        im.Text("This feature requires the WHSD(Saint Petersburg) mod. This can be downloaded from the repository link below, come back once it has been installed")
      elseif playerisintrigger == 2 then
        im.Text("This feature requires the Central Stalburg Alleys, Stalburg mod. This can be downloaded from the repository link below, come back once it has been installed")
      end
      im.Text("")
      im.Image(image2.texId, image2size, im.ImVec2(0, 0), im.ImVec2(1, 1), col)
      im.Text("")
      im.SetWindowFontScale(1.2)
      if im.Button("Download (beamng.com)", im.ImVec2(120, 0)) then
        playerisintrigger = 0
        openWebBrowser("https://www.beamng.com/resources/authors/sherman_.567620/")
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text("Open BeamNG Repository in your web browser")
        im.EndTooltip()
      end
    end
    im.PopFont()
    im.SetWindowFontScale(1.0)
    im.End()
  end
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  if freeroam_bigMapMode then
    local dont_showUI = freeroam_bigMapMode.bigMapActive() == true or photoModeOpen
  end
  if not dont_showUI then
   --imgui app
  im.Begin(appTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  tod = scenetree.tod
  if not tod then
  im.Text("There is no TOD")
  im.Text("")
  else
  im.Text("Lod Bias")
  lodBias[0] = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust") or 1) * 100
  im.PushItemWidth(100)
  if im.SliderFloat("", lodBias, 1, 800, "%.1f") then
    LOD = lodBias[0] / 100
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LOD)
  end
  im.SameLine()
  if im.Button("Reset LOD") then
    if LODDEF == nil then
      TorqueScriptLua.setVar("$pref::TS::detailAdjust", 1)
    else
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
    end
  end

  --far clip settings
  im.Text("View Distance")
  renderBias[0] = scenetree.theLevelInfo.visibleDistance or 3000
  im.PushItemWidth(100)
  if im.SliderFloat("##", renderBias, 1000, 8000, "%.1f") then
    scenetree.theLevelInfo.visibleDistance = renderBias[0]
    scenetree.theLevelInfo:postApply()
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Reset view distance") then
    if defaultDistance == nil then
      scenetree.theLevelInfo.visibleDistance = 3000
      scenetree.theLevelInfo:postApply()
      core_environment.setTimeOfDay(tod)
    else
      scenetree.theLevelInfo.visibleDistance = defaultDistance
      scenetree.theLevelInfo:postApply()
      core_environment.setTimeOfDay(tod)
    end
    end
    im.Separator()
  end
  if lightmgr == "Basic Lighting" then
  else
    local dynLightEnabled = im.BoolPtr(dynLight)
    if im.Checkbox("Enable Dynamic Lights", dynLightEnabled) then
      dynLight = dynLightEnabled[0]
    end
    if dynLight == true then
      im.Text("Light Distance")
      offsetBias[0] = offsetval or 1000
      im.PushItemWidth(100)
      if im.SliderFloat("##offset_lights", offsetBias, 100, 2000, "%g") then
        offsetval = offsetBias[0]
      end
      im.SameLine()
      if im.Button("Reset Light Distance") then
        offsetval = 1000
      end
      im.Text("Light Refresh Rate")
      frameBias[0] = frameval or 100
      im.PushItemWidth(100)
      if im.SliderFloat("##frame_refresh", frameBias, 200, 10, "%g") then
        frameval = math.ceil(frameBias[0])
      end
      im.SameLine()
      if im.Button("Reset Light Refresh") then
        frameval = 100
      end
      if shadowdisable < 1 then
        local smartShadowsEnabled = im.BoolPtr(smartShadows)
        if im.Checkbox("Smart Shadows (WIP)", smartShadowsEnabled) then
          smartShadows = smartShadowsEnabled[0]
          --setAllLightsShadowsEnabledDisabled(scenetree.Tunnel_lights, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.Tunnel_sounds, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.RainbowBridge, false)
          setAllLightsShadowsEnabledDisabled(scenetree.LightGroup1, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup2, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup3, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup4, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup5, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.Arena_L, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.back_lights, false)
          --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup8, false)
        end
      end
      --debug button
      if freeroam_bigMapMode then
        local dynDbgEnabled = im.BoolPtr(playerPosDebugEnabled)
        if im.Checkbox("Debug Lights", dynDbgEnabled) then
          playerPosDebugEnabled = dynDbgEnabled[0]
        end
        if playerPosDebugEnabled == true then
          local skipCam = im.BoolPtr(skipCameraEnabled)
          if im.Checkbox("Ignore Free Camera", skipCam) then
            skipCameraEnabled = skipCam[0]
          end
          local skipDtReal = im.BoolPtr(skipRealTime)
          if im.Checkbox("Skip Real Time", skipDtReal) then
            skipRealTime = skipDtReal[0]
          end
        end
      end
    end
    im.Separator()
  end
    --check if there is a reason to generate lights
  if shadowdisable < 1 then
    if lightmgr == "Basic Lighting" or smartShadows == true then
      else
      im.Text("Toggle Light Shadows")
      local shadowEnabled = im.BoolPtr(enableShadows)
      if im.Checkbox("Enable Shadows", shadowEnabled) then
        enableShadows = shadowEnabled[0]
        --setAllLightsShadowsEnabledDisabled(scenetree.Tunnel_lights, enableShadows)
        setAllLightsShadowsEnabledDisabled(scenetree.LightGroup1, enableShadows)
        --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup2, enableShadows)
        --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup3, enableShadows)
        --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup4, enableShadows)
        --setAllLightsShadowsEnabledDisabled(scenetree.LightGroup5, enableShadows)
        --setAllLightsShadowsEnabledDisabled(scenetree.Arena_L, enableShadows)
        --setAllLightsShadowsEnabledDisabled(scenetree.back_lights, enableShadows)
        --[[setAllLightsShadowsEnabledDisabled(scenetree.6, enableShadows)
        setAllLightsShadowsEnabledDisabled(scenetree.LightGroup8, enableShadows)]]
      end
      im.Separator()
    end
  end

    --wehtest
    
  im.Text("Parked Vehicles Density")
  if im.Button("Zero") then
    hideGroup("VehicleProps1", true)
    hideGroup("VehicleProps2", true)
    hideGroup("VehicleProps3", true)
    be:reloadCollision()
  end
  im.SameLine()
  if im.Button("Low") then
    hideGroup("VehicleProps1", false)
    hideGroup("VehicleProps2", true)
    hideGroup("VehicleProps3", true)
    be:reloadCollision()
  end
  im.SameLine()
  if im.Button("Medium") then
    hideGroup("VehicleProps1", false)
    hideGroup("VehicleProps2", false)
    hideGroup("VehicleProps3", true)
    be:reloadCollision()
  end
  im.SameLine()
  if im.Button("High") then
    hideGroup("VehicleProps1", false)
    hideGroup("VehicleProps2", false)
    hideGroup("VehicleProps3", false)
    be:reloadCollision()
  end
  im.Separator()
  --show speed leaderboard
  if speedData then
    local boardEnabled = im.BoolPtr(showBoard)
    if im.Checkbox("Show Speedtrap Records", boardEnabled) then
      showBoard = boardEnabled[0]
    end
  end

im.End()

if speedData and showBoard == true then
  --im.Begin(speedTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  --im.Begin(speedTitle, showUI)
  local win = im.GetMainViewport()

  pos.x = win.Pos.x + win.Size.x / 2
  pos.y = win.Pos.y + 40
  im.SetNextWindowPos(pos, im.ImGuiCond_Always, im.ImVec2(0.5, 0))

  im.SetNextWindowBgAlpha(0.7)

  sizeMax.x = win.Size.x - win.Size.x / 1.8
  sizeMax.y = win.Size.y - win.Size.y / 1.3

  sizeMin.x = win.Size.x - win.Size.x / 1.5
  sizeMin.y = win.Size.y - win.Size.y / 1.2

  im.SetNextWindowSizeConstraints(sizeMin, sizeMax)

  im.Begin(speedTitle, showUI, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize+im.WindowFlags_NoMove+im.WindowFlags_NoCollapse+im.WindowFlags_NoDocking+im.WindowFlags_NoTitleBar)
  local fontavailable = false
  for k,v in pairs(getFontList()) do
    for k,v in pairs(v) do
      if v == "cairo_bold" then
        fontavailable = true
      end
    end
  end
  if fontavailable == true then
    im.PushFont3("cairo_bold")
  end
  if changed_version == true then
    im.TextColored(im.ImVec4(1, 0, 0, 1), "Version changed from "..oldversion..", to "..tool_version.." data has been reset")
  end
  if speedData then
    local locations = {}
    local locationData = speedData.speedtrap
    im.Spacing()
    im.Columns(6)
    im.Text("Location")
    im.NextColumn()
    im.Text("Vehicle")
    im.NextColumn()
    im.Text("Conditions")
    im.NextColumn()
    im.Text("Speed")
    im.NextColumn()
    im.Text("Speed Limit")
    im.NextColumn()
    im.Text("User")
    im.Spacing()
    im.Separator()
    im.Separator()
    im.Spacing()
    im.NextColumn()
    --location
    for k in pairs(speedData.speedtrap) do
      im.Text(tostring(k))
      table.insert(locations, k)
    end
    --data
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "vehicle" then
          im.Text(tostring(v))
        end
      end
    end
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "conditions" then
          im.Text(tostring(v))
        end
      end
    end
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "speed" then
          toUnit(v)
        end
      end
    end
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "speedLimit" then
          toUnit(v)
        end
      end
    end
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "user" then
          im.Text(tostring(v))
        end
      end
    end
  else
    im.Text("No Data")
  end
  if fontavailable == true then
    im.PopFont()
  end
  im.End()
end
end

    --check for TOD
    if not tod then return end
    local value = false
    if tod.time > 0.25 and tod.time < 0.76 then
      if cubevalue == false then
        cubemapname = "reflection_cubemap_2"
        setCubemap(cubemapname)
        print("night")
        hideGroup("imitation", false)
        setEmissionMaterials(3)
        cubevalue = true
      end
      value = true
    else
      if cubevalue == true then
        cubemapname = "reflection_cubemap_1"
        setCubemap(cubemapname)
        print("day")
        hideGroup("imitation", true)
        setEmissionMaterials(2)
        cubevalue = false
      end
    end
  if TorqueScriptLua then
    if lightmgr == "Basic Lighting" then
    else
      if dynLight == true then
        --we don't need to update every frame
        if waitForFrame > 0 then
          if skipRealTime == true and playerPosDebugEnabled == true then
          waitForFrame = waitForFrame - 0.5
          else
          waitForFrame = waitForFrame - dtReal*50
          end
        end
        if waitForFrame <= 0 then
          lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
          shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
          --onPlayerPosition(scenetree.Tunnel_lights, true)
          --onPlayerPosition(scenetree.Tunnel_sounds, true)
          if value == true then
            --onPlayerPosition(scenetree.sign_lights, value)
            onPlayerPosition(scenetree.LightGroup1, value)
            --onPlayerPosition(scenetree.LightGroup2, value)
            --onPlayerPosition(scenetree.LightGroup3, value)
            --onPlayerPosition(scenetree.LightGroup4, value)
            --onPlayerPosition(scenetree.LightGroup5, value)
            --onPlayerPosition(scenetree.Arena_L, value)
            --onPlayerPosition(scenetree.back_lights, value)
            --onPlayerPosition(scenetree.6, value)
            --onPlayerPosition(scenetree.LightGroup8, value)
            --onPlayerPosition(scenetree.LightGroup9, value)
            lastValue = true
          end
          if value == false and lastValue == true then
            --onPlayerPosition(scenetree.sign_lights, false)
            onPlayerPosition(scenetree.LightGroup1, false)
            --onPlayerPosition(scenetree.LightGroup2, false)
            --onPlayerPosition(scenetree.LightGroup3, false)
            --onPlayerPosition(scenetree.LightGroup4, false)
            --onPlayerPosition(scenetree.LightGroup5, false)
            --onPlayerPosition(scenetree.Arena_L, false)
            --onPlayerPosition(scenetree.back_lights, value)
            --onPlayerPosition(scenetree.6, value)
            --onPlayerPosition(scenetree.LightGroup8, value)
            --onPlayerPosition(scenetree.LightGroup9, value)
            lastValue = false
          end
        end
        --enable debug features
        if playerPosDebugEnabled == true then
          playerPosDebug()
        end
      elseif lastValue ~= true then
        if core_jobsystem.getRunningJobCount() ~= 0 then
          -- no jobs?
        local jobCount = core_jobsystem.getRunningJobCount()
        if jobCount ~= lastjobCount then
          lastjobCount = core_jobsystem.getRunningJobCount()
          log("I", "", "Wait for setAllLightsPosEnabled "..tostring(core_jobsystem.getRunningJobCount()))
        end
        else
          log("I", "", "Fallback lights")
          --setAllLightsEnabled(scenetree.Tunnel_lights, true)
          --setAllLightsEnabled(scenetree.Tunnel_sounds, true)
          lastValue = true
        end
      end
    end
    if freeroam_bigMapMode then
      if freeroam_bigMapMode.bigMapActive() == true then
        if bigmapvalue == 0 or bigmapvalue == 2 then
          TorqueScriptLua.setVar("$pref::TS::detailAdjust", 4)
          hideGroup("water", true)
          hideGroup("bigmap_helper", false)
          bigmapvalue = 1
        end
      elseif bigmapvalue == 1 then
        if LODDEF == nil then
          TorqueScriptLua.setVar("$pref::TS::detailAdjust", 1)
        else
        TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
        end
        hideGroup("water", false)
        hideGroup("bigmap_helper", true)
        bigmapvalue = 2
      end
    end
  end

end


local function onEditorInitialized()
  editor.addWindowMenuItem("Map Controller", onWindowMenuItem, {groupMenuName = 'Car_Killer Addons'})
  editor.registerWindow(toolWindowName, im.ImVec2(500, 200))

end

local function onExit()
  if TorqueScriptLua then
    log("I", "", "onExit restored LOD to default previous one")
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
  end
end

local function onBeamNGTrigger(data)
  -- dump(data)
  if data.triggerName == "BeamNG_teleport1" and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 1
    end
  end
  if data.triggerName == "BeamNG_teleport1" and data.event == "exit" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 0
    end
  end
end


M.onPreRender = onPreRender
M.onClientStartMission = onClientStartMission
M.onClientEndMission = onExit
M.setAllLightsPosEnabled = setAllLightsPosEnabled
M.onUpdate = onUpdate
M.onBeamNGTrigger = onBeamNGTrigger
M.onEditorInitialized = onEditorInitialized
M.onEditorActivated = onEditorActivated
M.onEditorDeactivated = onEditorDeactivated
M.onExit = onExit

return M
--Written in Visual Studio Code with Yukino Yukinoshita theme by Car_Killer 2022
--updated by Sherman_ especially for SPB map