Scriptname Stentorious:SaveManager:QuestScript extends Quest

; Notification Messages
Message Property MSG_SaveManager_Init Auto Const Mandatory
Message Property MSG_SaveManager_Abort_Combat Auto Const Mandatory
Message Property MSG_SaveManager_Abort_Cooldown Auto Const Mandatory
Message Property MSG_SaveManager_Abort_Health Auto Const Mandatory
Message Property MSG_SaveManager_Request_Full Auto Const Mandatory
Message Property MSG_SaveManager_Request_Combat Auto Const Mandatory
Message Property MSG_SaveManager_Request_Crafting Auto Const Mandatory
Message Property MSG_SaveManager_Request_LevelUp Auto Const Mandatory
Message Property MSG_SaveManager_Request_Location Auto Const Mandatory
Message Property MSG_SaveManager_Request_Lockpick Auto Const Mandatory
Message Property MSG_SaveManager_Request_Pickpocket Auto Const Mandatory
Message Property MSG_SaveManager_Request_Quest Auto Const Mandatory
Message Property MSG_SaveManager_Request_SleepWait Auto Const Mandatory
Message Property MSG_SaveManager_Request_Survey Auto Const Mandatory
Message Property MSG_SaveManager_Request_Timed Auto Const Mandatory
Message Property MSG_SaveManager_Request_Travel Auto Const Mandatory

; Gameplay Options
; Save events
GameplayOption Property GPO_SaveManager_OnCombatEnd Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnCraftItem Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnPickpocket Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnPickLock Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnSurvey Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnLevelUp Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnQuestComplete Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnLocationDiscover Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnSleepWait Auto Const Mandatory
GameplayOption Property GPO_SaveManager_OnTravel Auto Const Mandatory
; Save requirements
GameplayOption Property GPO_SaveManager_InCombat Auto Const Mandatory
GameplayOption Property GPO_SaveManager_HealthThreshold Auto Const Mandatory
GameplayOption Property GPO_SaveManager_Cooldown Auto Const Mandatory
; Extra
GameplayOption Property GPO_SaveManager_FullSave Auto Const Mandatory
GameplayOption Property GPO_SaveManager_AutoTimer Auto Const Mandatory
GameplayOption Property GPO_SaveManager_Notifications Auto Const Mandatory

; Actor Values
ActorValue property Experience Auto Const Mandatory

; Tracked stats
String Property sTrackedStats_QuestsCompleted = "Quests Completed" AutoReadOnly
String Property sTrackedStats_LocationsDiscovered = "Locations Discovered" AutoReadOnly
String Property sTrackedStats_LocksPicked = "Locks Picked" AutoReadOnly
String Property sTrackedStats_PocketsPicked = "Pockets Picked" AutoReadOnly
String Property sTrackedStats_PlanetsSurveyed = "Planets Fully Surveyed" AutoReadOnly

; Script variables
Actor PlayerRef

bool cooldownState = true

bool queueSaveCrafting = false
bool queueSaveFavorites = false
bool queueSaveScope = false
bool menuStateFavorites = false
bool menuStateScope = false

int playerLevel = 0
int saveIndex = 0

float cooldownTimer = 120.0
float autosaveTimer = 300.0
float debugNotifications = 1.0
float modVersion = 0.0

string saveTypeQueue = "Generic"

; On initial game load
Event OnQuestInit()
	Maintenance()
	RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
EndEvent

; On subsequent game loads
Event Actor.OnPlayerLoadGame(Actor akSender)
	Maintenance()
EndEvent

; Update function
Function Maintenance()

	; Release Version
	if modVersion < 1.00

		; Init player
		PlayerRef = Game.GetPlayer()
		playerLevel = PlayerRef.GetLevel()

		; Register events
		RegisterForGameplayOptionChangedEvent()
		RegisterForPlayerTeleport()
		RegisterForPlayerSleep()
		RegisterForPlayerWait()
		RegisterForActorValueChangedEvent(PlayerRef, Experience)
		RegisterForRemoteEvent(PlayerRef, "OnPlayerCompleteResearch")
		RegisterForRemoteEvent(PlayerRef, "OnPlayerCraftItem")
		RegisterForRemoteEvent(PlayerRef, "OnCombatStateChanged")

		; Stat events
		RegisterTrackedStatsIncrement(sTrackedStats_QuestsCompleted)
		RegisterTrackedStatsIncrement(sTrackedStats_LocationsDiscovered)
		RegisterTrackedStatsIncrement(sTrackedStats_LocksPicked)
		RegisterTrackedStatsIncrement(sTrackedStats_PocketsPicked)
		RegisterTrackedStatsIncrement(sTrackedStats_PlanetsSurveyed)

		; Menu events
		RegisterForMenuOpenCloseEvent("ArmorCraftingMenu")
		RegisterForMenuOpenCloseEvent("DrugsCraftingMenu")
		RegisterForMenuOpenCloseEvent("FoodCraftingMenu")
		RegisterForMenuOpenCloseEvent("IndustrialCraftingMenu")
		RegisterForMenuOpenCloseEvent("WeaponsCraftingMenu")
		RegisterForMenuOpenCloseEvent("ResearchMenu")
		RegisterForMenuOpenCloseEvent("FavoritesMenu")
		RegisterForMenuOpenCloseEvent("ScopeMenu")

		; Start autosave timer
		if autosaveTimer > 0
			StartTimer(autosaveTimer, 10)
		endif

		; Start cooldown timer
		StartTimer(cooldownTimer, 20)

		; Startup message
		MSG_SaveManager_Init.Show()

	endif

	; Reset variables
	queueSaveCrafting = false
	queueSaveFavorites = false
	queueSaveScope = false
	menuStateFavorites = false
	menuStateScope = false

	; Set mod version
	modVersion = 1.00

EndFunction


; Credit bp42s
Function RegisterTrackedStatsIncrement(String asStat)
	if (!asStat)
		return
	endif
	RegisterForTrackedStatsEvent(asStat, Game.QueryStat(asStat) + 1)
EndFunction


; Save on stat event
Event OnTrackedStatsEvent(string asStatFilter, int aiStatValue)
	RegisterTrackedStatsIncrement(asStatFilter)
	if asStatFilter == sTrackedStats_QuestsCompleted && GPO_SaveManager_OnQuestComplete.GetValue() == 1
		SaveGame(3, "Quest")
	elseif asStatFilter == sTrackedStats_LocationsDiscovered && GPO_SaveManager_OnLocationDiscover.GetValue() == 1
		SaveGame(3, "Location")
	elseif asStatFilter == sTrackedStats_LocksPicked && GPO_SaveManager_OnPickLock.GetValue() == 1
		SaveGame(3, "Lockpick")
	elseif asStatFilter == sTrackedStats_PocketsPicked && GPO_SaveManager_OnPickpocket.GetValue() == 1
		SaveGame(3, "Pickpocket")
	elseif asStatFilter == sTrackedStats_PlanetsSurveyed && GPO_SaveManager_OnSurvey.GetValue() == 1
		SaveGame(3, "Survey")
	endif
endEvent


; Menu events
Event OnMenuOpenCloseEvent(string asMenuName, bool abOpening)
	if abOpening == false

		if asMenuName == "FavoritesMenu"
			menuStateFavorites = false
			if queueSaveFavorites == true
				queueSaveFavorites = false
				SaveGame(1, saveTypeQueue)
			endif
		elseif asMenuName == "ScopeMenu"
			menuStateScope = false
			if queueSaveScope == true
				queueSaveScope = false
				SaveGame(1, saveTypeQueue)
			endif
		else
			if queueSaveCrafting == true
				queueSaveCrafting = false
				SaveGame(1, "Crafting")
			endif
		endif
	else
		if asMenuName == "FavoritesMenu"
			menuStateFavorites = true
		elseif asMenuName == "ScopeMenu"
			menuStateScope = true
		endif
	endif
EndEvent


; Save on travel
Event OnPlayerTeleport()
	if GPO_SaveManager_OnTravel.GetValue() == 1
		SaveGame(1, "Travel")
	endif
EndEvent


; Save on sleep
Event OnPlayerSleepStop(bool abInterrupted, ObjectReference akBed)
	if GPO_SaveManager_OnSleepWait.GetValue() == 1
		SaveGame(1, "SleepWait")
	endif
EndEvent


; Save on wait
Event OnPlayerWaitStop(bool abInterrupted)
	if GPO_SaveManager_OnSleepWait.GetValue() == 1
		SaveGame(1, "SleepWait")
	endif
EndEvent


; Save on combat end
Event Actor.OnCombatStateChanged(Actor akSender, ObjectReference akTarget, int aeCombatState)
	if PlayerRef.GetCombatState() == 0 && GPO_SaveManager_OnCombatEnd.GetValue() == 1
		SaveGame(3, "Combat")
	endif
EndEvent


; Save on craft item or research complete
Event Actor.OnPlayerCompleteResearch(Actor akSender, ObjectReference akBench, Location akLocation, ResearchProject akProject)
	if GPO_SaveManager_OnCraftItem.GetValue() == 1
		queueSaveCrafting = true
	endif
EndEvent
Event Actor.OnPlayerCraftItem(Actor akSender, ObjectReference akBench, Location akLocation, Form akCreatedItem)
	if GPO_SaveManager_OnCraftItem.GetValue() == 1
		queueSaveCrafting = true
	endif
EndEvent


; Save on level up
Event OnActorValueChanged(ObjectReference akObjRef, ActorValue akActorValue)
	RegisterForActorValueChangedEvent(PlayerRef, Experience)
	if GPO_SaveManager_OnLevelUp.GetValue() == 1
		int playerLevelTemp = PlayerRef.GetLevel()
		if playerLevel < playerLevelTemp
			playerLevel = playerLevelTemp
			SaveGame(3, "LevelUp")
		endif
	endif
EndEvent


; Timed save
Event OnTimer(int aiTimerID)
	if aiTimerID == 10
		SaveGame(0.1, "Timed")
		if autosaveTimer > 0
			StartTimer(autosaveTimer, 10)
		endif
	elseif aiTimerID == 20
		cooldownState = false
	endif
EndEvent


; Attempt to save game
Function SaveGame(float waitTimer, string saveType)

	; Delay
	Utility.Wait(waitTimer)

	; Queue save if realtime menu open
	if menuStateFavorites == true
		saveTypeQueue = saveType
		queueSaveFavorites = true
		return
	elseif menuStateScope == true
		saveTypeQueue = saveType
		queueSaveScope = true
		return
	endif

	float healthThreshold = GPO_SaveManager_HealthThreshold.GetValue() / 10

	; Save on cooldown
	if cooldownState == true
		if debugNotifications
			MSG_SaveManager_Abort_Cooldown.Show()
		endif
		return

	; Player combat state
	elseif PlayerRef.GetCombatState() == 1 && GPO_SaveManager_InCombat.GetValue() == 0
		if debugNotifications
			MSG_SaveManager_Abort_Combat.Show()
		endif
		return

	; Player health
	elseif healthThreshold > 0 && healthThreshold > PlayerRef.GetValuePercentage(Game.GetHealthAV())
		if debugNotifications
			MSG_SaveManager_Abort_Health.Show()
		endif
		return

	; General
	elseif PlayerRef.IsDead() == true
		return
	endif

	; Save notification
	if debugNotifications
		if saveType == "Combat"
			MSG_SaveManager_Request_Combat.Show()
		elseif saveType == "Crafting"
			MSG_SaveManager_Request_Crafting.Show()
		elseif saveType == "LevelUp"
			MSG_SaveManager_Request_LevelUp.Show()
		elseif saveType == "Location"
			MSG_SaveManager_Request_Location.Show()
		elseif saveType == "Lockpick"
			MSG_SaveManager_Request_Lockpick.Show()
		elseif saveType == "Pickpocket"
			MSG_SaveManager_Request_Pickpocket.Show()
		elseif saveType == "Quest"
			MSG_SaveManager_Request_Quest.Show()
		elseif saveType == "SleepWait"
			MSG_SaveManager_Request_SleepWait.Show()
		elseif saveType == "Survey"
			MSG_SaveManager_Request_Survey.Show()
		elseif saveType == "Timed"
			MSG_SaveManager_Request_Timed.Show()
		elseif saveType == "Travel"
			MSG_SaveManager_Request_Travel.Show()
		endif
	endif

	; Autosave
	Game.RequestAutosave()

	; Start cooldown timer
	cooldownState = true
	StartTimer(cooldownTimer, 20)

	; Create full save if interval has been reached
	float fullSaveInterval = GPO_SaveManager_FullSave.GetValue()
	if fullSaveInterval > 0
		if saveIndex >= fullSaveInterval
			Utility.Wait(2)
			if debugNotifications
				MSG_SaveManager_Request_Full.Show()
			endif
			Game.RequestSave()
			saveIndex = 0
		else
			saveIndex += 1
		endif
	endif

EndFunction


; Restart/update autosave timer on settings change
Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)

	; Update gameplay options variables
	if aChangedOptions.Find(GPO_SaveManager_AutoTimer) >= 0
		autosaveTimer = GPO_SaveManager_AutoTimer.GetValue() * 60
	endif
	if aChangedOptions.Find(GPO_SaveManager_Cooldown) >= 0
		cooldownTimer = GPO_SaveManager_Cooldown.GetValue() * 60
	endif
	if aChangedOptions.Find(GPO_SaveManager_Notifications) >= 0
		debugNotifications = GPO_SaveManager_Notifications.GetValue()
	endif

	; Restart timers
	CancelTimer(10)
	if autosaveTimer > 0
		StartTimer(autosaveTimer, 10)
	endif
	CancelTimer(20)
	StartTimer(cooldownTimer, 20)

EndEvent
