-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local myTimer = 0

local function onInit(jbeamData)
	electrics.values["flames3"] = 0
	myTimer = 0
end

local function onReset()
	onInit()
end

local function updateGFX(dt)

	local function timer()
		myTimer = myTimer + 0.01
		if myTimer >= 0.25 then
			myTimer = 0
			electrics.values["flames3"] = 0
		end
	end
	
	if electrics.values.throttle_input <= 0.5 and electrics.values.rpm >= 6000 then
		electrics.values["flames3"] = 1
		timer()
	else
		myTimer = 0
		electrics.values["flames3"] = 0
		timer()
	end

if electrics.values.airspeed <= 15 then
	
	if electrics.values.throttle_input <= 0.5 and electrics.values.rpm >= 4000 then
		electrics.values["flames3"] = 1
	else
		myTimer = 0
		electrics.values["flames3"] = 0
	end

end

if electrics.values.airspeed >= 25 then
	
	if electrics.values.throttle_input <= 0.5 and electrics.values.rpm >= 5000 then
		electrics.values["flames3"] = 1
	else
		myTimer = 0
		electrics.values["flames3"] = 0
	end

end

end

-- public interface
M.onReset = onReset
M.onInit = onInit
M.updateGFX = updateGFX

return M
