ScriptName DayLengthLeft Extends Quest
{ Determines which day-length message to show and what value to put in it }

;I had to decompile this from the pex file at one point so some of the formatting is very formal
Float dayLength
;these four are used for calculating duration - H for Hour (in-game time), S for Second (real time)
Float StartH
Float endH
Float startS
Float endS

;-- Properties --------------------------------------
Group Messages
  Message Property msgLockedM Auto
  { Notification for a tidally-locked moon }
  Message Property msgLockedP Auto
  { Notification for a tidally-locked planet }
  Message Property msgSunrise Auto
  { Notification for a location approaching sunrise }
  Message Property msgSunset Auto
  { Notification for a location approaching sunset }
  Message Property msgLength Auto
  { Alternate notification that just shows day length }
   Message Property msgSunriseReal Auto
  { Sunrise notification that uses real time }
  Message Property msgSunsetReal Auto
  { Sunset notification that uses real time }
  Message Property msgLengthReal Auto
  { Day length notification that uses real time }
EndGroup

Group Keywords
  Keyword Property kMoon Auto
  { Keyword present on locations that are considered moons }
  Keyword Property kPlanet Auto
  { Keyword present on locations that are considered planets }
EndGroup

GlobalVariable Property gTimescale Auto
{ Game on-surface timescale factor, which defaults to 15 }
GameplayOption Property messageType Auto
{ Gameplay Option toggle to show sunrise/sunset messages or just day length}
GameplayOption Property messageUnit Auto
{ Gameplay Option toggle to use UT hours or minutes}

;-- Functions ---------------------------------------

Event OnStoryShipLanding(ObjectReference akLandingShip, ObjectReference akLandingMarker)
  ; Empty function. This is what the script is linked to, but when I put code here it didn't trigger.
EndEvent

Event OnQuestInit()
	planet p = Game.GetPlayer().GetCurrentPlanet()
	dayLength = p.GetDayLength()
	If dayLength as String == "inf"
		If p.HasKeyword(kPlanet)
			;boring case - tidally-locked planet, no day cycle
			msgLockedP.Show()
			Stop()
		ElseIf p.HasKeyword(kMoon)
			;tidally-locked moons can still have day cycles!
			msgLockedM.Show()
			startS = Utility.GetCurrentRealTime()
			StartH = Game.GetLocalTime()
			StartTimer(15)
		EndIf
	Else
		;regular location with an easily-retrievable day length
		dayLength = Math.abs(daylength)	;in case any landable planets spin backwards
		SunMessage()
		Stop()
	EndIf
EndEvent

Event OnTimer(Int aiTimerID)
	;the only timer is for estimating tidally-locked moon day lengths
	endS = Utility.GetCurrentRealTime()
	endH = Game.GetLocalTime()
	Float hoursPassed = endH - StartH
	If hoursPassed < 0	;in case it measures across midnight
	  hoursPassed += 24
	EndIf
	
	;UT = the real duration (~15.0 seconds) divided by the number of real seconds in an in-game hour
	;so UT represents what fraction of an in-game UT hour passed in the interval
	;this should be very close to 15/240 or 0.0625 (for default timescale and 15-second measurement)
	Float UT = (endS - startS) / (3600 as Float / gTimescale.getValue())
	
	;and so this line determines the ratio of a planetary hour to a UT hour, and multiplies that to find the day length
	dayLength = UT / hoursPassed * 24 as Float
	
	;and having filled in a suitable number, we can proceed!
	SunMessage()
	Stop()
EndEvent

Function SunMessage()
	;there's probably a better way to do this with text substitutions & aliases
	if messageType.GetValue() == 1
		;just show day Length, boooring
		if messageUnit.getValue() == 0
			msgLength.Show(daylength) ;UT
		Else
			msgLengthReal.Show(daylength*(60/gTimescale.getValue())) ;minutes
		endif
	else
		;show time until sun event
		Float realHoursUntil = 0.0
		Float timeOfDay = Game.GetLocalTime()
		If timeOfDay >= 6.0 && timeOfDay <= 18.0	;daytime
			realHoursUntil = (18 - timeOfDay) * dayLength / 24.0
			if messageUnit.GetValue() == 0
				;UT hours
				msgSunset.Show(realHoursUntil) ;UT
			Else
				msgSunsetReal.Show(realHoursUntil*(60/gTimescale.getValue())) ;minutes
			endif
		Else
			;night time
			;I bet there's an elegant one-liner for this
			If timeOfDay < 6	;after midnight
			  realHoursUntil = (6 - timeOfDay) * dayLength / 24.0
			Else	;before midnight
			  realHoursUntil = (24 + 6 - timeOfDay) * dayLength / 24.0
			EndIf
			if messageUnit.GetValue() == 0
				;UT hours
				msgSunrise.Show(realHoursUntil) ;UT
			Else
				msgSunriseReal.Show(realHoursUntil*(60/gTimescale.getValue())) ;minutes
			endif
		EndIf
	endif
EndFunction
