#!/usr/bin/python3

import os

cwd = os.getcwd()


assetList = []

for subdir, dirs, files in os.walk(cwd):
  for file in files:
    if file.endswith('.dae'):
      assetList.append(file)

with open (cwd + '/managedItemData.json', 'w') as f:
  f.write('{')
  f.write('\n')
  for i in assetList:
    name = os.path.split(str(i).lower())[1].replace('.dae', '')
    f.write('  "' + name + '": {')
    f.write('\n')
    f.write('    "name": "' + name + '",')
    f.write('\n')
    f.write('    "internalName": "'+ name + '",')
    f.write('\n')
    f.write('    "class": "TSForestItemData",')
    f.write('\n')
    f.write('    "radius": 0.100000001,')
    f.write('\n')
    f.write('    "shapeFile": "' + i + '",')
    f.write('\n')
    f.write('  },')
    f.write('\n')
  f.write('}')