/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.debug;

import com.jgoodies.forms.debug.FormDebugUtils;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class FormDebugPanel
extends JPanel {
    public static boolean paintRowsDefault = true;
    private static final Color DEFAULT_GRID_COLOR = Color.red;
    private boolean paintInBackground;
    private boolean paintDiagonals;
    private boolean paintRows = paintRowsDefault;
    private Color gridColor = DEFAULT_GRID_COLOR;

    public FormDebugPanel() {
        this(null);
    }

    public FormDebugPanel(FormLayout layout) {
        this(layout, false, false);
    }

    public FormDebugPanel(boolean paintInBackground, boolean paintDiagonals) {
        this(null, paintInBackground, paintDiagonals);
    }

    public FormDebugPanel(FormLayout layout, boolean paintInBackground, boolean paintDiagonals) {
        super(layout);
        this.setPaintInBackground(paintInBackground);
        this.setPaintDiagonals(paintDiagonals);
        this.setGridColor(DEFAULT_GRID_COLOR);
    }

    public void setPaintInBackground(boolean b2) {
        this.paintInBackground = b2;
    }

    public void setPaintDiagonals(boolean b2) {
        this.paintDiagonals = b2;
    }

    public void setPaintRows(boolean b2) {
        this.paintRows = b2;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.paintInBackground) {
            this.paintGrid(g2);
        }
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        if (!this.paintInBackground) {
            this.paintGrid(g2);
        }
    }

    private void paintGrid(Graphics g2) {
        int length;
        int i2;
        int stop;
        int start;
        boolean firstOrLast;
        if (!(this.getLayout() instanceof FormLayout)) {
            return;
        }
        FormLayout.LayoutInfo layoutInfo = FormDebugUtils.getLayoutInfo(this);
        int left = layoutInfo.getX();
        int top = layoutInfo.getY();
        int width = layoutInfo.getWidth();
        int height = layoutInfo.getHeight();
        g2.setColor(this.gridColor);
        int last = layoutInfo.columnOrigins.length - 1;
        for (int col = 0; col <= last; ++col) {
            firstOrLast = col == 0 || col == last;
            int x2 = layoutInfo.columnOrigins[col];
            start = firstOrLast ? 0 : top;
            stop = firstOrLast ? this.getHeight() : top + height;
            for (i2 = start; i2 < stop; i2 += 5) {
                length = Math.min(3, stop - i2);
                g2.fillRect(x2, i2, 1, length);
            }
        }
        last = layoutInfo.rowOrigins.length - 1;
        for (int row = 0; row <= last; ++row) {
            firstOrLast = row == 0 || row == last;
            int y2 = layoutInfo.rowOrigins[row];
            start = firstOrLast ? 0 : left;
            int n2 = stop = firstOrLast ? this.getWidth() : left + width;
            if (!firstOrLast && !this.paintRows) continue;
            for (i2 = start; i2 < stop; i2 += 5) {
                length = Math.min(3, stop - i2);
                g2.fillRect(i2, y2, length, 1);
            }
        }
        if (this.paintDiagonals) {
            g2.drawLine(left, top, left + width, top + height);
            g2.drawLine(left, top + height, left + width, top);
        }
    }
}

