/**
 * Tonemap version 1.1
 * by Christian Cann Schuldt Jensen ~ CeeJay.dk
 */

 
#include "ReShadeUI.fxh"


/**
 *
 * The original settings of Tonemap.fx were changed with the configuration of JBX Settings RC v1.2 for JBX Weather 2 v1.6.x
 *
 * Credits: JuanBonX (JBX Settings), CeeJay.dk (Tonemap)
 */
 
 
// JBX SETTINGS BY JUANBONX (MOD)
 
uniform float Gamma < __UNIFORM_SLIDER_FLOAT1
	ui_min = 0.94; ui_max = 0.94;
	ui_tooltip = "Adjust midtones. 1.000 is neutral. This setting does exactly the same as the one in Lift Gamma Gain, only with less control.";
> = 0.94;
uniform float Exposure < __UNIFORM_SLIDER_FLOAT1
	ui_min = -0.01; ui_max = -0.01;
	ui_tooltip = "Adjust exposure";
> = -0.01;
uniform float Saturation < __UNIFORM_SLIDER_FLOAT1
	ui_min = 0.0; ui_max = 0.0;
	ui_tooltip = "Adjust saturation";
> = 0.0;

uniform float Bleach < __UNIFORM_SLIDER_FLOAT1
	ui_min = 0.0; ui_max = 0.0;
	ui_tooltip = "Brightens the shadows and fades the colors";
> = 0.0;

uniform float Defog < __UNIFORM_SLIDER_FLOAT1
	ui_min = 0.0; ui_max = 0.0;
	ui_tooltip = "How much of the color tint to remove";
> = 0.0;
uniform float3 FogColor < __UNIFORM_COLOR_FLOAT3
	ui_label = "Defog Color";
	ui_tooltip = "Which color tint to remove";
> = float3(0.0, 0.0, 0.0);



// ORIGINAL SETTINGS BY CEEJAY.DK (AUTHOR)
 
//uniform float Gamma < __UNIFORM_SLIDER_FLOAT1
//	ui_min = 0.0; ui_max = 2.0;
//	ui_tooltip = "Adjust midtones. 1.000 is neutral. This setting does exactly the same as the one in Lift Gamma Gain, only with less control.";
//> = 1.0;
//uniform float Exposure < __UNIFORM_SLIDER_FLOAT1
//	ui_min = -1.0; ui_max = 1.0;
//	ui_tooltip = "Adjust exposure";
//> = 0.0;
//uniform float Saturation < __UNIFORM_SLIDER_FLOAT1
//	ui_min = -1.0; ui_max = 1.0;
//	ui_tooltip = "Adjust saturation";
//> = 0.0;
//
//uniform float Bleach < __UNIFORM_SLIDER_FLOAT1
//	ui_min = 0.0; ui_max = 1.0;
//	ui_tooltip = "Brightens the shadows and fades the colors";
//> = 0.0;
//
//uniform float Defog < __UNIFORM_SLIDER_FLOAT1
//	ui_min = 0.0; ui_max = 1.0;
//	ui_tooltip = "How much of the color tint to remove";
//> = 0.0;
//uniform float3 FogColor < __UNIFORM_COLOR_FLOAT3
//	ui_label = "Defog Color";
//	ui_tooltip = "Which color tint to remove";
//> = float3(0.0, 0.0, 1.0);


#include "ReShade.fxh"

float3 TonemapPass(float4 position : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	color = saturate(color - Defog * FogColor * 2.55); // Defog
	color *= pow(2.0f, Exposure); // Exposure
	color = pow(color, Gamma); // Gamma

	const float3 coefLuma = float3(0.2126, 0.7152, 0.0722);
	float lum = dot(coefLuma, color);
	
	float L = saturate(10.0 * (lum - 0.45));
	float3 A2 = Bleach * color;

	float3 result1 = 2.0f * color * lum;
	float3 result2 = 1.0f - 2.0f * (1.0f - lum) * (1.0f - color);
	
	float3 newColor = lerp(result1, result2, L);
	float3 mixRGB = A2 * newColor;
	color += ((1.0f - A2) * mixRGB);
	
	float3 middlegray = dot(color, (1.0 / 3.0));
	float3 diffcolor = color - middlegray;
	color = (color + diffcolor * Saturation) / (1 + (diffcolor * Saturation)); // Saturation
	
	return color;
}

technique Tonemap
{
	pass
	{
		VertexShader = PostProcessVS;
		PixelShader = TonemapPass;
	}
}
