﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;
using System.Threading;

namespace SpeedScript
{

    public class Main : Script
    {
        /// Change these values only
        int MouseClickDelay = 50;   //Delay between recognised mouse presses so holding a mouse button doesn't toggle too quickly

        int HorseSpeed = 20;        //Too fast will just slam you into small rises in the ground very hard
        Keys HorseKey = Keys.H;     //This is the key to increase horse speed (Only works while on a horse, turns off if you dismount
        MouseButtons mbHorse = MouseButtons.None;

        //MouseButtons None, Left, Right, Middle, XButton1, XButton2

        float fSlowSpeed = 0.2f;    //above 1 does nothing
        Keys Slowkey = Keys.Y;      //This is the key to activate slowmode
        MouseButtons mbSlow = MouseButtons.XButton2;

        /*
        Extra silliness

        F12         -   toggles keychecking so you can get what keys are available to bind
        N           -   Sets time to midday

        Numlock     -   toggles targetting for use with below
                    -   Once on, right click and hold or looking at with binocs or pointing a gun at will select a PED or Vehicle
                    -   target will be remembered

            Once you have a target
        Numpad /    -   Freezes the target (use on the horse or vehicle if ped is mounted)
        Numpad *    -   Unfreeses the target
        Numpad 4    -   Booms the target
        Numpad 5    -   Zaps the target (sometimes takes a while to arrive)
        Numpad 6    -   Kills the target (will not damage pelts)

        Numpad -    -   Changes the explosion type for Booming. Decrement
        Numpad +    -   Changes the explosion type for Booming. Increment (max seems to be 34/35)
        */

        public Main()
        {
            KeyDown += OnKeyDown;
            Tick += OnTick;

            Interval = 1;
        }
        Ped pedmount = null;
        bool slow = false;
        bool horsespeed = false;
        bool keycheck = false;
        int keytick = 0;
        bool Aimcheck = false;
        Entity entAim = null;
        Entity entAimOld = null;
        int explosion = 0;

        private void OnTick(object sender, EventArgs e)
        {
            if (keytick > 0) keytick--;
            Game.ShowsPoliceBlipsOnRadar = true;

            if (System.Windows.Forms.Control.MouseButtons != MouseButtons.None)
            {
                if (keytick < 1)
                {
                    keytick = MouseClickDelay;
                    OnKeyDown(this, new KeyEventArgs(Keys.None));
                }
            }

            if (Aimcheck)
            {
                OutputArgument entTarget = new OutputArgument();

                bool freeaiming = Function.Call<bool>(Hash.GET_ENTITY_PLAYER_IS_FREE_AIMING_AT, Game.Player, entTarget);
                if (freeaiming)
                {
                    entAim = entTarget.GetResult<Entity>();
                }

                bool IsTargeting = Function.Call<bool>(Hash.GET_PLAYER_TARGET_ENTITY, Game.Player, entTarget);
                if (IsTargeting)
                {
                    entAim = entTarget.GetResult<Entity>();

                }
                if (entAim != entAimOld)
                {
                    RDR2.UI.Screen.ShowSubtitle(DateTime.Now.ToLongTimeString() + " New Target " + entAim.GetType().ToString().Substring(5));
                    entAimOld = entAim;
                }
            }

            if (slow)
            {
                Game.TimeScale = fSlowSpeed;
            }

            if (horsespeed)
            {
                if (Game.Player.Character.IsOnHorse)
                {
                    pedmount = Game.Player.Character.CurrentMount;
                    pedmount.IsInvincible = true;

                    pedmount.HealthCore = 100;
                    pedmount.StaminaCore = 100;

                    if (pedmount.IsRunning || pedmount.IsSprinting)
                    {
                        Vector3 vecAdd = pedmount.ForwardVector * HorseSpeed;
                        pedmount.ApplyForce(vecAdd);
                    }
                }
            }
        }

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            MouseButtons mb = System.Windows.Forms.Control.MouseButtons;

            if (keycheck)
            {
                if (mb == MouseButtons.None)
                    RDR2.UI.Screen.ShowSubtitle("KeyCode = [" + e.KeyCode.ToString() + "]");
                else
                    RDR2.UI.Screen.ShowSubtitle("Mouse Buttons = [" + mb.ToString() + "]");
            }

            if (e.KeyCode == Keys.F11)
            {
                Game.Player.Character.DeadEyeCore = 100;
                Game.Player.Character.StaminaCore = 100;
                Game.Player.Character.HealthCore = 100;

                pedmount.IsInvincible = true;

                pedmount.HealthCore = 100;
                pedmount.StaminaCore = 100;
            }

            if (e.KeyCode == Keys.F12)
            {
                if (keycheck)
                {
                    keycheck = false;
                    RDR2.UI.Screen.ShowSubtitle("Keycheck is off");
                }
                else
                {
                    keycheck = true;
                    RDR2.UI.Screen.ShowSubtitle("Keycheck is on");
                }
            }

            if (e.KeyCode == Keys.N)
            {
                RDR2.UI.Screen.ShowSubtitle("Time set to midday");
                Function.Call<bool>(Hash.SET_CLOCK_TIME, 12, 0, 0);
            }

            if (e.KeyCode == Keys.NumLock)
            {
                if (Aimcheck)
                {
                    Aimcheck = false;
                    RDR2.UI.Screen.ShowSubtitle("Aimcheck off");
                }
                else
                {
                    Aimcheck = true;
                    RDR2.UI.Screen.ShowSubtitle("Aimcheck On");
                }
            }

            // Aimcheck functionality
            if (Aimcheck)
            {
                if (e.KeyCode == Keys.NumPad4 || e.KeyCode == Keys.Left)
                {
                    if (entAim == null) return;
                    World.AddExplosion(entAim.Position, explosion, 10f, 0);
                    RDR2.UI.Screen.ShowSubtitle("Booming [" + explosion.ToString() + "] " + entAim.GetType().ToString().Substring(5));
                }

                if (e.KeyCode == Keys.Add)
                {
                    explosion++;
                    RDR2.UI.Screen.ShowSubtitle("explosion type " + explosion.ToString());
                }

                if (e.KeyCode == Keys.Subtract)
                {
                    explosion--;
                    if (explosion < 0) explosion = 0;
                    RDR2.UI.Screen.ShowSubtitle("explosion type " + explosion.ToString());
                }

                if (e.KeyCode == Keys.NumPad5 || e.KeyCode == Keys.Clear)
                {
                    if (entAim == null) return;

                    float lx = entAim.Position.X;
                    float ly = entAim.Position.Y;
                    float lz = entAim.Position.Z;
                    //static void _FORCE_LIGHTNING_FLASH_AT_COORDS(float x, float y, float z) { invoke<Void>(0x67943537D179597C, x, y, z); } // 0x67943537D179597C b1207
                    Hash hash = (Hash)0x67943537D179597C;
                    Function.Call(hash, lx, ly, lz);

                    RDR2.UI.Screen.ShowSubtitle("Zapping " + entAim.GetType().ToString().Substring(5));
                }

                if (e.KeyCode == Keys.NumPad6 || e.KeyCode == Keys.Right)
                {
                    if (entAim == null) return;
                    if (!entAim.GetType().ToString().Contains("Ped")) return;
                    Ped pedAim = (Ped)entAim;
                    pedAim.ApplyDamage(1000);
                    RDR2.UI.Screen.ShowSubtitle("Killed " + entAim.GetType().ToString());
                }

                if (e.KeyCode == Keys.Divide)
                {
                    if (entAim == null) return;

                    entAim.FreezePosition = true;
                    RDR2.UI.Screen.ShowSubtitle("Frozen");
                }

                if (e.KeyCode == Keys.Multiply)
                {
                    if (entAim == null) return;

                    entAim.FreezePosition = false;
                    RDR2.UI.Screen.ShowSubtitle("Un-Frozen");
                }
            }
            //end aimcheck functionality

            if (e.KeyCode == Keys.I)
            {
                fSlowSpeed = fSlowSpeed - 0.1f;
                if (fSlowSpeed < 0.0f) fSlowSpeed = 0.0f;
                RDR2.UI.Screen.ShowSubtitle("Slow Speed = " + fSlowSpeed.ToString());
            }

            if (e.KeyCode == Keys.O)
            {
                fSlowSpeed = fSlowSpeed + 0.1f;
                if (fSlowSpeed > 1.0f) fSlowSpeed = 1.0f;
                RDR2.UI.Screen.ShowSubtitle("Slow Speed = " + fSlowSpeed.ToString());
            }

            if (e.KeyCode == Slowkey || (mbSlow != MouseButtons.None && mb == mbSlow))
            {
                if (slow)
                {
                    slow = false;
                    Game.TimeScale = 1.0f;
                }
                else
                {
                    slow = true;
                    Game.TimeScale = fSlowSpeed;
                }
            }

            if (e.KeyCode == HorseKey || (mbHorse != MouseButtons.None && mb == mbHorse))
            {
                if (!Game.Player.Character.IsOnHorse) return;

                if (horsespeed)
                {
                    horsespeed = false;
                    RDR2.UI.Screen.ShowSubtitle("Horse Speed OFF");
                }
                else
                {
                    horsespeed = true;
                    RDR2.UI.Screen.ShowSubtitle("Horse Speed ON");
                }
            }
        }
    }
}
