//SplitScreen by Ganossa (mediehawk@gmail.com)
//Ported to Reshade 4.x by CRubino

//>Split Screen Shader Settings<\\
#define SScomparable 1 //[0:1] //-Splits the screen in the middle and draws the same image twice.
#define SScomparableStretch 0 //[0:1] //-Shows the full image on each side of the comparable splitscreen
#define SSslider 0 //[0:1] //-Activates an active transition between original and shader image
#define SSsliderSpeed 0.02 //[0.00:1.00] //-Defines the speed of the transition
#define SSaxis 1 //[0:1] //-To select the splitscreen axis; 0 => y; 1 => x
#define SSborderWidth 0.002 //[0.000:1.000] //-Width of the border between original and shader image 

#include "ReShade.fxh"

//Split Screen Shader

texture OriginalColorTex { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8; };	
sampler OColorBuffer { Texture = OriginalColorTex; };

// Pixel shaders
void PS_BackupBuffer(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 color : SV_Target)
{
	color = tex2D(ReShade::BackBuffer, texcoord.xy);
}

texture sMaskTex < source = "reshade-shaders/Textures/sMask.png"; > { Width = 1920; Height = 1080; MipLevels = 1; Format = RGBA8; };
sampler sMaskColor { Texture = sMaskTex; };

uniform float2 sSlider < source = "pingpong"; min = 0; max = 1; step = float2(SSsliderSpeed, SSsliderSpeed); >;

float4 PS_Split(float4 vposition : SV_Position, float2 texcoord : TexCoord) : SV_Target
{

//REDUNDANCY NEEDS TO BE DECREASED :-)

	#if SSaxis
		#if SScomparable && SSslider
			if(texcoord.x < 0.5f-SSborderWidth) return tex2D(OColorBuffer, float2(0.5f+texcoord.x-sSlider.x/2.0f,texcoord.y));
			else if(texcoord.x > 0.5f+SSborderWidth) return tex2D(ReShade::BackBuffer, float2(texcoord.x-sSlider.x/2.0f,texcoord.y));		
			else return float4(0.95,0.95,0.9,1);
		#elif SScomparable
			#if SScomparableStretch
				if(texcoord.y < 0.25f || texcoord.y > 0.75f) return float4(0,0,0,0);
				if(texcoord.x < 0.5f-SSborderWidth) return tex2D(OColorBuffer, float2(texcoord.x*2.0f,texcoord.y*2.0f-0.5f));
				else if(texcoord.x > 0.5f+SSborderWidth) return tex2D(ReShade::BackBuffer, float2(texcoord.x*2.0f-1.0f,texcoord.y*2.0f-0.5f));
				else return float4(0.95,0.95,0.9,1);	
			#else
				if(texcoord.x < 0.5f-SSborderWidth) return tex2D(OColorBuffer, float2(texcoord.x+0.25f,texcoord.y));
				else if(texcoord.x > 0.5f+SSborderWidth) return tex2D(ReShade::BackBuffer, float2(texcoord.x-0.25f,texcoord.y));
				else return float4(0.95,0.95,0.9,1);
			#endif
		#elif SSslider
			if(texcoord.x < sSlider.x-0.005f) return tex2D(OColorBuffer, texcoord);
			else if(texcoord.x > sSlider.x+0.005f) return tex2D(ReShade::BackBuffer, texcoord);
			else return float4(0.95,0.95,0.9,1);
		#endif		
	#else
		#if SScomparable && SSslider
			if(texcoord.y < 0.5f-SSborderWidth) return tex2D(OColorBuffer, float2(texcoord.x,0.5f+texcoord.y-sSlider.x/2.0f));
			else if(texcoord.y > 0.5f+SSborderWidth) return tex2D(ReShade::BackBuffer, float2(texcoord.x,texcoord.y-sSlider.x/2.0f));
			else return float4(0.95,0.95,0.9,1);		
		#elif SScomparable
			#if SScomparableStretch
				if(texcoord.x < 0.25f || texcoord.x > 0.75f) return float4(0,0,0,0);
				if(texcoord.y < 0.5f-SSborderWidth) return tex2D(OColorBuffer, float2(texcoord.x*2.0f-0.5f,texcoord.y*2.0f));
				else if(texcoord.y > 0.5f+SSborderWidth) return tex2D(ReShade::BackBuffer, float2(texcoord.x*2.0f-0.5f,texcoord.y*2.0f-1-0f));
				else return float4(0.95,0.95,0.9,1);
			#else
				if(texcoord.y < 0.5f-SSborderWidth) return tex2D(OColorBuffer, float2(texcoord.x,texcoord.y+0.25f));
				else if(texcoord.y > 0.5f+SSborderWidth) return tex2D(ReShade::BackBuffer, float2(texcoord.x,texcoord.y-0.25f));
				else return float4(0.95,0.95,0.9,1);
			#endif
		#elif SSslider
			if(texcoord.y < sSlider.x-SSborderWidth) return tex2D(OColorBuffer, texcoord);
			else if(texcoord.y > sSlider.x+SSborderWidth) return tex2D(ReShade::BackBuffer, texcoord);
			else return float4(0.95,0.95,0.9,1);
		#endif		
	#endif

	return lerp(tex2D(OColorBuffer, texcoord), tex2D(ReShade::BackBuffer, texcoord), tex2D(sMaskColor, texcoord).r); 
}

// Rendering passes
technique BackupBuffer
{
	pass ColorBackup
	{
		VertexShader = PostProcessVS;
		PixelShader = PS_BackupBuffer;
		RenderTarget = OriginalColorTex;
	}
}

technique SplitScreen
{
	pass SplitscreenBegin
	{
		VertexShader = PostProcessVS;
		PixelShader = PS_Split;
	}
}

