﻿using System;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using RDR2;
using RDR2.Native;
using RDR2.Math;
using RDR2.UI;

namespace testMod
{
    public class Client : Script
    {
        // public vars
        public Entity lastTarget;

        public Client()
        {
            Tick += OnTick;

            Interval = 1;
        }


        private void OnTick(object sender, EventArgs e)
        {
            Ped playerPed = Game.Player.Character;
            Player player = Game.Player;
            var out1 = new OutputArgument();
            UInt32 lasso = Function.Call<UInt32>(Hash.GET_HASH_KEY, "WEAPON_LASSO");

            if (Function.Call<bool>(Hash.HAS_PED_GOT_WEAPON, playerPed, lasso, 0, 0))
            {
                //player has lasso
                if (Function.Call<bool>(Hash.GET_CURRENT_PED_WEAPON, playerPed, out1, true, 0, false))
                {
                    WeaponHash weaponhash = out1.GetResult<WeaponHash>();
                    if (weaponhash == Function.Call<WeaponHash>(Hash.GET_HASH_KEY, "WEAPON_LASSO"))
                    {
                        //Current equiped weapon is lasso
                        if (lastTarget != null)
                        {
                            if (Function.Call<int>(Hash.GET_ENTITY_HEALTH, lastTarget) < 25)
                            {
                                Function.Call(Hash._SET_ENTITY_HEALTH, lastTarget, 95);
                                //RDR2.UI.Screen.ShowSubtitle("HEALTH ADDED");
                            }
                        }

                        if (Function.Call<bool>(Hash.IS_PED_SHOOTING, playerPed))
                        {
                            //get lasso target
                            var targetP = new OutputArgument();
                            if (Function.Call<bool>(Hash.GET_ENTITY_PLAYER_IS_FREE_AIMING_AT, player, targetP))
                            {
                                lastTarget = targetP.GetResult<Entity>();
                            }
                        }
                    }
                }
            }
        }
    }
}

