#include "stdafx.h"

HMODULE dll_handle_;
HMODULE exe_handle_;

std::filesystem::path dll_path_;

// MemoryCompare/FindSignature functions from https://github.com/Zer0Mem0ry/SignatureScanner
// for comparing a region in memory, needed in finding a signature
bool MemoryCompare(const BYTE* bData, const BYTE* bMask, const char* szMask) {
	for (; *szMask; ++szMask, ++bData, ++bMask) {
		if (*szMask == 'x' && *bData != *bMask) {
			return false;
		}
	}
	return (*szMask == NULL);
}

// for finding a signature/pattern in memory of another process
BYTE* FindSignature(void* start, DWORD size, const char* sig, const char* mask)
{
	BYTE* data = (BYTE*)start;
	SIZE_T bytesRead;

	for (DWORD i = 0; i < size; i++)
	{
		if (MemoryCompare((const BYTE*)(data + i), (const BYTE*)sig, mask)) {
			return (BYTE*)start + i;
		}
	}

	return nullptr;
}

void Patches_Init()
{
	static bool hasPatched = false;
	if (hasPatched)
		return;

	dlog("Patches_Init...");

	// Patch out the code that sets "IsGameModded" flag, to make it set to 0 instead of 1, mod files will still be loaded in however
	// With the flag set the game will display a "Mod Warning" message at startup, which this patch will prevent from showing
	// Not sure what else this might effect though!

	// TODO: find a better signature...
	// Patch byte:                                                                     vv this one
	const char* signature = "\xE8\x00\x00\x00\x00\x49\x00\x00\xC6\x80\x00\x00\x00\x00\x01\x48";
	const char* mask = "x****x**xx**xxxx";

	// Search for NMS.exe module instead of using exe_module, to make sure this is NMS...
	auto mod = GetModuleHandleA("NMS.exe");
	if (mod != NULL)
	{
		MODULEINFO modInfo;
		if (GetModuleInformation(GetCurrentProcess(), mod, &modInfo, sizeof(MODULEINFO)))
		{
			auto patchAddress = FindSignature((void*)mod, modInfo.SizeOfImage, signature, mask);
			if (patchAddress != nullptr)
			{
				patchAddress += 14;
				dlog("Patch addr: %p", patchAddress);
				SafeWrite<BYTE>(patchAddress, 0);
			}
		}
	}

	hasPatched = true;
}

// Delay-load hooks, for getting around SteamStub (as the code will be encrypted until SteamStub finishes)
// See Injector_InitSteamStub below for more details
typedef void(*GetSystemTimeAsFileTime_ptr)(LPFILETIME lpSystemTimeAsFileTime);
GetSystemTimeAsFileTime_ptr GetSystemTimeAsFileTime_orig = NULL;
GetSystemTimeAsFileTime_ptr* GetSystemTimeAsFileTime_iat = NULL;

typedef BOOL(*QueryPerformanceCounter_ptr)(LARGE_INTEGER* lpPerformanceCount);
QueryPerformanceCounter_ptr QueryPerformanceCounter_orig = NULL;
QueryPerformanceCounter_ptr* QueryPerformanceCounter_iat = NULL;

static void GetSystemTimeAsFileTime_Hook(LPFILETIME lpSystemTimeAsFileTime)
{
	// call original hooked func
	GetSystemTimeAsFileTime_orig(lpSystemTimeAsFileTime);

	// patch iats back to original
	SafeWrite(GetSystemTimeAsFileTime_iat, GetSystemTimeAsFileTime_orig);
	SafeWrite(QueryPerformanceCounter_iat, QueryPerformanceCounter_orig);

	// run our code :)
	Patches_Init();
}

static BOOL QueryPerformanceCounter_hook(LARGE_INTEGER* lpPerformanceCount)
{
	// patch iats back to original
	SafeWrite(GetSystemTimeAsFileTime_iat, GetSystemTimeAsFileTime_orig);
	SafeWrite(QueryPerformanceCounter_iat, QueryPerformanceCounter_orig);

	// run our code :)
	Patches_Init();

	// call original hooked func
	return QueryPerformanceCounter_orig(lpPerformanceCount);
}

void Injector_InitSteamStub()
{
	// Hook the GetSystemTimeAsFileTime function, in most games this seems to be one of the first imports called once SteamStub has finished.
	bool hooked = false;
	GetSystemTimeAsFileTime_iat = (GetSystemTimeAsFileTime_ptr*)GetIATPointer(exe_handle_, "KERNEL32.DLL", "GetSystemTimeAsFileTime");
	if (GetSystemTimeAsFileTime_iat)
	{
		// Found IAT address, hook the function to run our own code instead
		dlog("GetSystemTimeAsFileTime @ %p (-> %p)", GetSystemTimeAsFileTime_iat, *GetSystemTimeAsFileTime_iat);

		GetSystemTimeAsFileTime_orig = *GetSystemTimeAsFileTime_iat;
		SafeWrite(GetSystemTimeAsFileTime_iat, GetSystemTimeAsFileTime_Hook);

		dlog("-> %p", *GetSystemTimeAsFileTime_iat);
		hooked = true;
	}

	// As a backup we'll also hook QueryPerformanceCounter, almost every game makes use of this
	QueryPerformanceCounter_iat = (QueryPerformanceCounter_ptr*)GetIATPointer(exe_handle_, "KERNEL32.DLL", "QueryPerformanceCounter");
	if (QueryPerformanceCounter_iat)
	{
		// Found IAT address, hook the function to run our own code instead
		dlog("QueryPerformanceCounter @ %p (-> %p)", QueryPerformanceCounter_iat, *QueryPerformanceCounter_iat);

		QueryPerformanceCounter_orig = *QueryPerformanceCounter_iat;
		SafeWrite(QueryPerformanceCounter_iat, QueryPerformanceCounter_hook);

		dlog("-> %p", *QueryPerformanceCounter_iat);
		hooked = true;
	}

	// If we failed to hook, try loading the libraries anyway
	if (!hooked)
	{
		dlog("Injector_InitSteamStub failed, loading directly...");
		Patches_Init();
	}
}

void Injector_Init(HINSTANCE Instance)
{
	dll_handle_ = Instance;
	exe_handle_ = GetModuleHandleA(NULL);

	// Find our DLLs path
	WCHAR modulePathW[4096];
	GetModuleFileNameW(dll_handle_, modulePathW, _countof(modulePathW));
	dll_path_ = modulePathW;

	// TODO: detect situations where we don't need to do this?
	Injector_InitSteamStub();
}

EXPORT BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpReserved)
{
	if (fdwReason == DLL_PROCESS_ATTACH)
	{
		// Call Proxy_Attach to fix up our imports etc to point to original DLL
		Proxy_Attach(hinstDLL);
		// and then begin injecting our code
		Injector_Init(hinstDLL);
	}

	return TRUE;
}
