﻿using System;
using System.IO;
using System.Text;

namespace NMSResign
{
    class Program
    {
        static string BanksPath = ".";
        static string GetFilePath(string fileName)
        {
            return Path.Combine(BanksPath, fileName);
        }

        static bool BanksPathValid()
        {
            return File.Exists(GetFilePath("BankSignatures.bin"));
        }

        static void Main(string[] args)
        {
            bool decrypt = args.Length > 0 && args[0].ToLower() == "decrypt";

            // Get path to PCBANKS folder...
            var testPaths = new string[] {
                ".",
                "..",
                "PCBANKS",
                @"..\PCBANKS",
                @"GAMEDATA\PCBANKS",
                @"..\GAMEDATA\PCBANKS"
            };

            var foundBanks = false;
            foreach (var path in testPaths)
            {
                BanksPath = path;
                if (BanksPathValid())
                {
                    foundBanks = true;
                    break;
                }
            }

            if (!foundBanks)
            {
                Console.WriteLine("Failed to find BankSignatures.bin file...");
                Console.WriteLine("Make sure NMSResign.exe is somewhere in your NMS directory!");
                Console.WriteLine();
                Console.WriteLine("Press any key to exit...");
                Console.ReadLine();
                return;
            }

            var bankSigsPath = GetFilePath("BankSignatures.bin");
            var bankSigsKey = Encoding.ASCII.GetBytes("ds8r5fV80hbtbDCXXHXPT0dAKMgndVl1");
            Array.Resize(ref bankSigsKey, 0x10); // some reason they use a key larger than 0x10 bytes, even though only first 0x10 is used...

            if (decrypt)
            {
                var data = File.ReadAllBytes(bankSigsPath);
                data = Xxtea.XXTEA.Decrypt(data, bankSigsKey);
                File.WriteAllBytes(bankSigsPath + ".dec", data);
                Console.WriteLine($"Wrote decrypted BankSignatures.bin to {bankSigsPath}.dec");
                return;
            }

            // Create Bank"Signature" file
            var bankSigs = "";
            foreach (var pak in Directory.GetFiles(BanksPath, "*.pak"))
            {
                var info = new FileInfo(pak);
                bankSigs += Path.GetFileName(pak).ToUpper() + "," + info.Length.ToString() + "\r\n";
            }
            var bankSigsData = Encoding.ASCII.GetBytes(bankSigs);

            var stream = new MemoryStream();
            using (var writer = new BinaryWriter(stream))
            {
                writer.Write(bankSigsData);
                writer.Write((byte)0); // null-terminate, should this pad to the next 4-byte alignment though?
                writer.Write(bankSigsData.Length);
                bankSigsData = stream.ToArray();
            }

            bankSigsData = Xxtea.XXTEA.Encrypt(bankSigsData, bankSigsKey);
            File.WriteAllBytes(bankSigsPath, bankSigsData);

            Console.WriteLine($"Wrote updated BankSignatures.bin to {bankSigsPath}");
        }
    }
}
