/*
 * Decompiled with CFR 0.152.
 */
package nmsvrscreenshotfix;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class NMSVRScreenshotFix {
    static int totalFiles = 0;
    static BufferedImage curImage;
    static String appendToNewFile;

    public static void main(String[] args) {
        File curFolder = new File(System.getProperty("user.dir"));
        System.out.println("searching in " + curFolder.getPath());
        for (File fileEntry : curFolder.listFiles()) {
            String curFilePath = fileEntry.getPath();
            try {
                if (fileEntry.isDirectory() || !NMSVRScreenshotFix.isImage(curFilePath)) continue;
                System.out.print(++totalFiles + ". ");
                System.out.println(curFilePath);
                curImage = ImageIO.read(fileEntry);
                if (!NMSVRScreenshotFix.shouldResize(curImage.getWidth(), curImage.getHeight())) continue;
                NMSVRScreenshotFix.squish(curFilePath);
            }
            catch (IOException e) {
                System.err.println(">> Caught IOException on file '" + curFilePath + "':\n  " + e.getMessage());
            }
        }
    }

    public static boolean isImage(String path) {
        int dotIndex = path.lastIndexOf(46);
        String extension = dotIndex == -1 ? "no extension" : path.substring(dotIndex + 1);
        return extension.equals("png") || extension.equals("jpg") || extension.equals("jpeg");
    }

    public static boolean shouldResize(int width, int height) {
        if (width == height) {
            System.out.println(">> Already 1:1 aspect ratio");
            return false;
        }
        if (width < height) {
            System.out.println(">> Height is greater than width");
            return false;
        }
        return true;
    }

    public static void squish(String inputImagePath) throws IOException {
        int finalWidth = curImage.getHeight();
        int height = curImage.getHeight();
        BufferedImage outputImage = new BufferedImage(finalWidth, height, curImage.getType());
        Graphics2D g2d = outputImage.createGraphics();
        g2d.drawImage(curImage, 0, 0, finalWidth, height, null);
        g2d.dispose();
        int dotIndex = inputImagePath.lastIndexOf(46);
        String formatName = inputImagePath.substring(dotIndex + 1);
        String outputImagePath = NMSVRScreenshotFix.generateOutputPath(inputImagePath, dotIndex);
        ImageIO.write((RenderedImage)outputImage, formatName, new File(outputImagePath));
        System.out.println(">> Converted");
    }

    public static String generateOutputPath(String inputPath, int dotIndex) {
        return inputPath.substring(0, dotIndex) + appendToNewFile + inputPath.substring(dotIndex);
    }

    static {
        appendToNewFile = "_fix";
    }
}

