/*
 * Decompiled with CFR 0.152.
 */
package nmsvrscreenshotfix;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nmsvrscreenshotfix.LogicController;
import nmsvrscreenshotfix.SettingsUI;

public class ProgramUI
extends JFrame {
    LogicController controller = LogicController.getInstance();
    String[] fileErrorOptions = new String[]{"Okay", "Okay, Skip Remaining Errors", "Cancel Execution"};
    private JTextArea behaviorTextArea;
    private JButton executeButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JProgressBar progressBar;
    private JButton resultFolderButton;
    private JTextField resultFolderField;
    private JButton settingsButton;
    private JButton sourceFolderButton;
    private JTextField sourceFolderField;

    public ProgramUI() {
        this.initComponents();
        this.resultFolderField.setText(this.controller.resultPath);
        this.sourceFolderField.setText(this.controller.sourcePath);
        this.behaviorTextArea.setText(this.controller.getCurrentBehaviorString());
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.sourceFolderField = new JTextField();
        this.sourceFolderButton = new JButton();
        this.resultFolderField = new JTextField();
        this.resultFolderButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.behaviorTextArea = new JTextArea();
        this.settingsButton = new JButton();
        this.executeButton = new JButton();
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.setTitle("NMS VR Screenshot Fix");
        this.setResizable(false);
        this.jLabel2.setText("Source Folder:");
        this.jLabel1.setText("Behavior:");
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel3.setText("Result Folder:");
        this.sourceFolderField.setText("err");
        this.sourceFolderField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 32));
        this.sourceFolderField.setMinimumSize(new Dimension(14, 32));
        this.sourceFolderField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramUI.this.sourceFolderFieldActionPerformed(evt);
            }
        });
        this.sourceFolderButton.setText("...");
        this.sourceFolderButton.setMaximumSize(new Dimension(22, 22));
        this.sourceFolderButton.setMinimumSize(new Dimension(22, 22));
        this.sourceFolderButton.setPreferredSize(new Dimension(32, 32));
        this.sourceFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramUI.this.sourceFolderButtonActionPerformed(evt);
            }
        });
        this.resultFolderField.setText("err");
        this.resultFolderField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 32));
        this.resultFolderField.setMinimumSize(new Dimension(14, 32));
        this.resultFolderField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramUI.this.resultFolderFieldActionPerformed(evt);
            }
        });
        this.resultFolderButton.setText("...");
        this.resultFolderButton.setMaximumSize(new Dimension(22, 22));
        this.resultFolderButton.setMinimumSize(new Dimension(22, 22));
        this.resultFolderButton.setPreferredSize(new Dimension(32, 32));
        this.resultFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramUI.this.resultFolderButtonActionPerformed(evt);
            }
        });
        this.behaviorTextArea.setEditable(false);
        this.behaviorTextArea.setColumns(20);
        this.behaviorTextArea.setLineWrap(true);
        this.behaviorTextArea.setRows(5);
        this.behaviorTextArea.setText("\u2022 Make copies of converted screenshots\n\u2022 Add prefix \" new_\" to the new image\n\u2022 Ex: \"image.png\" -> \"new_image.png\"\n");
        this.jScrollPane2.setViewportView(this.behaviorTextArea);
        this.settingsButton.setText("Behavior Settings");
        this.settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramUI.this.settingsButtonActionPerformed(evt);
            }
        });
        this.executeButton.setText("Execute");
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramUI.this.executeButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.executeButton).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.settingsButton)).addComponent(this.resultFolderField, -1, -1, Short.MAX_VALUE).addComponent(this.progressBar, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addComponent(this.sourceFolderField, -2, 315, -2).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceFolderButton, -2, 32, -2).addComponent(this.resultFolderButton, GroupLayout.Alignment.TRAILING, -2, 32, -2)).addGap(256, 256, 256)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(24, 24, 24).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceFolderButton, -1, -1, -2).addComponent(this.sourceFolderField, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jLabel2, -2, 32, -2))).addGap(17, 17, 17).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.resultFolderField, -1, 32, Short.MAX_VALUE)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultFolderButton, -2, -1, -2).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 25, -2).addComponent(this.jScrollPane2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.settingsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addComponent(this.executeButton, -1, -1, Short.MAX_VALUE)).addGap(12, 12, 12)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, 462, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2));
        this.pack();
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        if (this.controller.getIsExecuting()) {
            this.controller.cancelExecution();
        } else {
            this.controller.sourcePath = this.sourceFolderField.getText();
            this.controller.resultPath = this.resultFolderField.getText();
            if (this.controller.hasValidDirectoryPaths()) {
                this.controller.execute();
            } else {
                this.errorInvalidPath();
            }
        }
    }

    private void settingsButtonActionPerformed(ActionEvent evt) {
        new SettingsUI((Frame)this, true).setVisible(true);
        this.behaviorTextArea.setText(this.controller.getCurrentBehaviorString());
    }

    private void resultFolderButtonActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        int optionCode = jfc.showSaveDialog(null);
        if (optionCode == 0) {
            this.controller.resultPath = jfc.getSelectedFile().getAbsolutePath();
            this.resultFolderField.setText(this.controller.resultPath);
            this.behaviorTextArea.setText(this.controller.getCurrentBehaviorString());
        }
    }

    private void resultFolderFieldActionPerformed(ActionEvent evt) {
        this.controller.resultPath = this.resultFolderField.getText();
        this.behaviorTextArea.setText(this.controller.getCurrentBehaviorString());
    }

    private void sourceFolderButtonActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        int optionCode = jfc.showSaveDialog(null);
        if (optionCode == 0) {
            this.controller.sourcePath = jfc.getSelectedFile().getAbsolutePath();
            this.sourceFolderField.setText(this.controller.sourcePath);
            this.behaviorTextArea.setText(this.controller.getCurrentBehaviorString());
        }
    }

    private void sourceFolderFieldActionPerformed(ActionEvent evt) {
        this.controller.sourcePath = this.sourceFolderField.getText();
        this.behaviorTextArea.setText(this.controller.getCurrentBehaviorString());
    }

    public void toggleUI() {
        boolean shouldEnable = !this.controller.getIsExecuting();
        this.settingsButton.setEnabled(shouldEnable);
        this.sourceFolderField.setEnabled(shouldEnable);
        this.sourceFolderButton.setEnabled(shouldEnable);
        this.resultFolderField.setEnabled(shouldEnable);
        this.resultFolderButton.setEnabled(shouldEnable);
        if (this.controller.getIsExecuting()) {
            this.executeButton.setText("cancel");
        } else {
            this.executeButton.setText("execute");
        }
    }

    public void updateProgressBar(int value) {
        this.progressBar.setValue(value);
    }

    public void completePopup(int converted) {
        if (converted != 0) {
            JOptionPane.showMessageDialog(this, "" + converted + " images were converted successfully.", "Complete", 1);
            this.progressBar.setValue(0);
        } else {
            JOptionPane.showMessageDialog(this, "No images were able to be converted from in the source folder.", "Error: No images found", 2);
            this.progressBar.setValue(0);
        }
    }

    public void cancelPopup(int converted) {
        JOptionPane.showMessageDialog(this, "Converted " + converted + " files before canceling.", "Canceled", 0);
    }

    public void warningReplacingFiles() {
        int choice = JOptionPane.showOptionDialog(this, "By continuing you will be replacing your original screenshots. This cannot be undone.\nPlease press Cancel and change the behavior settings if this was not intended.", "Replacing Files", 2, 2, null, null, null);
        if (choice != 0) {
            this.controller.cancelExecution();
        }
    }

    public void errorInvalidPath() {
        JOptionPane.showMessageDialog(this, "One or both of the folder paths do not lead to a valid folder.\nMake sure the source and destination folders you choose exist.", "Error: invalid folder path", 2);
    }

    public void errorCorruptImage(String fileName) {
        int choice = JOptionPane.showOptionDialog(this, "The image file '" + fileName + "' cannot be read and may be corrupt.", "Corrupt File Error: Cancel Execution?", -1, 0, null, this.fileErrorOptions, this.fileErrorOptions[0]);
        this.controller.userErrorResponse(choice);
    }

    public void errorReading(String fileName) {
        int choice = JOptionPane.showOptionDialog(this, "There was a problem reading the file, '" + fileName + "' from the source folder.", "Read Error: Cancel Execution?", -1, 0, null, this.fileErrorOptions, this.fileErrorOptions[0]);
        this.controller.userErrorResponse(choice);
    }

    public void errorWriting(String fileName) {
        int choice = JOptionPane.showOptionDialog(this, "There was a problem writing the file '" + fileName + "' to the destination folder.", "Write Error: Cancel Execution?", -1, 0, null, this.fileErrorOptions, this.fileErrorOptions[0]);
        this.controller.userErrorResponse(choice);
    }

    public void warningEmptyText() {
        JOptionPane.showMessageDialog(this, "The 'Text to be added' field cannot be left empty.", "Text left empty", 2);
    }

    public void warningExceededTextLimit() {
        JOptionPane.showMessageDialog(this, "Added text cannot exceed " + this.controller.MAX_ADD_TEXT_LENGTH + " characters.", "Text too long", 2);
    }

    public void warningInvalidText(char invalidChar) {
        JOptionPane.showMessageDialog(this, "Text must contain only alphanumeric characters, '_', and '-'.\nInvalid character: '" + invalidChar + "'.", "Invalid character in the text", 2);
    }
}

