/*
 * Decompiled with CFR 0.152.
 */
package nmsvrscreenshotfix;

import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import nmsvrscreenshotfix.ProgramUI;

class LogicController {
    private boolean isExecuting = false;
    private boolean canceled = false;
    private boolean triggerFileErrorPopups = true;
    private int totalFiles;
    private int filesConverted;
    private BufferedImage curImage;
    public String sourcePath = System.getProperty("user.dir");
    public String resultPath = System.getProperty("user.dir");
    public boolean shouldRename = true;
    public boolean renameNewFile = true;
    public String addTextToFileName = "_fix";
    public boolean addAsPrefix = false;
    int MAX_ADD_TEXT_LENGTH = 50;
    ProgramUI myUI;
    private static LogicController sharedController = null;

    private LogicController() {
        this.launchUI();
    }

    public static LogicController getInstance() {
        if (sharedController == null) {
            sharedController = new LogicController();
        }
        return sharedController;
    }

    private void launchUI() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ProgramUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ProgramUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ProgramUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ProgramUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogicController.this.myUI = new ProgramUI();
                LogicController.this.myUI.setVisible(true);
            }
        });
    }

    public void execute() {
        System.out.println("Starting Execution");
        this.isExecuting = true;
        this.canceled = false;
        this.myUI.updateProgressBar(0);
        this.filesConverted = 0;
        File sourceFolder = new File(this.sourcePath);
        File[] folderContents = sourceFolder.listFiles();
        this.totalFiles = folderContents.length;
        this.myUI.toggleUI();
        if (!this.shouldRename && this.sourcePath.equals(this.resultPath)) {
            this.myUI.warningReplacingFiles();
        }
        for (int fileIndex = 0; fileIndex < this.totalFiles && !this.canceled; ++fileIndex) {
            File curFile = folderContents[fileIndex];
            if (!folderContents[fileIndex].isDirectory() && this.isImage(curFile.getPath())) {
                System.out.println(">file name: " + curFile.getName());
                try {
                    this.curImage = ImageIO.read(folderContents[fileIndex]);
                    if (this.shouldResize(this.curImage.getWidth(), this.curImage.getHeight())) {
                        this.squish(curFile);
                    }
                }
                catch (IOException ex) {
                    if (this.triggerFileErrorPopups) {
                        this.myUI.errorReading(curFile.getName());
                    }
                    System.err.println(">> Caught IOException on '" + curFile.getPath() + "':\n  " + ex.getMessage());
                }
                catch (NullPointerException ex) {
                    if (this.triggerFileErrorPopups) {
                        this.myUI.errorCorruptImage(curFile.getName());
                    }
                    System.out.println(">> ImageIO.read returned null (likely corrupt): " + ex);
                }
            }
            this.myUI.updateProgressBar((fileIndex + 1) * 100 / this.totalFiles);
        }
        if (this.canceled) {
            this.myUI.cancelPopup(this.filesConverted);
            this.canceled = false;
            this.myUI.updateProgressBar(0);
        } else {
            this.myUI.completePopup(this.filesConverted);
        }
        this.triggerFileErrorPopups = true;
        this.isExecuting = false;
        this.myUI.toggleUI();
        System.out.println("Finished Execution");
    }

    private void squish(File originalFile) throws IOException {
        int newWidth = this.curImage.getHeight();
        int height = this.curImage.getHeight();
        BufferedImage outputImage = new BufferedImage(newWidth, height, this.curImage.getType());
        Graphics2D g2d = outputImage.createGraphics();
        g2d.drawImage(this.curImage, 0, 0, newWidth, height, null);
        g2d.dispose();
        int fileDotIndex = originalFile.getName().lastIndexOf(46);
        String formatName = originalFile.getName().substring(fileDotIndex + 1);
        File newFile = new File(this.resultPath + "/" + originalFile.getName());
        if (this.shouldRename) {
            if (this.renameNewFile) {
                newFile = this.modifyFilePath(this.resultPath, originalFile.getName());
            } else {
                originalFile.renameTo(this.modifyFilePath(this.sourcePath, originalFile.getName()));
            }
        }
        try {
            ImageIO.write((RenderedImage)outputImage, formatName, newFile);
            ++this.filesConverted;
            System.out.println(">> Converted");
        }
        catch (Exception ex) {
            if (this.triggerFileErrorPopups) {
                this.myUI.errorWriting(newFile.getName());
            }
            System.err.print(">> Error writing to result folder " + ex.getClass());
        }
    }

    public void cancelExecution() {
        this.canceled = true;
    }

    public boolean getIsExecuting() {
        return this.isExecuting;
    }

    public String getCurrentBehaviorString() {
        String behavior = "";
        behavior = !this.shouldRename && this.sourcePath.equals(this.resultPath) ? behavior + "\u2022 Replacing originals with converted screenshots" : behavior + "\u2022 Making copies of converted screenshots";
        behavior = behavior + "\n";
        if (this.shouldRename) {
            behavior = this.addAsPrefix ? behavior + "\u2022 Adding prefix " : behavior + "\u2022 Adding suffix ";
            behavior = behavior + "\"" + this.addTextToFileName + "\" to ";
            behavior = this.renameNewFile ? behavior + "converted image" : behavior + "original image";
            behavior = behavior + "\n";
            behavior = behavior + "\u2022 " + this.getExampleRename();
        }
        return behavior;
    }

    private String getRename(String oldName) {
        int dotIndex = oldName.lastIndexOf(46);
        String name = oldName.substring(0, dotIndex);
        String ext = oldName.substring(dotIndex);
        return this.addAsPrefix ? this.addTextToFileName + name + ext : name + this.addTextToFileName + ext;
    }

    private String getExampleRename() {
        String exampleName = this.renameNewFile ? "converted.png" : "original.png";
        return "Ex: \"" + exampleName + "\" -> \"" + this.getRename(exampleName) + "\"";
    }

    private File modifyFilePath(String parentPath, String fileName) {
        return new File(parentPath + "/" + this.getRename(fileName));
    }

    private boolean isImage(String path) {
        int dotIndex = path.lastIndexOf(46);
        String extension = dotIndex == -1 ? "no extension" : path.substring(dotIndex + 1);
        extension = extension.toLowerCase();
        return extension.equals("png") || extension.equals("jpg") || extension.equals("jpeg");
    }

    private boolean shouldResize(int width, int height) {
        if (width == height) {
            System.out.println(">> Already 1:1 aspect ratio");
            return false;
        }
        if (width < height) {
            System.out.println(">> Height is greater than width");
            return false;
        }
        return true;
    }

    public String generateOutputPath(String inputPath, int dotIndex) {
        return inputPath.substring(0, dotIndex) + this.addTextToFileName + inputPath.substring(dotIndex);
    }

    public boolean isValidTextAddition(String phrase) {
        if (phrase.length() == 0) {
            this.myUI.warningEmptyText();
            return false;
        }
        if (phrase.length() > this.MAX_ADD_TEXT_LENGTH) {
            this.myUI.warningExceededTextLimit();
            return false;
        }
        for (int charIndex = 0; charIndex < phrase.length(); ++charIndex) {
            char curChar = phrase.charAt(charIndex);
            if (Character.isLetterOrDigit(curChar) || curChar == '_' || curChar == '-') continue;
            this.myUI.warningInvalidText(curChar);
            return false;
        }
        return true;
    }

    public boolean hasValidDirectoryPaths() {
        return new File(this.sourcePath).isDirectory() && new File(this.resultPath).isDirectory();
    }

    public void userErrorResponse(int userChoice) {
        if (userChoice == 1) {
            this.triggerFileErrorPopups = false;
        } else if (userChoice == 2) {
            this.canceled = true;
        }
    }
}

