/*
 * Decompiled with CFR 0.152.
 */
package nmsvrscreenshotfix;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nmsvrscreenshotfix.LogicController;

public class SettingsUI
extends JDialog {
    LogicController controller = LogicController.getInstance();
    private JButton ConfirmButton;
    private JTextField addTextField;
    private JRadioButton dontRenameButton;
    private JLabel jLabel1;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JPanel newFileSettings;
    private JRadioButton prefixButton;
    private ButtonGroup prefixOrSuffix;
    private JRadioButton renameButton;
    private JRadioButton renameNewButton;
    private JRadioButton renameOriginalButton;
    private ButtonGroup renameWhichGroup;
    private ButtonGroup replaceOrCopyGroup;
    private JRadioButton suffixButton;

    public SettingsUI(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (this.controller.shouldRename) {
            this.renameButton.setSelected(true);
        } else {
            this.dontRenameButton.setSelected(true);
        }
        if (this.controller.renameNewFile) {
            this.renameNewButton.setSelected(true);
        } else {
            this.renameOriginalButton.setSelected(true);
        }
        this.addTextField.setText(this.controller.addTextToFileName);
        if (this.controller.addAsPrefix) {
            this.prefixButton.setSelected(true);
        } else {
            this.suffixButton.setSelected(true);
        }
        if (this.dontRenameButton.isSelected()) {
            this.toggleRenamePanel(this.newFileSettings);
        }
    }

    private void initComponents() {
        this.replaceOrCopyGroup = new ButtonGroup();
        this.renameWhichGroup = new ButtonGroup();
        this.prefixOrSuffix = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.dontRenameButton = new JRadioButton();
        this.renameButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.ConfirmButton = new JButton();
        this.newFileSettings = new JPanel();
        this.renameNewButton = new JRadioButton();
        this.renameOriginalButton = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.prefixButton = new JRadioButton();
        this.suffixButton = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.addTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Settings");
        this.setModal(true);
        this.setResizable(false);
        this.replaceOrCopyGroup.add(this.dontRenameButton);
        this.dontRenameButton.setText("Keep Same Names");
        this.dontRenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsUI.this.dontRenameButtonActionPerformed(evt);
            }
        });
        this.replaceOrCopyGroup.add(this.renameButton);
        this.renameButton.setText("Edit File Names");
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsUI.this.renameButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Rename files?");
        this.ConfirmButton.setText("confirm");
        this.ConfirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsUI.this.ConfirmButtonActionPerformed(evt);
            }
        });
        this.renameWhichGroup.add(this.renameNewButton);
        this.renameNewButton.setText("Converted File");
        this.renameNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsUI.this.renameNewButtonActionPerformed(evt);
            }
        });
        this.renameWhichGroup.add(this.renameOriginalButton);
        this.renameOriginalButton.setText("Original File");
        this.renameOriginalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsUI.this.renameOriginalButtonActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Rename which file?");
        this.jLabel7.setText("Add as a prefix or suffix?");
        this.prefixOrSuffix.add(this.prefixButton);
        this.prefixButton.setText("Add Prefix");
        this.prefixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsUI.this.prefixButtonActionPerformed(evt);
            }
        });
        this.prefixOrSuffix.add(this.suffixButton);
        this.suffixButton.setText("Add Suffix");
        this.suffixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsUI.this.suffixButtonActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Text to be added:");
        this.addTextField.setText("_new");
        this.addTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsUI.this.addTextFieldActionPerformed(evt);
            }
        });
        GroupLayout newFileSettingsLayout = new GroupLayout(this.newFileSettings);
        this.newFileSettings.setLayout(newFileSettingsLayout);
        newFileSettingsLayout.setHorizontalGroup(newFileSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, newFileSettingsLayout.createSequentialGroup().addGroup(newFileSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel6).addComponent(this.renameOriginalButton).addComponent(this.prefixButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(newFileSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.renameNewButton).addComponent(this.suffixButton)).addGap(35, 35, 35)).addGroup(newFileSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.addTextField, -2, 290, -2).addContainerGap(23, Short.MAX_VALUE)));
        newFileSettingsLayout.setVerticalGroup(newFileSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, newFileSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addGap(2, 2, 2).addGroup(newFileSettingsLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.renameOriginalButton).addComponent(this.renameNewButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addGap(4, 4, 4).addGroup(newFileSettingsLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.prefixButton).addComponent(this.suffixButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(27, 27, 27).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -2, 321, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.newFileSettings, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.dontRenameButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.renameButton).addGap(35, 35, 35)))))).addGroup(jPanel1Layout.createSequentialGroup().addGap(145, 145, 145).addComponent(this.ConfirmButton))).addContainerGap(20, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dontRenameButton).addComponent(this.renameButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newFileSettings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfirmButton, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void dontRenameButtonActionPerformed(ActionEvent evt) {
        this.controller.shouldRename = false;
        this.toggleRenamePanel(this.newFileSettings);
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        this.controller.shouldRename = true;
        this.toggleRenamePanel(this.newFileSettings);
    }

    private void ConfirmButtonActionPerformed(ActionEvent evt) {
        if (this.renameButton.isSelected()) {
            if (this.controller.isValidTextAddition(this.addTextField.getText())) {
                this.controller.addTextToFileName = this.addTextField.getText();
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void renameNewButtonActionPerformed(ActionEvent evt) {
        this.controller.renameNewFile = true;
    }

    private void prefixButtonActionPerformed(ActionEvent evt) {
        this.controller.addAsPrefix = true;
    }

    private void addTextFieldActionPerformed(ActionEvent evt) {
    }

    private void renameOriginalButtonActionPerformed(ActionEvent evt) {
        this.controller.renameNewFile = false;
    }

    private void suffixButtonActionPerformed(ActionEvent evt) {
        this.controller.addAsPrefix = false;
    }

    private void toggleRenamePanel(JPanel panel) {
        Component[] components;
        boolean shouldEnable = this.renameButton.isSelected();
        panel.setEnabled(shouldEnable);
        for (Component component : components = panel.getComponents()) {
            if (component instanceof JPanel) {
                this.toggleRenamePanel((JPanel)component);
            }
            component.setEnabled(shouldEnable);
        }
    }
}

