#include "script.h"
#include "keyboard.h"

#include <fstream>
#include <sstream>
#include <map>

using namespace std;

Hash key(const char* key)
{
	return MISC::GET_HASH_KEY(key);
}

void showSubtitle(const char* text)
{
	UILOG::_UILOG_SET_CACHED_OBJECTIVE((const char*)MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", text)); //
	UILOG::_UILOG_PRINT_CACHED_OBJECTIVE(); // _UILOG_PRINT_CACHED_OBJECTIVE
	UILOG::_UILOG_CLEAR_CACHED_OBJECTIVE(); //
}

// cores functions
enum class Core {
	Health,
	Stamina,
	DeadEye
};

int getMaxPlayerPoint(Core coreIndex)
{
	return ATTRIBUTE::GET_MAX_ATTRIBUTE_POINTS(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex));
}

int getPlayerPoint(Core coreIndex)
{
	return ATTRIBUTE::GET_ATTRIBUTE_POINTS(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex));
}

void setPlayerPoint(Core coreIndex, int value)
{
	ATTRIBUTE::SET_ATTRIBUTE_POINTS(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex), value);
}

int getPlayerRank(Core coreIndex)
{
	return ATTRIBUTE::GET_ATTRIBUTE_RANK(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex));
}

void setPlayerRank(Core coreIndex, int value)
{
	ATTRIBUTE::SET_ATTRIBUTE_BASE_RANK(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex), value);
}

int getPlayerCore(Core coreIndex)
{
	return ATTRIBUTE::_GET_ATTRIBUTE_CORE_VALUE(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex));
}

void setPlayerCore(Core coreIndex, int coreValue)
{
	ATTRIBUTE::_SET_ATTRIBUTE_CORE_VALUE(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex), coreValue);
}

int getHorseCore(Core coreIndex)
{
	return ATTRIBUTE::_GET_ATTRIBUTE_CORE_VALUE(PLAYER::_GET_SADDLE_HORSE_FOR_PLAYER(PLAYER::PLAYER_ID()), static_cast<int>(coreIndex));
}

void setHorseCore(Core coreIndex, int coreValue)
{
	ATTRIBUTE::_SET_ATTRIBUTE_CORE_VALUE(PLAYER::_GET_SADDLE_HORSE_FOR_PLAYER(PLAYER::PLAYER_ID()), static_cast<int>(coreIndex), coreValue);
}

bool isPlayerCoreOverpowered(Core coreIndex)
{
	return ATTRIBUTE::_0x200373A8DF081F22(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex));
}

bool isPlayerPointOverpowered(Core coreIndex)
{
	return ATTRIBUTE::_IS_ATTRIBUTE_OVERPOWERED(PLAYER::PLAYER_PED_ID(), static_cast<int>(coreIndex));
}

bool isHorseCoreOverpowered(Core coreIndex)
{
	return ATTRIBUTE::_0x200373A8DF081F22(PLAYER::_GET_SADDLE_HORSE_FOR_PLAYER(PLAYER::PLAYER_PED_ID()), static_cast<int>(coreIndex));
}

float getTimeOfDayModifier()
{
	if (CLOCK::GET_CLOCK_HOURS() >= 5 && CLOCK::GET_CLOCK_HOURS() < 11)
		return 1.5f;
	else if (CLOCK::GET_CLOCK_HOURS() >= 11 && CLOCK::GET_CLOCK_HOURS() < 14)
		return 1.25f;
	else if (CLOCK::GET_CLOCK_HOURS() >= 14 && CLOCK::GET_CLOCK_HOURS() < 18)
		return 1.75f;
	else if (CLOCK::GET_CLOCK_HOURS() >= 18 && CLOCK::GET_CLOCK_HOURS() < 23)
		return 2.0f;
	else if (CLOCK::GET_CLOCK_HOURS() >= 23 && CLOCK::GET_CLOCK_HOURS() < 5)
		return 2.5f;
	else
		return 1.0f;
}

void setAIDamageModifer(float melee, float weapon)
{
	PED::SET_AI_MELEE_WEAPON_DAMAGE_MODIFIER(melee);
	PED::SET_AI_WEAPON_DAMAGE_MODIFIER(weapon);
}

void setPlayerDamageModifer(float melee, float weapon)
{
	PLAYER::SET_PLAYER_MELEE_WEAPON_DAMAGE_MODIFIER(PLAYER::PLAYER_ID(), melee);
	PLAYER::SET_PLAYER_WEAPON_DAMAGE_MODIFIER(PLAYER::PLAYER_ID(), weapon);
}

void setPlayerHealthRechargeRate(float multiplier)
{
	PLAYER::SET_PLAYER_HEALTH_RECHARGE_MULTIPLIER(PLAYER::PLAYER_ID(), multiplier);
}

// math functions
int bCeil(float x)
{
	return BUILTIN::CEIL(x);
}

int bFloor(float x)
{
	return BUILTIN::FLOOR(x);
}

// conditions
bool isLoadingScreenActive()
{
	return SCRIPTS::_IS_LOADING_SCREEN_ACTIVE();
}

bool isPlayerJustDied()
{
	Entity playerID = PLAYER::PLAYER_ID();
	Entity playerPed = PLAYER::PLAYER_PED_ID();
	return PLAYER::IS_PLAYER_DEAD(playerID) && ENTITY::IS_ENTITY_DEAD(playerPed) && (getPlayerCore(Core::Health) <= 0);
}

bool isPlayerInMission()
{
	return MISC::GET_MISSION_FLAG() || MISC::IS_MINIGAME_IN_PROGRESS() || GRAPHICS::ANIMPOSTFX_IS_RUNNING("MissionFail01");
}

bool isPlayerInControl()
{
	return PLAYER::IS_PLAYER_CONTROL_ON(PLAYER::PLAYER_ID());
}

bool isPlayerJustSleep()
{
	Ped playerPed = PLAYER::PLAYER_PED_ID();
	return
		PED::_IS_PED_USING_SCENARIO_HASH(playerPed, key("WORLD_PLAYER_SLEEP_BEDROLL")) ||
		PED::_IS_PED_USING_SCENARIO_HASH(playerPed, key("WORLD_PLAYER_SLEEP_GROUND")) ||
		PED::_IS_PED_USING_SCENARIO_HASH(playerPed, key("PROP_PLAYER_SLEEP_BED")) ||
		PED::_IS_PED_USING_SCENARIO_HASH(playerPed, key("PROP_PLAYER_SLEEP_TENT_A_FRAME")) ||
		PED::_IS_PED_USING_SCENARIO_HASH(playerPed, key("PROP_PLAYER_SLEEP_A_FRAME_TENT_PLAYER_CAMPS"));
}

bool isPlayerJustSleep2(int lastHealth, int lastStamina, int lastDeadeye)
{
	if ((getPlayerCore(Core::Health) != lastHealth || getPlayerCore(Core::Stamina) != lastStamina || getPlayerCore(Core::DeadEye) != lastDeadeye) )
		return true;
	else
		return false;
}

bool isPlayerBathing()
{
	Ped playerPed = PLAYER::PLAYER_PED_ID();
	return (MISC::ARE_STRINGS_EQUAL(TASK::GET_TASK_MOVE_NETWORK_STATE(playerPed), "Bathing") || MISC::ARE_STRINGS_EQUAL(TASK::GET_TASK_MOVE_NETWORK_STATE(playerPed), "Intro"));
}

bool isPlayerInCombat()
{
	return PED::IS_PED_IN_COMBAT(PLAYER::PLAYER_PED_ID(), NULL) || PED::IS_PED_IN_MELEE_COMBAT(PLAYER::PLAYER_PED_ID());
}

bool isPlayerIdle()
{
	return TASK::IS_PED_STILL(PLAYER::PLAYER_PED_ID());
}

bool isPlayerOnMount()
{
	return PED::IS_PED_ON_MOUNT(PLAYER::PLAYER_PED_ID());
}

bool isPlayerInCover()
{
	return PED::IS_PED_IN_COVER(PLAYER::PLAYER_PED_ID(), true, true);
}

bool isWeaponUnique(Hash weapon)
{
	return WEAPON::_IS_WEAPON_BOW(weapon) || WEAPON::_IS_WEAPON_KNIFE(weapon) || WEAPON::_IS_WEAPON_LASSO(weapon) || WEAPON::_IS_WEAPON_BINOCULARS(weapon) || WEAPON::_IS_WEAPON_LANTERN(weapon) || WEAPON::_0x49E40483948AF062(weapon) || (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_UNARMED")));
}

bool isWeaponThrowable(Hash weapon)
{
	return (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_THROWN_DYNAMITE")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_THROWN_MOLOTOV")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_THROWN_THROWING_KNIVES")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_THROWN_TOMAHAWK")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_THROWN_TOMAHAWK_ANCIENT")));
}

bool isWeaponNamed(Hash weapon)
{
	return (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_REVOLVER_DOUBLEACTION_GAMBLER")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_REVOLVER_CATTLEMAN_MEXICAN")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_REVOLVER_CATTLEMAN_PIG")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_REVOLVER_DOUBLEACTION_EXOTIC")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_REVOLVER_SCHOFIELD_GOLDEN")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_PISTOL_MAUSER_DRUNK")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_SHOTGUN_DOUBLEBARREL_EXOTIC")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_SNIPERRIFLE_ROLLINGBLOCK_EXOTIC")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_REVOLVER_CATTLEMAN_JOHN")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_REVOLVER_DOUBLEACTION_MICAH")))
		|| (WEAPON::_GET_WEAPON_NAME(weapon) == WEAPON::_GET_WEAPON_NAME(key("WEAPON_REVOLVER_SCHOFIELD_CALLOWAY")));
}

bool isDeadEyeActivated()
{
	return PAD::IS_CONTROL_JUST_PRESSED(0, key("INPUT_SPECIAL_ABILITY")) || PAD::IS_CONTROL_PRESSED(0, key("INPUT_SPECIAL_ABILITY")) || PAD::IS_CONTROL_JUST_PRESSED(0, key("INPUT_SPECIAL_ABILITY_PC")) || PAD::IS_CONTROL_PRESSED(0, key("INPUT_SPECIAL_ABILITY_PC"));
}

int getGameTimer()
{
	return MISC::GET_GAME_TIMER();
}

void main()
{
	Ped playerPed = PLAYER::PLAYER_PED_ID();

	// immersion
	bool emptyHealthFX = GetPrivateProfileInt("IMMERSION", "EMPTY_HEALTH_FX", 0, ".\\SoftCores.ini");
	bool emptyStaminaFX = GetPrivateProfileInt("IMMERSION", "EMPTY_STAMINA_FX", 0, ".\\SoftCores.ini");
	bool emptyDeadEyeFX = GetPrivateProfileInt("IMMERSION", "EMPTY_DEADEYE_FX", 0, ".\\SoftCores.ini");
	bool overpowerFX = GetPrivateProfileInt("IMMERSION", "OVERPOWER_FX", 0, ".\\SoftCores.ini");
	bool duelFX = GetPrivateProfileInt("IMMERSION", "DUEL_FX", 1, ".\\SoftCores.ini");
	bool deadEyeFX = GetPrivateProfileInt("IMMERSION", "DEADEYE_FX", 1, ".\\SoftCores.ini");
	bool eagleEyeFX = GetPrivateProfileInt("IMMERSION", "EAGLEEYE_FX", 1, ".\\SoftCores.ini");
	bool hudWheelFX = GetPrivateProfileInt("IMMERSION", "HUDWHEEL_FX", 0, ".\\SoftCores.ini");
	bool killCamFX = GetPrivateProfileInt("IMMERSION", "KILLCAM_FX", 0, ".\\SoftCores.ini");
	bool pedKillFX = GetPrivateProfileInt("IMMERSION", "PEDKILL_FX", 0, ".\\SoftCores.ini");
	bool deathFX = GetPrivateProfileInt("IMMERSION", "DEATH_FX", 0, ".\\SoftCores.ini");
	bool failFX = GetPrivateProfileInt("IMMERSION", "FAIL_FX", 0, ".\\SoftCores.ini");
	bool choiceFX = GetPrivateProfileInt("IMMERSION", "CHOICE_FX", 0, ".\\SoftCores.ini");
	bool honorLevelFX = GetPrivateProfileInt("IMMERSION", "HONOR_LEVEL_FX", 0, ".\\SoftCores.ini");
	bool pickupsGlow = GetPrivateProfileInt("IMMERSION", "PICKUPS_GLOW", 0, ".\\SoftCores.ini");
	bool objectsGlow = GetPrivateProfileInt("IMMERSION", "OBJECTS_GLOW", 0, ".\\SoftCores.ini");
	bool hostileBlip = GetPrivateProfileInt("IMMERSION", "HOSTILE_BLIP", 0, ".\\SoftCores.ini");

	// timers
	int depletionMs = GetPrivateProfileInt("TIMERS", "CORE_DEPLETION", 120000, ".\\SoftCores.ini");
	int penaltyMs = GetPrivateProfileInt("TIMERS", "CORE_PENALTY", 30000, ".\\SoftCores.ini");
	int aiHealMs = GetPrivateProfileInt("TIMERS", "AI_HEALTH_REGEN", 5000, ".\\SoftCores.ini");
	int aimMs = GetPrivateProfileInt("TIMERS", "AIMING_DEPLETION", 500, ".\\SoftCores.ini");
	int depletionTimer = getGameTimer() + depletionMs;
	int penaltyTimer = getGameTimer() + penaltyMs;
	int aimTimer = getGameTimer() + aimMs;

	// drain modifiers
	int playerHpModifier = GetPrivateProfileInt("DRAIN_MODIFIER", "PLAYER_HEALTH_CORE", 8, ".\\SoftCores.ini");
	int playerStModifier = GetPrivateProfileInt("DRAIN_MODIFIER", "PLAYER_STAMINA_CORE", 12, ".\\SoftCores.ini");
	int playerDeModifier = GetPrivateProfileInt("DRAIN_MODIFIER", "PLAYER_DEADEYE_CORE", 10, ".\\SoftCores.ini");
	int horseHpModifier = GetPrivateProfileInt("DRAIN_MODIFIER", "HORSE_HEALTH_CORE", 12, ".\\SoftCores.ini");
	int horseStModifier = GetPrivateProfileInt("DRAIN_MODIFIER", "HORSE_STAMINA_CORE", 15, ".\\SoftCores.ini");

	// death stuffs
	bool isDead{ false };
	bool deathPenalty{ false };
	bool deAimingPenaltyApplied{ false };
	bool stAimingPenaltyApplied{ false };
	bool weaponLose = GetPrivateProfileInt("DEATH_PENALTY", "WEAPON_LOSE", 1, ".\\SoftCores.ini");

	// lose randomized % of money on death
	int lowestMoneyLose = GetPrivateProfileInt("DEATH_PENALTY", "LOWEST_MONEY_LOSE", 50, ".\\SoftCores.ini");
	int highestMoneyLose = GetPrivateProfileInt("DEATH_PENALTY", "HIGHEST_MONEY_LOSE", 100, ".\\SoftCores.ini");

	int deathTime{};

	int lastHealthCore{};
	int lastStaminaCore{};
	int lastDeadEyeCore{};

	float playerHealthRegen = (float)GetPrivateProfileInt("DRAIN_MODIFIER", "PLAYER_HEALTH_REGEN", 50, ".\\SoftCores.ini") / 100;

	// damage modifier
	float aiDamageHighest = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "HIGHEST_AI_DAMAGE", 500, ".\\SoftCores.ini") / 100;
	float aiDamageHigh = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "HIGH_AI_DAMAGE", 400, ".\\SoftCores.ini") / 100;
	float aiDamageMedium = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "MEDIUM_AI_DAMAGE", 300, ".\\SoftCores.ini") / 100;
	float aiDamageLow = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "LOW_AI_DAMAGE", 200, ".\\SoftCores.ini") / 100;
	float aiDamageLowest = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "LOWEST_AI_DAMAGE", 100, ".\\SoftCores.ini") / 100;

	float playerDamageHighest = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "HIGHEST_PLAYER_DAMAGE", 120, ".\\SoftCores.ini") / 100;
	float playerDamageHigh = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "HIGH_PLAYER_DAMAGE", 100, ".\\SoftCores.ini") / 100;
	float playerDamageMedium = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "MEDIUM_PLAYER_DAMAGE", 80, ".\\SoftCores.ini") / 100;
	float playerDamageLow = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "LOW_PLAYER_DAMAGE", 60, ".\\SoftCores.ini") / 100;
	float playerDamageLowest = (float)GetPrivateProfileInt("DAMAGE_MODIFIER", "LOWEST_PLAYER_DAMAGE", 40, ".\\SoftCores.ini") / 100;

	// ai behaviour
	std::map<Ped, int> aiHealthRegenMap;
	std::map<Ped, int> aiTimeMap;
	std::map<Blip, Ped> aiBlipMap;

	int aiHighestRegen = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "HIGHEST_HEALTH_REGEN", 30, ".\\SoftCores.ini");
	int aiHighRegen = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "HIGH_HEALTH_REGEN", 25, ".\\SoftCores.ini");
	int aiMediumRegen = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "MEDIUM_HEALTH_REGEN", 20, ".\\SoftCores.ini");
	int aiLowRegen = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "LOW_HEALTH_REGEN", 15, ".\\SoftCores.ini");
	int aiLowestRegen = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "LOWEST_HEALTH_REGEN", 10, ".\\SoftCores.ini");

	int aiHighestAccuracy = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "HIGHEST_ACCURACY", 100, ".\\SoftCores.ini");
	int aiHighAccuracy = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "HIGH_ACCURACY", 90, ".\\SoftCores.ini");
	int aiMediumAccuracy = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "MEDIUM_ACCURACY", 80, ".\\SoftCores.ini");
	int aiLowAccuracy = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "LOW_ACCURACY", 70, ".\\SoftCores.ini");
	int aiLowestAccuracy = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "LOWEST_ACCURACY", 60, ".\\SoftCores.ini");

	int aiHighestShootRate = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "HIGHEST_SHOOTRATE", 1000, ".\\SoftCores.ini");
	int aiHighShootRate = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "HIGH_SHOOTRATE", 900, ".\\SoftCores.ini");
	int aiMediumShootRate = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "MEDIUM_SHOOTRATE", 800, ".\\SoftCores.ini");
	int aiLowShootRate = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "LOW_SHOOTRATE", 700, ".\\SoftCores.ini");
	int aiLowestShootRate = GetPrivateProfileInt("AI_COMBAT_MODIFIER", "LOWEST_SHOOTRATE", 600, ".\\SoftCores.ini");

	// mod range
	int pedsRange = GetPrivateProfileInt("MOD_RANGE", "PEDS", 1024, ".\\SoftCores.ini");
	int pickupsRange = GetPrivateProfileInt("MOD_RANGE", "PICKUPS", 1024, ".\\SoftCores.ini");
	int objectsRange = GetPrivateProfileInt("MOD_RANGE", "OBJECTS", 1024, ".\\SoftCores.ini");

	bool isSleeping{ false };
	bool isSleeping2{ false };
	bool isBathing{ false };

	// dead eye no reload usage

	Hash weapon;
	Hash weapon1;

	WEAPON::GET_CURRENT_PED_WEAPON(playerPed, &weapon, false, 0, true);
	WEAPON::GET_CURRENT_PED_WEAPON(playerPed, &weapon1, false, 1, true);

	int ammo{};
	int ammo1{};
	int* currentAmmo = &ammo;
	int* currentAmmo1 = &ammo1;
	int clipSize = WEAPON::GET_MAX_AMMO_IN_CLIP(playerPed, weapon, true);
	int clipSize1 = WEAPON::GET_MAX_AMMO_IN_CLIP(playerPed, weapon1, true);
	WEAPON::GET_AMMO_IN_CLIP(playerPed, currentAmmo, weapon);
	WEAPON::GET_AMMO_IN_CLIP(playerPed, currentAmmo1, weapon);
	int ammoUsed = clipSize - *currentAmmo;
	int ammoUsed1 = clipSize1 - *currentAmmo1;
	int ammoLeft = clipSize - ammoUsed;
	int ammoLeft1 = clipSize - ammoUsed;

	while (true)
	{
		// IMMERSION PART =========================================================================================================================
		if (!emptyHealthFX) GRAPHICS::ANIMPOSTFX_STOP("PlayerRPGEmptyCoreHealth");
		if (!emptyStaminaFX) GRAPHICS::ANIMPOSTFX_STOP("PlayerRPGEmptyCoreStamina");
		if (!emptyDeadEyeFX) GRAPHICS::ANIMPOSTFX_STOP("PlayerRPGEmptyCoreDeadEye");
		if (!overpowerFX) GRAPHICS::ANIMPOSTFX_STOP("PlayerOverpower");
		if (!duelFX) GRAPHICS::ANIMPOSTFX_STOP("Duel");
		if (!deadEyeFX) GRAPHICS::ANIMPOSTFX_STOP("deadeye");
		if (!deadEyeFX) GRAPHICS::ANIMPOSTFX_STOP("DeadEyeEmpty");
		if (!eagleEyeFX) GRAPHICS::ANIMPOSTFX_STOP("EagleEye");
		if (!hudWheelFX) GRAPHICS::ANIMPOSTFX_STOP("WheelHUDIn");
		if (!killCamFX) GRAPHICS::ANIMPOSTFX_STOP("killCam");
		if (!killCamFX) GRAPHICS::ANIMPOSTFX_STOP("KillCamHonorChange");
		if (!pedKillFX) GRAPHICS::ANIMPOSTFX_STOP("PedKill");
		if (!deathFX) GRAPHICS::ANIMPOSTFX_STOP("DeathFailMP01");
		if (!failFX) GRAPHICS::ANIMPOSTFX_STOP("MissionFail01");
		if (!choiceFX) GRAPHICS::ANIMPOSTFX_STOP("PlayerHonorChoiceBad");
		if (!choiceFX) GRAPHICS::ANIMPOSTFX_STOP("PlayerHonorChoiceGood");
		if (!choiceFX) GRAPHICS::ANIMPOSTFX_STOP("MissionChoice");
		if (!honorLevelFX) GRAPHICS::ANIMPOSTFX_STOP("PlayerHonorLevelBad");
		if (!honorLevelFX) GRAPHICS::ANIMPOSTFX_STOP("PlayerHonorLevelGood");
		// END OF IMMERSION PART ==================================================================================================================

		// CORE PART ==============================================================================================================================
		// variables that need constantly updated
		Player playerID = PLAYER::PLAYER_ID();
		Ped playerPed = PLAYER::PLAYER_PED_ID();
		Ped horsePed = PLAYER::_GET_SADDLE_HORSE_FOR_PLAYER(playerID);

		if (ENTITY::DOES_ENTITY_EXIST(playerPed) && ENTITY::DOES_ENTITY_EXIST(horsePed))
		{
			// slowed hp regen if core not overpowered
			playerHealthRegen = (isPlayerCoreOverpowered(Core::Health)) ? 1.0f : playerHealthRegen;

			// every time game timer has pass the timeMs mark, set core drain values accordingly
			if (getGameTimer() > depletionTimer)
			{
				// dynamic drain values according to time of day
				float drainModifier = getTimeOfDayModifier();

				if (!isPlayerIdle() && isPlayerInControl()) // returns TRUE if player is not idle and in control
				{
					// PLAYER Cores
					int playerHpDrain = (isPlayerCoreOverpowered(Core::Health)) ? 0 : bCeil(drainModifier * playerHpModifier);
					int playerStDrain = (isPlayerCoreOverpowered(Core::Stamina)) ? 0 : bCeil(drainModifier * playerStModifier);
					int playerDeDrain = (isPlayerCoreOverpowered(Core::DeadEye)) ? 0 : bCeil(drainModifier * playerDeModifier);

					// HORSE Cores
					int horseHpDrain = (isHorseCoreOverpowered(Core::Health)) ? 0 : bCeil(drainModifier * horseHpModifier);
					int horseStDrain = (isHorseCoreOverpowered(Core::Stamina)) ? 0 : bCeil(drainModifier * horseStModifier);

					// if player on mount, all core drain slower by calculated above else, horse core drain slower
					if (isPlayerOnMount())
					{
						playerHpDrain = bFloor(playerHpDrain * 0.5f);
						playerStDrain = bFloor(playerStDrain * 0.5f);
						playerDeDrain = bFloor(playerDeDrain * 0.5f);
					}
					else
					{
						horseHpDrain = bFloor(horseHpDrain * 0.5f);
						horseStDrain = bFloor(horseStDrain * 0.5f);
					}

					// calculate both PLAYER and HORSE core drain accordingly
					(getPlayerCore(Core::Health) - playerHpDrain <= 0) ? setPlayerCore(Core::Health, 0) : setPlayerCore(Core::Health, getPlayerCore(Core::Health) - playerHpDrain);
					(getPlayerCore(Core::Stamina) - playerStDrain <= 0) ? setPlayerCore(Core::Stamina, 0) : setPlayerCore(Core::Stamina, getPlayerCore(Core::Stamina) - playerStDrain);
					(getPlayerCore(Core::DeadEye) - playerDeDrain <= 0) ? setPlayerCore(Core::DeadEye, 0) : setPlayerCore(Core::DeadEye, getPlayerCore(Core::DeadEye) - playerDeDrain);

					(getHorseCore(Core::Health) - horseHpDrain <= 0) ? setHorseCore(Core::Health, 0) : setHorseCore(Core::Health, getHorseCore(Core::Health) - horseHpDrain);
					(getHorseCore(Core::Stamina) - horseStDrain <= 0) ? setHorseCore(Core::Stamina, 0) : setHorseCore(Core::Stamina, getHorseCore(Core::Stamina) - horseStDrain);
				}
				depletionTimer = getGameTimer() + depletionMs;
			}

			// health outer core penalty for main core being empty
			if (getGameTimer() > penaltyTimer)
			{
				if (!isPlayerIdle() && isPlayerInControl()) // returns TRUE if player is not idle and in control
				{
					int playerHpPercentageDrain = GetPrivateProfileInt("DRAIN_MODIFIER", "PLAYER_HEALTH_PENALTY", 10, ".\\SoftCores.ini") * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0);
					int horseHpPercentageDrain = GetPrivateProfileInt("DRAIN_MODIFIER", "HORSE_HEALTH_PENALTY", 5, ".\\SoftCores.ini") * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(horsePed, 0);

					if (getPlayerCore(Core::Health) <= 0)
					{
						setPlayerHealthRechargeRate(0.0f); // disables health regen completely
						ATTRIBUTE::_SET_CORE_ICON(6);
						(ENTITY::GET_ENTITY_HEALTH(playerPed) - playerHpPercentageDrain <= 0) ? ENTITY::_SET_ENTITY_HEALTH(playerPed, 1, 0) : ENTITY::_SET_ENTITY_HEALTH(playerPed, (ENTITY::GET_ENTITY_HEALTH(playerPed) - playerHpPercentageDrain), 0);
					}

					if (isPlayerOnMount() && getHorseCore(Core::Health) <= 0)
					{
						(ENTITY::GET_ENTITY_HEALTH(horsePed) - horseHpPercentageDrain <= 0) ? ENTITY::_SET_ENTITY_HEALTH(horsePed, 1, 0) : ENTITY::_SET_ENTITY_HEALTH(horsePed, (ENTITY::GET_ENTITY_HEALTH(horsePed) - horseHpPercentageDrain), 0);
					}
				}
				penaltyTimer = getGameTimer() + penaltyMs;
			}

			// player stamina penalty for core being empty, no regen
			(getPlayerCore(Core::Stamina) <= 0) ? PED::SET_PED_RESET_FLAG(playerPed, 139, true) : PED::SET_PED_RESET_FLAG(playerPed, 139, false);

			// DEATH part
			if (isPlayerJustDied() && !isDead) // returns TRUE & TRUE the first time player die
			{
				isDead = true;
				deathPenalty = true;
				deathTime = getGameTimer(); // get time of death
			}

			Hash weaponToDrop;
			if (isDead && deathPenalty && !isPlayerInMission()) // returns TRUE, TRUE & TRUE only if player not in mission so this is applied once immediately after died
			{
				if (weaponLose)
				{
					if (WEAPON::GET_CURRENT_PED_WEAPON(playerPed, &weaponToDrop, false, 0, false))
					{
						// lose current equipped weapon
						if (!isWeaponUnique(weaponToDrop) && !isWeaponNamed(weaponToDrop))
						{
							WEAPON::REMOVE_WEAPON_FROM_PED(playerPed, weaponToDrop, true, NULL);

							int lowestAmmoDrop = GetPrivateProfileInt("DEATH_PENALTY", "LOWEST_AMMO_DROP", 50, ".\\SoftCores.ini") * 100 / WEAPON::GET_AMMO_IN_PED_WEAPON(playerPed, weaponToDrop);
							int highestAmmoDrop = GetPrivateProfileInt("DEATH_PENALTY", "HIGHEST_AMMO_DROP", 100, ".\\SoftCores.ini") * 100 / WEAPON::GET_AMMO_IN_PED_WEAPON(playerPed, weaponToDrop);

							WEAPON::_REMOVE_AMMO_FROM_PED(playerPed, weaponToDrop, MISC::GET_RANDOM_INT_IN_RANGE(lowestAmmoDrop, highestAmmoDrop), 0x2188E0A3);
						}
					}
				}

				// lose specified amount of rank for all cores, not updated on PLAYER info though
				int finalHpRank = getPlayerRank(Core::Health) - GetPrivateProfileInt("DEATH_PENALTY", "HEALTH_RANK", 2, ".\\SoftCores.ini");
				int finalStRank = getPlayerRank(Core::Stamina) - GetPrivateProfileInt("DEATH_PENALTY", "STAMINA_RANK", 2, ".\\SoftCores.ini");
				int finalDeRank = getPlayerRank(Core::DeadEye) - GetPrivateProfileInt("DEATH_PENALTY", "DEADEYE_RANK", 2, ".\\SoftCores.ini");

				setPlayerRank(Core::Health, finalHpRank);
				setPlayerRank(Core::Stamina, finalStRank);
				setPlayerRank(Core::DeadEye, finalDeRank);

				int finalMoney = (MONEY::_MONEY_GET_CASH_BALANCE() * MISC::GET_RANDOM_INT_IN_RANGE(lowestMoneyLose, highestMoneyLose) / 100 <= 0) ? 0 : MONEY::_MONEY_GET_CASH_BALANCE() * MISC::GET_RANDOM_INT_IN_RANGE(lowestMoneyLose, highestMoneyLose) / 100;
				MONEY::_MONEY_DECREMENT_CASH_BALANCE(finalMoney);
				deathPenalty = false; // set back to false immediately so these are only applied once
			}

			if (!isPlayerJustDied() && isDead && !isPlayerInMission()) // returns TRUE, TRUE & TRUE only if player has respawned and isDead true and not in mission so this is applied as long as its true
			{
				if (!isPlayerCoreOverpowered(Core::Health)) setPlayerCore(Core::Health, 0);
				if (!isPlayerCoreOverpowered(Core::Stamina)) setPlayerCore(Core::Stamina, 0);
				if (!isPlayerCoreOverpowered(Core::DeadEye)) setPlayerCore(Core::DeadEye, 0);
				isDead = (getGameTimer() - deathTime >= 15000) ? false : true; // set isDead back to false to stop
			}

			// SLEEP part
			if (!isPlayerInControl())
			{
				if (isPlayerJustSleep() && !isSleeping) // tries hooking sleep via scenario
				{
					lastHealthCore = getPlayerCore(Core::Health);
					lastDeadEyeCore = getPlayerCore(Core::DeadEye);
					isSleeping = true;
				}

				if (isPlayerJustSleep2(getPlayerCore(Core::Health), getPlayerCore(Core::Stamina), getPlayerCore(Core::DeadEye)) && !isSleeping2) // tries hooking sleep via comparison
				{
					lastHealthCore = getPlayerCore(Core::Health);
					lastDeadEyeCore = getPlayerCore(Core::DeadEye);
					isSleeping2 = true;
				}
			}

			if ((isSleeping || isSleeping2) && !PED::IS_PED_USING_ANY_SCENARIO(playerPed)) // restore only stamina cores when player sleep
			{
				setPlayerCore(Core::Health, lastHealthCore);
				setPlayerCore(Core::DeadEye, lastDeadEyeCore);
				isSleeping = false;
				isSleeping2 = false;
			}

			// BATH part
			if (isPlayerBathing() && !isBathing)
			{
				lastHealthCore = getPlayerCore(Core::Health);
				lastStaminaCore = getPlayerCore(Core::Stamina);
				isBathing = true;
			}

			if (isBathing) // bathing only restores deadeye
			{
				setPlayerCore(Core::Health, lastHealthCore);
				setPlayerCore(Core::Stamina, lastStaminaCore);

				isBathing = (TASK::IS_PED_WALKING(playerPed) || TASK::IS_PED_RUNNING(playerPed) || TASK::IS_PED_SPRINTING(playerPed)) ? false : true;
			}

			/*int f1{ VK_F1 };
			if (IsKeyJustUp(f1))
			{
				setPlayerCore(Core::Health, 0);
				setPlayerCore(Core::Stamina, 0);
				setPlayerCore(Core::DeadEye, 0);
			}*/
		}
		// END OF CORE PART =====================================================================================================================

		// START DAMAGE AND NPC MODIFIER ========================================================================================================
		if (isPlayerInCombat()) // do these stuffs only in combat for performance purposes
		{
			(isPlayerInCover() || isPlayerOnMount()) ? setPlayerHealthRechargeRate(playerHealthRegen) : setPlayerHealthRechargeRate(0.0f);

			// set damage modifier base on player health, basically the more health you got, the higher damager you take, the lower damage you give
			if ((ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) > 80 && (ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) < 100)
			{
				setAIDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageHigh, aiDamageHighest) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageHigh, aiDamageHighest));
				setPlayerDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageLowest, playerDamageLow) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageLowest, playerDamageLow));
			}
			else if ((ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) > 60 && (ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) < 80)
			{
				setAIDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageMedium, aiDamageHigh) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageMedium, aiDamageHigh));
				setPlayerDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageLow, playerDamageMedium) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageLow, playerDamageMedium));
			}
			else if ((ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) > 40 && (ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) < 60)
			{
				setAIDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageLow, aiDamageMedium) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageLow, aiDamageMedium));
				setPlayerDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageMedium, playerDamageHigh) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageMedium, playerDamageHigh));
			}
			else if ((ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) > 20 && (ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) < 40)
			{
				setAIDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageLowest, aiDamageLow) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageLowest, aiDamageLow));
				setPlayerDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageHigh, playerDamageHighest) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageHigh, playerDamageHighest));
			}
			else if ((ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) > 0 && (ENTITY::GET_ENTITY_HEALTH(playerPed) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(playerPed, 0)) < 20)
			{
				setAIDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageLowest, aiDamageHighest) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(aiDamageLowest, aiDamageHighest));
				setPlayerDamageModifer(MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageLowest, playerDamageHighest) * 0.5f, MISC::GET_RANDOM_FLOAT_IN_RANGE(playerDamageLowest, playerDamageHighest));
			}

			// ped related stuffs
			Ped peds[1024];
			stringstream text;

			// get all peds within range and do stuffs
			int count = worldGetAllPeds(peds, pedsRange);

			for (int i = 0; i < count; i++)
			{
				if (aiHealthRegenMap.find(peds[i]) == aiHealthRegenMap.end()) aiHealthRegenMap[peds[i]] = 0;
				if (aiTimeMap.find(peds[i]) == aiTimeMap.end()) aiTimeMap[peds[i]] = 0;
				if (aiBlipMap.find(peds[i]) == aiBlipMap.end()) aiBlipMap[peds[i]] = 0;
			}

			for (int i = 0; i < count; i++) // peds BEHAVIOUR part
			{
				if (peds[i] != playerPed && PED::IS_PED_HUMAN(peds[i]) && !ENTITY::IS_ENTITY_DEAD(peds[i]))
				{
					if ((ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) > 80 && (ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) < 100)
					{
						PED::SET_PED_ACCURACY(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiHighAccuracy, aiHighestAccuracy)); // accuracy
						PED::SET_PED_CONFIG_FLAG(playerPed, 263, false); // disable playerPed headshot immunity
						PED::SET_PED_COMBAT_MOVEMENT(peds[i], 2); // offensive
						PED::SET_PED_SHOOT_RATE(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiHighShootRate, aiHighestShootRate)); // shoot rate
						aiHealthRegenMap[peds[i]] = (MISC::GET_RANDOM_INT_IN_RANGE(aiLowestRegen, aiLowRegen) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0));
					}
					else if ((ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) > 60 && (ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) < 80)
					{
						PED::SET_PED_ACCURACY(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiMediumAccuracy, aiHighAccuracy));
						PED::SET_PED_CONFIG_FLAG(playerPed, 263, false);
						PED::SET_PED_COMBAT_MOVEMENT(peds[i], 2); // offensive
						PED::SET_PED_SHOOT_RATE(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiMediumShootRate, aiHighShootRate));
						aiHealthRegenMap[peds[i]] = (MISC::GET_RANDOM_INT_IN_RANGE(aiLowRegen, aiMediumRegen) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0));
					}
					else if ((ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) > 40 && (ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) < 60)
					{
						PED::SET_PED_ACCURACY(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiLowAccuracy, aiMediumAccuracy));
						PED::SET_PED_CONFIG_FLAG(playerPed, 263, false);
						PED::SET_PED_COMBAT_MOVEMENT(peds[i], 1); // defensive
						PED::SET_PED_SHOOT_RATE(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiLowShootRate, aiMediumShootRate));
						aiHealthRegenMap[peds[i]] = (MISC::GET_RANDOM_INT_IN_RANGE(aiMediumRegen, aiHighRegen) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0));
					}
					else if ((ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) > 20 && (ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) < 40)
					{
						PED::SET_PED_ACCURACY(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiLowestAccuracy, aiLowAccuracy));
						PED::SET_PED_SHOOT_RATE(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiLowestShootRate, aiLowShootRate));
						PED::SET_PED_COMBAT_MOVEMENT(peds[i], 3); // suicidal
						aiHealthRegenMap[peds[i]] = (MISC::GET_RANDOM_INT_IN_RANGE(aiHighRegen, aiHighestRegen) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0));
					}
					else if ((ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) > 0 && (ENTITY::GET_ENTITY_HEALTH(peds[i]) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)) < 20)
					{
						PED::SET_PED_ACCURACY(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiLowestAccuracy, aiHighestAccuracy));
						PED::SET_PED_SHOOT_RATE(peds[i], MISC::GET_RANDOM_INT_IN_RANGE(aiLowestShootRate, aiHighestShootRate));
						PED::SET_PED_COMBAT_MOVEMENT(peds[i], 3); // suicidal
						aiHealthRegenMap[peds[i]] = (MISC::GET_RANDOM_INT_IN_RANGE(aiLowestRegen, aiHighestRegen) * 100 / ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0));
					}

					if (ENTITY::HAS_ENTITY_BEEN_DAMAGED_BY_ANY_PED(peds[i]) || ENTITY::HAS_ENTITY_BEEN_DAMAGED_BY_ANY_OBJECT(peds[i]))
					{
						aiTimeMap[peds[i]] = getGameTimer() + aiHealMs; // time ai is damaged

						if (getGameTimer() - aiTimeMap[peds[i]] >= aiHealMs) // current game time minus time ai is damaged more than aiHealMs
						{
							if (PED::IS_PED_IN_MELEE_COMBAT(peds[i])) // melee combat check so they can actually be taken down, still heal tho
							{
								if ((ENTITY::GET_ENTITY_HEALTH(peds[i]) + (aiHealthRegenMap[peds[i]] * 0.2f)) < ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0))
									ENTITY::_SET_ENTITY_HEALTH(peds[i], bFloor(ENTITY::GET_ENTITY_HEALTH(peds[i]) + (aiHealthRegenMap[peds[i]] * 0.2f)), 0); // slowed regen
								else
									ENTITY::_SET_ENTITY_HEALTH(peds[i], (ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)), 0); // set max health
							}
							else
							{
								if ((ENTITY::GET_ENTITY_HEALTH(peds[i]) + aiHealthRegenMap[peds[i]]) < ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0))
									ENTITY::_SET_ENTITY_HEALTH(peds[i], (ENTITY::GET_ENTITY_HEALTH(peds[i]) + aiHealthRegenMap[peds[i]]), 0); // normal regen
								else
								{
									ENTITY::_SET_ENTITY_HEALTH(peds[i], (ENTITY::GET_ENTITY_MAX_HEALTH(peds[i], 0)), 0); // set max health
									PED::CLEAR_PED_BLOOD_DAMAGE(peds[i]);
									for (int j = 0; j < 10; j++)
									{
										PED::_CLEAR_PED_BLOOD_DAMAGE_FACIAL(peds[i], j);
									}
								}
							}
						}
					}

					// START NO HOSTILE AI BLIP ============================================================================================================
					if (!hostileBlip)
					{
						Vector3 playerPos = ENTITY::GET_ENTITY_COORDS(playerPed, true, true);
						if (PED::IS_ANY_HOSTILE_PED_NEAR_POINT(peds[i], playerPos.x, playerPos.y, playerPos.z, 1000.0f) || PED::IS_PED_DEFENSIVE_AREA_ACTIVE(peds[i], false) || PED::IS_PED_DEFENSIVE_AREA_ACTIVE(peds[i], true))
						{
							aiBlipMap[peds[i]] = MAP::GET_BLIP_FROM_ENTITY(peds[i]);

							if (MAP::IS_BLIP_ON_MINIMAP(aiBlipMap[peds[i]]) || MAP::DOES_BLIP_EXIST(aiBlipMap[peds[i]]))
								MAP::_BLIP_SET_MODIFIER(aiBlipMap[peds[i]], 0xB946AEF0);
						}
					}
					// END NO HOSTILE AI BLIP ==============================================================================================================
				}
			}
		}
		// END DAMAGE AND NPC MODIFIER ==========================================================================================================

		// START DISABLE GLOW PART ==============================================================================================================
		if (!isLoadingScreenActive())
		{
			if (!pickupsGlow)
			{
				Pickup pickups[1024];
				int pCount = worldGetAllPickups(pickups, pickupsRange); // disabling weapon pickups glow
				for (int i = 0; i < pCount; i++)
				{
					GRAPHICS::_0x50C14328119E1DD1(pickups[i], true); // yep this native below directly disables the glow
				}
			}

			if (!objectsGlow)
			{
				Object objects[1024];
				int oCount = worldGetAllObjects(objects, objectsRange); // disabling lootable object such as apple, carrot and such
				for (int i = 0; i < oCount; i++)
				{
					GRAPHICS::_0x50C14328119E1DD1(objects[i], true);
				}
			}
		}
		// END DISABLE GLOW PART ================================================================================================================

		// START OF DEADEYE NO RELOAD PART ======================================================================================================
		// to get player all sorta particular details of weaponary in both hands
		if (WEAPON::GET_CURRENT_PED_WEAPON(playerPed, &weapon, false, 0, true))
		{
			clipSize = WEAPON::GET_MAX_AMMO_IN_CLIP(playerPed, weapon, true);
			WEAPON::GET_AMMO_IN_CLIP(playerPed, currentAmmo, weapon);
		}

		if (WEAPON::GET_CURRENT_PED_WEAPON(playerPed, &weapon1, false, 1, true))
		{
			clipSize1 = WEAPON::GET_MAX_AMMO_IN_CLIP(playerPed, weapon1, true);
			WEAPON::GET_AMMO_IN_CLIP(playerPed, currentAmmo1, weapon1);
		}

		// updates the value ammoUsed everytime player shoots, switched weapon or reloading
		if (PED::IS_PED_SHOOTING(playerPed) || PED::GET_PED_RESET_FLAG(playerPed, 332) || PED::IS_PED_RELOADING(playerPed))
		{
			ammoUsed = clipSize - *currentAmmo;
			ammoUsed1 = clipSize1 - *currentAmmo1;
			ammoLeft = clipSize - ammoUsed;
			ammoLeft1 = clipSize1 - ammoUsed1;
		}

		// hook deadEye and sets ammo accordingly
		if (isDeadEyeActivated() && !TASK::_IS_PED_DUELLING(playerPed))
		{
			WEAPON::SET_AMMO_IN_CLIP(playerPed, weapon, ammoLeft);
			WEAPON::SET_AMMO_IN_CLIP(playerPed, weapon1, ammoLeft1);
		}
		// END OF DEADEYE NO RELOAD PART ======================================================================================================

		// START AIMING PENALTY ==============================================================================================================
		if (getGameTimer() > aimTimer)
		{
			int stAimingPenalty = GetPrivateProfileInt("DRAIN_MODIFIER", "STAMINA_AIMING_PENALTY", 5, ".\\SoftCores.ini") * getMaxPlayerPoint(Core::Stamina) / 100;
			int deAimingPenalty = GetPrivateProfileInt("DRAIN_MODIFIER", "DEADEYE_AIMING_PENALTY", 10, ".\\SoftCores.ini") * getMaxPlayerPoint(Core::DeadEye) / 100;

			stAimingPenalty = (isPlayerPointOverpowered(Core::Stamina)) ? 0: stAimingPenalty;
			deAimingPenalty = (isPlayerPointOverpowered(Core::DeadEye)) ? 0: deAimingPenalty;

			if (PLAYER::IS_PLAYER_FREE_AIMING(playerID) && WEAPON::GET_CURRENT_PED_WEAPON(playerPed, &weapon, false, 0, true))
			{
				if (!isWeaponUnique(weapon) && !isWeaponThrowable(weapon))
				{
					/*stringstream text;
					text << "st: " << stAimingPenalty << " de:" << deAimingPenalty;
					showSubtitle(text.str().c_str());*/

					PED::SET_PED_RESET_FLAG(playerPed, 139, true);

					(getPlayerPoint(Core::Stamina) - stAimingPenalty > 0) ? setPlayerPoint(Core::Stamina, getPlayerPoint(Core::Stamina) - stAimingPenalty) : setPlayerPoint(Core::Stamina, -1);
					(getPlayerPoint(Core::DeadEye) - deAimingPenalty > 0) ? setPlayerPoint(Core::DeadEye, getPlayerPoint(Core::DeadEye) - deAimingPenalty) : setPlayerPoint(Core::DeadEye, -1);

					if (getPlayerPoint(Core::Stamina) <= 0 && !isPlayerCoreOverpowered(Core::Stamina))
					{
						setPlayerCore(Core::Stamina, getPlayerCore(Core::Stamina) - 1);
					}

					if (getPlayerPoint(Core::DeadEye) <= 0 && !isPlayerCoreOverpowered(Core::DeadEye))
					{
						setPlayerCore(Core::DeadEye, getPlayerCore(Core::DeadEye) - 1);
					}
				}
			}
			else
			{
				(getPlayerPoint(Core::Stamina) + stAimingPenalty < getMaxPlayerPoint(Core::Stamina)) ? setPlayerPoint(Core::Stamina, getPlayerPoint(Core::Stamina) + stAimingPenalty) : setPlayerPoint(Core::Stamina, getMaxPlayerPoint(Core::Stamina));
				(getPlayerPoint(Core::DeadEye) + deAimingPenalty < getMaxPlayerPoint(Core::DeadEye)) ? setPlayerPoint(Core::DeadEye, getPlayerPoint(Core::DeadEye) + deAimingPenalty) : setPlayerPoint(Core::DeadEye, getMaxPlayerPoint(Core::DeadEye));

				PED::SET_PED_RESET_FLAG(playerPed, 139, false);
			}
			aimTimer = getGameTimer() + aimMs;
		}

		// END AIMING PENALTY ==================================================================================================================

		WAIT(0);
	}
}

void ScriptMain()
{
	srand(static_cast<int>(GetTickCount64()));
	main();
}
