#include "script.h"
#include "keyboard.h"

#include <sstream>
#include <fstream>

using namespace std;

Hash key(const char* key)
{
	return MISC::GET_HASH_KEY(key);
}

void showSubtitle(const char* text)
{
	UILOG::_UILOG_SET_CACHED_OBJECTIVE((const char*)MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", text)); //
	UILOG::_UILOG_PRINT_CACHED_OBJECTIVE(); // _UILOG_PRINT_CACHED_OBJECTIVE
	UILOG::_UILOG_CLEAR_CACHED_OBJECTIVE(); //
}

// prompt functions
void togglePrompt(int prompt, bool visible, bool disable)
{
	HUD::_UIPROMPT_SET_VISIBLE(prompt, visible);
	HUD::_UIPROMPT_SET_ENABLED(prompt, disable);
}

float distanceBetween(Vector3 a, Vector3 b)
{
	return BUILTIN::VDIST(a.x, a.y, a.z, b.x, b.y, b.z);
}

bool isPlayerPursued()
{
	return !PLAYER::GET_PLAYER_WANTED_LEVEL(PLAYER::PLAYER_ID()) ? false : true;
}

bool isPlayerInCombat()
{
	return PED::IS_PED_IN_COMBAT(PLAYER::PLAYER_PED_ID(), NULL);
}

bool isPlayerInMission()
{
	return MISC::GET_MISSION_FLAG() || MISC::IS_MINIGAME_IN_PROGRESS();
}

bool isPlayerUsingVehicle()
{
	Ped playerPed = PLAYER::PLAYER_PED_ID();
	return (PED::IS_PED_IN_ANY_VEHICLE(playerPed, true) || PED::IS_PED_SITTING_IN_ANY_VEHICLE(playerPed)) && !PED::IS_PED_ON_VEHICLE(playerPed, true) && !PED::IS_PED_ON_FOOT(playerPed);
}

bool isPlayerOnFootOnVehicle()
{
	Ped playerPed = PLAYER::PLAYER_PED_ID();
	return PED::IS_PED_ON_VEHICLE(playerPed, true) && PED::IS_PED_ON_FOOT(playerPed);
}

bool isPlayerCarrying()
{
	return PED::_IS_PED_CARRYING(PLAYER::PLAYER_PED_ID());
}

bool isVehicleStopped(Vehicle vehicle)
{
	return VEHICLE::IS_VEHICLE_STOPPED(vehicle);
}

bool isCinematicCamActive()
{
	return CAM::IS_CINEMATIC_CAM_RENDERING();
}

bool isPlayerReadyForCutscene()
{
	return PLAYER::IS_PLAYER_READY_FOR_CUTSCENE(PLAYER::PLAYER_ID());
}

bool canManageVehicleOwnership(Vehicle vehicle)
{
	return !isPlayerInCombat() && !isPlayerPursued() && !isPlayerInMission() && isPlayerUsingVehicle() && isVehicleStopped(vehicle) && !isCinematicCamActive() && isPlayerReadyForCutscene();
}

bool isThisModelAWagon(Hash hash)
{
	return !PED::_IS_THIS_MODEL_A_HORSE(hash) && !VEHICLE::IS_THIS_MODEL_A_TRAIN(hash) && !VEHICLE::IS_THIS_MODEL_A_BOAT(hash);
}

bool isLeadingHorse()
{
	return PAD::IS_CONTROL_PRESSED(0, MISC::GET_HASH_KEY("INPUT_INTERACT_LEAD_ANIMAL"));
}

bool isStopLeadingHorse()
{
	return PAD::IS_CONTROL_PRESSED(0, MISC::GET_HASH_KEY("INPUT_STOP_LEADING_ANIMAL")) || PAD::IS_CONTROL_PRESSED(0, MISC::GET_HASH_KEY("INPUT_INTERACT_HORSE_FEED")) || PAD::IS_CONTROL_PRESSED(0, MISC::GET_HASH_KEY("INPUT_HORSE_COMMAND_FLEE")) || PAD::IS_CONTROL_PRESSED(0, MISC::GET_HASH_KEY("INPUT_INTERACT_HORSE_BRUSH"));
}

void playOnEvent(int event)
{
	Ped playerPed = PLAYER::PLAYER_PED_ID();
	
	struct ScriptedSpeechParams
	{
		const char* speechName;
		const char* speechParam;
		alignas(8) int v3;
		alignas(8) Hash v4;
		alignas(8) Entity entity;
		alignas(8) BOOL v6;
		alignas(8) int v7;
		alignas(8) int v8;
	};

	ScriptedSpeechParams params{ "SPURS_WAGON_FROM_STOP_URGENT", "ARTHUR", -1, 0x67F3AB43, -1, true, -1, -1 };

	AUDIO::_PLAY_AMBIENT_SPEECH1(playerPed, (Any*)&params);
}

void disableOtherUIPrompts()
{
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(10);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(11);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(9);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(8);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(7);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(6);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(5);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(4);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(3);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(2);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(1);
	HUD::_UIPROMPT_DISABLE_PROMPT_TYPE_THIS_FRAME(0);
}

void main()
{
	int takeOwnershipPrompt = HUD::_UIPROMPT_REGISTER_BEGIN();
	HUD::_UIPROMPT_SET_CONTROL_ACTION(takeOwnershipPrompt, key("INPUT_CONTEXT_X"));
	HUD::_UIPROMPT_SET_TEXT(takeOwnershipPrompt, MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", "Take Ownership"));
	HUD::_UIPROMPT_SET_HOLD_MODE(takeOwnershipPrompt, 1);
	HUD::_UIPROMPT_REGISTER_END(takeOwnershipPrompt);
	togglePrompt(takeOwnershipPrompt, false, false);

	int removeOwnershipPrompt = HUD::_UIPROMPT_REGISTER_BEGIN();
	HUD::_UIPROMPT_SET_CONTROL_ACTION(removeOwnershipPrompt, key("INPUT_CONTEXT_B"));
	HUD::_UIPROMPT_SET_TEXT(removeOwnershipPrompt, MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", "Remove Ownership"));
	HUD::_UIPROMPT_SET_HOLD_MODE(removeOwnershipPrompt, 1);
	HUD::_UIPROMPT_REGISTER_END(removeOwnershipPrompt);
	togglePrompt(removeOwnershipPrompt, false, false);

	int closeTrunkPrompt = HUD::_UIPROMPT_REGISTER_BEGIN();
	HUD::_UIPROMPT_SET_CONTROL_ACTION(closeTrunkPrompt, key("INPUT_CONTEXT_B"));
	HUD::_UIPROMPT_SET_TEXT(closeTrunkPrompt, MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", "Close Trunk"));
	HUD::_UIPROMPT_SET_STANDARD_MODE(closeTrunkPrompt, 1);
	HUD::_UIPROMPT_REGISTER_END(closeTrunkPrompt);
	togglePrompt(closeTrunkPrompt, false, false);

	int openTrunkPrompt = HUD::_UIPROMPT_REGISTER_BEGIN();
	HUD::_UIPROMPT_SET_CONTROL_ACTION(openTrunkPrompt, key("INPUT_CONTEXT_Y"));
	HUD::_UIPROMPT_SET_TEXT(openTrunkPrompt, MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", "Open Trunk"));
	HUD::_UIPROMPT_SET_STANDARD_MODE(openTrunkPrompt, 1);
	HUD::_UIPROMPT_REGISTER_END(openTrunkPrompt);
	togglePrompt(openTrunkPrompt, false, false);

	int attachHorsePrompt = HUD::_UIPROMPT_REGISTER_BEGIN();
	HUD::_UIPROMPT_SET_CONTROL_ACTION(attachHorsePrompt, key("INPUT_SPRINT"));
	HUD::_UIPROMPT_SET_TEXT(attachHorsePrompt, MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", "Attach Horse"));
	HUD::_UIPROMPT_SET_STANDARD_MODE(attachHorsePrompt, 1);
	HUD::_UIPROMPT_REGISTER_END(attachHorsePrompt);
	togglePrompt(attachHorsePrompt, false, false);

	int resetHorsePrompt = HUD::_UIPROMPT_REGISTER_BEGIN();
	HUD::_UIPROMPT_SET_CONTROL_ACTION(resetHorsePrompt, key("INPUT_SPRINT"));
	HUD::_UIPROMPT_SET_TEXT(resetHorsePrompt, MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", "Reset Attached Horse"));
	HUD::_UIPROMPT_SET_HOLD_MODE(resetHorsePrompt, 1);
	HUD::_UIPROMPT_REGISTER_END(resetHorsePrompt);
	togglePrompt(resetHorsePrompt, false, false);

	// main vehicle variables to be loaded inside StashedWagon.dat file
	Hash myVehicleHash{};
	float myVehiclePosX{}, myVehiclePosY{}, myVehiclePosZ{}, myVehicleHeading{};
	bool isMyVehicleInfoLoaded{};
	bool isMyVehicleStashed{};
	bool isMyVehicleCreated{ false };
	Blip myVehicleBlip{};
	Vehicle myVehicle{};

	Blip currentVehicleBlip{};
	bool isPlayerExitedVehicle{};
	bool isPlayerEnteredVehicle{};
	bool vehicleTrunkShut{};

	bool isHorseAttached{};
	bool canShowAttachPrompt{};
	int horseAttached{ 0 };

	while (true)
	{
		Player playerID = PLAYER::PLAYER_ID();
		Ped playerPed = PLAYER::PLAYER_PED_ID();

		// variables for various saving vehicle information
		bool isWagonUsed{};
		bool isVehicleOwnerShipTaken{};

		Vehicle currentVehicle{};
		Hash currentVehicleHash{};
		Vector3 currentVehiclePos{};
		float currentVehicleHeading{};

		// START OWNERSHIP PART ====================================================================================================================================================
		if (!isMyVehicleInfoLoaded) // returns TRUE the first time game load
		{
			// loading variables
			ifstream LoadFile;
			LoadFile.open("StashedWagon.dat", std::ofstream::in);
			LoadFile >> isMyVehicleStashed >> myVehicle >> myVehicleHash >> myVehiclePosX >> myVehiclePosY >> myVehiclePosZ >> myVehicleHeading;
			LoadFile.close();
			isMyVehicleInfoLoaded = true; // no longer attempt to load variables from StashedWagon.dat after load
		}

		if (isPlayerUsingVehicle() && !isWagonUsed)
		{
			currentVehicle = PED::GET_VEHICLE_PED_IS_USING(playerPed); // update vehicle information
			currentVehicleHash = ENTITY::GET_ENTITY_MODEL(currentVehicle);
			isWagonUsed = isThisModelAWagon(currentVehicleHash); // so normal horse, train and boat model won't return true
		}

		// check for vehicle hash previously existed in StashedWagon.dat first
		isVehicleOwnerShipTaken = (currentVehicleHash == myVehicleHash) ? true: false;

		if (isVehicleOwnerShipTaken)
		{
			// show Remove Ownership Promp if all conditions are true
			(canManageVehicleOwnership(currentVehicle)) ? togglePrompt(removeOwnershipPrompt, true, true) : togglePrompt(removeOwnershipPrompt, false, false);

			// Remove Ownership prompt completion
			if (HUD::_UIPROMPT_HAS_HOLD_MODE_COMPLETED(removeOwnershipPrompt))
			{
				togglePrompt(removeOwnershipPrompt, false, false);
				ofstream SaveFile;
				SaveFile.open("StashedWagon.dat", std::ofstream::trunc);
				SaveFile << 0 << " " << 0 << " " << 0 << " " << 0 << " " << 0 << " " << 0 << " " << 0; // empty the variables
				SaveFile.close();
				isMyVehicleInfoLoaded = false; // loading variables again to update values inside StashedWagon.dat to latest one
			}

			if (PAD::IS_CONTROL_JUST_PRESSED(0, key("INPUT_VEH_EXIT")) || PAD::IS_CONTROL_PRESSED(0, key("INPUT_VEH_EXIT")) && !PED::IS_PED_GETTING_INTO_A_VEHICLE(playerPed) && !isPlayerExitedVehicle) // returns TRUE and TRUE if ped pressed E and not getting into vehicle
				isPlayerExitedVehicle = true;
			else if (PAD::IS_CONTROL_JUST_PRESSED(0, key("INPUT_VEH_TRAVERSAL")) || PAD::IS_CONTROL_PRESSED(0, key("INPUT_VEH_TRAVERSAL")) && PED::IS_PED_GETTING_INTO_A_VEHICLE(playerPed) && !isPlayerExitedVehicle)
				isPlayerExitedVehicle = true;
			else if(PED::IS_PED_GETTING_INTO_A_VEHICLE(playerPed))
				isPlayerEnteredVehicle = true;

			if (isPlayerExitedVehicle && isMyVehicleStashed) // only take place if vehicle exited, vehicle initially saved
			{
				currentVehiclePos = ENTITY::GET_ENTITY_COORDS(currentVehicle, true, true);
				currentVehicleHeading = ENTITY::GET_ENTITY_HEADING(currentVehicle);
				// compare the info of current and saved on StashedWagon.dat if any is different then different then update accordingly to save latest position of wagon
				if (currentVehiclePos.x != myVehiclePosX || currentVehiclePos.y != myVehiclePosY || currentVehiclePos.z != myVehiclePosZ || currentVehicleHeading != myVehicleHeading)
				{
					bool isVehicleSaved = 1; // states that the wagon is saved
					ofstream SaveFile; // saving variables
					SaveFile.open("StashedWagon.dat", std::ofstream::trunc);
					SaveFile << isVehicleSaved << " " << currentVehicle << " " << currentVehicleHash << " " << currentVehiclePos.x << " " << currentVehiclePos.y << " " << currentVehiclePos.z << " " << currentVehicleHeading; // saves the variables
					SaveFile.close();
					isMyVehicleInfoLoaded = false; // reload info from StashedWagon.dat
				}

				if (!MAP::DOES_BLIP_EXIST(currentVehicleBlip)) // current blip information for current vehicle
				{
					const char* blipString = MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", "Stashed Wagon");
					currentVehicleBlip = MAP::_BLIP_ADD_FOR_ENTITY(1664425300, currentVehicle);
					MAP::_SET_BLIP_NAME_FROM_PLAYER_STRING(currentVehicleBlip, blipString);
					MAP::SET_BLIP_SPRITE(currentVehicleBlip, key("BLIP_AMBIENT_COACH"), true);
					MAP::SET_BLIP_SCALE(currentVehicleBlip, 0.2f);
				}

				ENTITY::SET_ENTITY_AS_MISSION_ENTITY(currentVehicle, true, true); // set as mission entity for persistency
				isPlayerExitedVehicle = false;
			}

			if (MAP::DOES_BLIP_EXIST(currentVehicleBlip) && isPlayerEnteredVehicle)
			{
				ENTITY::SET_ENTITY_AS_MISSION_ENTITY(currentVehicle, false, false);
				MAP::REMOVE_BLIP(&currentVehicleBlip);
				isPlayerEnteredVehicle = false;
			}
		}
		else
		{
			// show Take Ownership Prompt if all conditions are true
			(canManageVehicleOwnership(currentVehicle) && isWagonUsed) ? togglePrompt(takeOwnershipPrompt, true, true) : togglePrompt(takeOwnershipPrompt, false, false); 
			
			// Take Ownership Prompt completion Action
			if (HUD::_UIPROMPT_HAS_HOLD_MODE_COMPLETED(takeOwnershipPrompt))
			{
				togglePrompt(takeOwnershipPrompt, false, false);
				if (isMyVehicleStashed) // to remove previously owned wagon accordingly
				{
					ENTITY::SET_ENTITY_AS_MISSION_ENTITY(myVehicle, false, false);
					ENTITY::SET_ENTITY_AS_NO_LONGER_NEEDED(&myVehicle);
					if(MAP::DOES_BLIP_EXIST(currentVehicleBlip))
						MAP::REMOVE_BLIP(&currentVehicleBlip);
				}

				VEHICLE::_SET_PED_OWNS_VEHICLE(playerPed, currentVehicle);
				VEHICLE::SET_VEHICLE_STRONG(currentVehicle, true);

				currentVehiclePos = ENTITY::GET_ENTITY_COORDS(currentVehicle, true, true);
				currentVehicleHeading = ENTITY::GET_ENTITY_HEADING(currentVehicle);
				bool isVehicleStashed = 1;
				ofstream SaveFile;
				SaveFile.open("StashedWagon.dat", std::ofstream::trunc);
				SaveFile << isVehicleStashed << " " << currentVehicle << " " << currentVehicleHash << " " << currentVehiclePos.x << " " << currentVehiclePos.y << " " << currentVehiclePos.z << " " << currentVehicleHeading; // saves the variables
				SaveFile.close();
				isMyVehicleInfoLoaded = false; // loading variables again to update values inside StashedWagon.dat to latest one
			}
		}
		// END OWNERSHIP PART ======================================================================================================================================================

		// START SPAWN VEHICLE PART ================================================================================================================================================
		if(VEHICLE::IS_ANY_VEHICLE_NEAR_POINT(myVehiclePosX, myVehiclePosY, myVehiclePosZ, 30.0f))
			isMyVehicleCreated = true;

		if (isMyVehicleStashed && !isMyVehicleCreated) // create a vehicle copy from the one saved as a fire n forget, will only done once whenever loads
		{
			if (STREAMING::IS_MODEL_IN_CDIMAGE(myVehicleHash) && STREAMING::IS_MODEL_VALID(myVehicleHash)) // creation of saved vehicle from StashedWagon.dat
			{
				STREAMING::REQUEST_MODEL(myVehicleHash, true);
				while (!STREAMING::HAS_MODEL_LOADED(myVehicleHash)) WAIT(0);				
				Vehicle vehicleSpawn = VEHICLE::CREATE_VEHICLE(myVehicleHash, myVehiclePosX, myVehiclePosY, myVehiclePosZ, myVehicleHeading, true, true, true, false);
				NETWORK::NETWORK_REQUEST_CONTROL_OF_ENTITY(vehicleSpawn);
				VEHICLE::SET_VEHICLE_ON_GROUND_PROPERLY(vehicleSpawn, true);
				VEHICLE::_SET_PED_OWNS_VEHICLE(playerPed, vehicleSpawn);
				VEHICLE::SET_VEHICLE_STRONG(vehicleSpawn, true);
				DECORATOR::DECOR_SET_INT(vehicleSpawn, "MPBitset", true);
				DECORATOR::DECOR_SET_INT(vehicleSpawn, "wagon_block_honor", true);
				auto networkId = NETWORK::VEH_TO_NET(vehicleSpawn);
				if (NETWORK::NETWORK_GET_ENTITY_IS_NETWORKED(vehicleSpawn))
					NETWORK::SET_NETWORK_ID_EXISTS_ON_ALL_MACHINES(networkId, true);
				STREAMING::SET_MODEL_AS_NO_LONGER_NEEDED(myVehicleHash);
				myVehicle = vehicleSpawn;
			}

			if (!MAP::DOES_BLIP_EXIST(myVehicleBlip)) // saved vehicle blip information
			{
				const char* blipString = MISC::_CREATE_VAR_STRING(10, "LITERAL_STRING", "Stashed Wagon");
				myVehicleBlip = MAP::_BLIP_ADD_FOR_ENTITY(1664425300, myVehicle);
				MAP::_SET_BLIP_NAME_FROM_PLAYER_STRING(myVehicleBlip, blipString);
				MAP::SET_BLIP_SPRITE(myVehicleBlip, key("BLIP_AMBIENT_COACH"), true);
				MAP::SET_BLIP_SCALE(myVehicleBlip, 0.2f);
			}
			isMyVehicleCreated = true;
		}

		if (MAP::DOES_BLIP_EXIST(myVehicleBlip) && PED::IS_PED_GETTING_INTO_A_VEHICLE(playerPed) && (PED::GET_VEHICLE_PED_IS_ENTERING(playerPed) == myVehicle))
		{
			MAP::REMOVE_BLIP(&myVehicleBlip);
		}
		// END SPAWN VEHICLE PART =====================================================================================================================================================

		// START CLIMB WHILE CARRYING PART ============================================================================================================================================
		if (isPlayerCarrying())
		{
			if (PAD::IS_CONTROL_JUST_RELEASED(22, key("INPUT_JUMP")))
			{
				TASK::_TASK_CLIMB_2(playerPed, 0);
			}
		}
		// END CLIMB WHILE CARRYING PART  =============================================================================================================================================
	
		// START VEHICLE INTERACTION PART =============================================================================================================================================
		Vector3 playerPos = ENTITY::GET_ENTITY_COORDS(playerPed, true, false); // variable for vehicle interaction part
		Vector3 myVehiclePos = { myVehiclePosX, myVehiclePosY, myVehiclePosZ};

		if (distanceBetween(playerPos, myVehiclePos) <= 6.0f) // only trigger when player near vehicle
		{
			Entity targetedVehicle{};

			VEHICLE::SET_VEHICLE_CAN_BE_TARGETTED(myVehicle, true);

			if (PLAYER::GET_PLAYER_TARGET_ENTITY(playerID, &targetedVehicle))
			{
				int targetedVehiclePromptGroup = HUD::_UIPROMPT_GET_GROUP_ID_FOR_TARGET_ENTITY(targetedVehicle);

				// start open and close trunk prompt
				HUD::_UIPROMPT_SET_GROUP(openTrunkPrompt, targetedVehiclePromptGroup, 0);
				HUD::_UIPROMPT_SET_GROUP(closeTrunkPrompt, targetedVehiclePromptGroup, 0);

				if (distanceBetween(playerPos, myVehiclePos) <= 2.5f)
				{
					togglePrompt(openTrunkPrompt, true, true);
					togglePrompt(closeTrunkPrompt, true, true);

					if (vehicleTrunkShut)
					{
						togglePrompt(openTrunkPrompt, true, true);
						togglePrompt(closeTrunkPrompt, true, false);
					}
					else
					{
						togglePrompt(openTrunkPrompt, true, false);
						togglePrompt(closeTrunkPrompt, true, true);
					}
				}
				else
				{
					togglePrompt(openTrunkPrompt, false, false);
					togglePrompt(closeTrunkPrompt, false, false);
				}

				if (HUD::_UIPROMPT_HAS_STANDARD_MODE_COMPLETED(openTrunkPrompt, 0)) vehicleTrunkShut = false;

				if (HUD::_UIPROMPT_HAS_STANDARD_MODE_COMPLETED(closeTrunkPrompt, 0)) vehicleTrunkShut = true;

				// end open and close trunk prompt

				// reset horse prompt
				HUD::_UIPROMPT_SET_GROUP(resetHorsePrompt, targetedVehiclePromptGroup, 0);

				if (isHorseAttached && distanceBetween(playerPos, myVehiclePos) <= 4.5f) togglePrompt(resetHorsePrompt, true, true);
				else togglePrompt(resetHorsePrompt, false, false);

				if (HUD::_UIPROMPT_HAS_HOLD_MODE_COMPLETED(resetHorsePrompt)) isHorseAttached = false;
			}

			int maxAttachedHorse = VEHICLE::_0x5B1A26BB18E7D451(ENTITY::GET_ENTITY_MODEL(myVehicle));

			Entity targetedHorse{};

			if (PLAYER::GET_PLAYER_TARGET_ENTITY(playerID, &targetedHorse))
			{
				if (PED::_IS_THIS_MODEL_A_HORSE(ENTITY::GET_ENTITY_MODEL(targetedHorse)))
				{
					int horsePromptGroup = HUD::_UIPROMPT_GET_GROUP_ID_FOR_TARGET_ENTITY(targetedHorse);
					HUD::_UIPROMPT_SET_GROUP(attachHorsePrompt, horsePromptGroup, 0);

					canShowAttachPrompt = (distanceBetween(playerPos, myVehiclePos) <= 4.5f && horseAttached < maxAttachedHorse) ? true: false;
				}

				(canShowAttachPrompt) ? togglePrompt(attachHorsePrompt, true, true): togglePrompt(attachHorsePrompt, false, false);
				
				if (HUD::_UIPROMPT_HAS_STANDARD_MODE_COMPLETED(attachHorsePrompt, 0))
				{
					isHorseAttached = true;
					VEHICLE::_0x316CDB5B6E8F4110(ENTITY::GET_PED_INDEX_FROM_ENTITY_INDEX(targetedHorse), myVehicle, horseAttached);
					horseAttached = horseAttached + 1;
				}
			}
		}
		else
		{
			togglePrompt(openTrunkPrompt, false, false);
			togglePrompt(closeTrunkPrompt, false, false);
			togglePrompt(attachHorsePrompt, false, false);
			togglePrompt(resetHorsePrompt, false, false);
			VEHICLE::SET_VEHICLE_CAN_BE_TARGETTED(myVehicle, false);
		}

		if (isHorseAttached && (PAD::IS_CONTROL_JUST_RELEASED(0, key("INPUT_INTERACT_LOCKON_DETACH_HORSE"))))
		{
			horseAttached = horseAttached - 1;
		}
		else if (horseAttached < 0) isHorseAttached = false;
		
		if (!isHorseAttached) horseAttached = 0;

		if (myVehicle)
		{
			if (vehicleTrunkShut)
			{
				VEHICLE::SET_VEHICLE_DOOR_SHUT(myVehicle, 5, false);
				VEHICLE::SET_VEHICLE_DOOR_SHUT(myVehicle, 6, false);
			}
			else
			{
				VEHICLE::SET_VEHICLE_DOOR_OPEN(myVehicle, 5, false, false);
				VEHICLE::SET_VEHICLE_DOOR_OPEN(myVehicle, 6, false, false);
				VEHICLE::SET_VEHICLE_DOOR_OPEN(myVehicle, 7, false, false);
			}
		}
		else
		{
			myVehicle = (currentVehicle) ? currentVehicle : VEHICLE::GET_CLOSEST_VEHICLE(playerPos.x, playerPos.y, playerPos.z, 10.0f ,myVehicleHash, 1);
		}
		// END VEHICLE INTERACTION PART =================================================================================================================================================
		WAIT(0);
	}
}

void ScriptMain()
{
	srand(static_cast<int>(GetTickCount64()));
	main();
}