SHIP_TYPE 		= "DROPSHIP"
COLOR_SELECTION = "PURPLE"

COLORS = 
{
	["BLACK"] 		= { ["R"]=0.0, ["G"]=0.0, ["B"]=0.0, ["A"]=1.0 },
	["PURPLE"] 		= { ["R"]=0.345, ["G"]=0.090, ["B"]=0.572, ["A"]=1.0 },
	["PINK"] 		= { ["R"]=1, ["G"]=0.0, ["B"]=1, ["A"]=1.0 },
	["DARKPRUPLE"] 	= { ["R"]=0.321, ["G"]=0.0, ["B"]=0.619, ["A"]=1.0 },
	["VIVIDGREEN"] 	= { ["R"]=0.0, ["G"]=0.639, ["B"]=0.274, ["A"]=1.0 },
	["HAPPYGREEN"] 	= { ["R"]=0.0, ["G"]=0.77, ["B"]=0.0, ["A"]=1.0 }
	["WHITE"] 		= { ["R"]=1.0, ["G"]=1.0, ["B"]=1.0, ["A"]=1.0 }
	["TRANSPARENT"] = { ["R"]=1.0, ["G"]=1.0, ["B"]=1.0, ["A"]=0.0 }
}

Palettes = {
	"Grass",
	"Plant",
	"Leaf",
	"Wood",
	"Rock",
	"Stone",
	"Crystal",
	"Sand",
	"Dirt",
	"Metal",
	"Paint",
	"Plastic",
	"Fur",
	"Scale",
	"Feather",
	"Water",
	"Cloud",
	"Sky",
	"Space",
	"Underbelly",
	"Undercoat",
	"Snow",
	"SkyHorizon",
	"SkyFog",
	"SkyHeightFog",
	"SkySunset",
	"SkyNight",
	"WaterNear",
	"SpaceCloud",
	"SpaceBottom",
	"SpaceSolar",
	"SpaceLight",
	"Warrior",
	"Scientific",
	"Trader",
	"WarriorAlt",
	"ScientificAlt",
	"TraderAlt",
	"RockSaturated",
	"RockLight",
	"RockDark",
	"PlanetRing",
	"Custom_Head",
	"Custom_Torso",
	"Custom_Chest_Armour",
	"Custom_Backpack",
	"Custom_Arms",
	"Custom_Hands",
	"Custom_Legs",
	"Custom_Feet",
	"Cave",
	"GrassAlt"
}

SHIP_TEXTURE_DEF_FILES =
{
	["FIGHTER"]=
	{
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPITACC_TOPFIN_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPITACC_TOPFIN_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A_NOSEB.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B_NOSEA.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A\COCKPIT_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B\COCKPIT_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINES_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINES_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINES_C.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINE_B\ENGINE_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINE_C\ENGINE_C.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\HULL\HULL_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEB\COCKPITA_NOSEB.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITB_NOSEA\COCKPITB_NOSEA.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\HQTRIM_PRIMARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\HQTRIM_SECONDARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\PRIMARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\SECONDARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\TERTIARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\TRIMS.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_B\SUBWINGS_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_D.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_E.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_F.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_G.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_H.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_I.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_J.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_K.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_L.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_M.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_A\WINGS_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_D\WINGS_D.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_E\WINGS_E.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_G\WINGS_G.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_I\WINGS_I.TEXTURE.MBIN",	
	},
	["DROPSHIP"]=
	{
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\COCKPIT\COCKPIT_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\COCKPIT\COCKPIT_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\DETAILKITS\DETAILKIT_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\ENGINE\ENGINE_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\ENGINE\ENGINE_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\HULL\HULL_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\HULL\HULL_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_C.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_D.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_E.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_F.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_G.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\THRUSTERS\THRUSTERS_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\THRUSTERS\THRUSTERS_B.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\THRUSTERS\THRUSTERS_C.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\WINGS\WINGS_A.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\WINGS\WINGS_B.TEXTURE.MBIN",	
	},
	["SCIENTIFIC"]=
	{
		"TEXTURES\COMMON\SPACECRAFT\SCIENTIFIC\SHARED\SCIENTIFIC.TEXTURE.MBIN",
	},
	["SHUTTLE"]=
	{
		"TEXTURES\COMMON\SPACECRAFT\SHUTTLE\SHARED\SHUTTLE.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\SHUTTLE\SHARED\SHUTTLEDECALSHEET.TEXTURE.MBIN",	
	},
	["EXOTIC"]=
	{
		"TEXTURES\COMMON\SPACECRAFT\S-CLASS\DETAILS.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\S-CLASS\GLOWINGCOREPROC.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\S-CLASS\ROYALSCLASS_TRIM.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\S-CLASS\SQUIDSCLASS_TRIM.TEXTURE.MBIN",	
	},
	["ALL"]=
	{
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\HQTRIM_PRIMARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\HQTRIM_SECONDARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\PRIMARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\SECONDARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\TERTIARY.TEXTURE.MBIN",
		"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\TRIMS.TEXTURE.MBIN",
	},
}

NMS_MOD_DEFINITION_CONTAINER = 
{
["MOD_FILENAME"] 			= "CustomShipColor-" .. SHIP_TYPE .. "-" .. COLOR_SELECTION .. ".pak",
["MOD_AUTHOR"]				= "Mjjstral",
["MOD_DESCRIPTION"]			= "Exchange the ship color",
["NMS_VERSION"]				= "2.0+",
["MODIFICATIONS"] 			= 
	{
		{
			["PAK_FILE_SOURCE"] 	= "NNMSARC.515F1D3.pak",
			["MBIN_CHANGE_TABLE"] 	= 
			{
				{
					["MBIN_FILE_SOURCE"] 	= SHIP_TEXTURE_DEF_FILES["ALL"],
					["EXML_CHANGE_TABLE"] 	= 
					{
						{
							["REPLACE_TYPE"] 		= "ALL",
							["VALUE_CHANGE_TABLE"] 	= 
							{
								--{"SelectToMatchBase", "True"},
								--{"Palette", "Grass"},
								{"OverrideAverageColour", "True"},
								{"R", COLORS[COLOR_SELECTION]["R"]},
								{"G", COLORS[COLOR_SELECTION]["G"]},
								{"B", COLORS[COLOR_SELECTION]["B"]},
								{"A", COLORS[COLOR_SELECTION]["A"]},
							}
						}
					}
				}				
			}
		}
	}
}