CustomPaletteName = "CustomShipPalette"


Palettes = {
	"Grass",
	"Plant",
	"Leaf",
	"Wood",
	"Rock",
	"Stone",
	"Crystal",
	"Sand",
	"Dirt",
	"Metal",
	"Paint",
	"Plastic",
	"Fur",
	"Scale",
	"Feather",
	"Water",
	"Cloud",
	"Sky",
	"Space",
	"Underbelly",
	"Undercoat",
	"Snow",
	"SkyHorizon",
	"SkyFog",
	"SkyHeightFog",
	"SkySunset",
	"SkyNight",
	"WaterNear",
	"SpaceCloud",
	"SpaceBottom",
	"SpaceSolar",
	"SpaceLight",
	"Warrior",
	"Scientific",
	"Trader",
	"WarriorAlt",
	"ScientificAlt",
	"TraderAlt",
	"RockSaturated",
	"RockLight",
	"RockDark",
	"PlanetRing",
	"Custom_Head",
	"Custom_Torso",
	"Custom_Chest_Armour",
	"Custom_Backpack",
	"Custom_Arms",
	"Custom_Hands",
	"Custom_Legs",
	"Custom_Feet",
	"Cave",
	"GrassAlt"
}

UsedPalettes = {
	["SHIP"] = "Rock"
}

Color = 
{
	["BLACK"] 	= { ["R"]=0.0, ["G"]=0.0, ["B"]=0.0, ["A"]=1.0 },
	["PURPLE"] 	= { ["R"]=0.0, ["G"]=0.1, ["B"]=0.0, ["A"]=1.0 }	
}


function GetColor(Color_)
return [[
        <Property value="Colour.xml">
          <Property name="R" value="]] .. Color_["R"] .. [[" />
          <Property name="G" value="]] .. Color_["G"] .. [[" />
          <Property name="B" value="]] .. Color_["B"] .. [[" />
          <Property name="A" value="]] .. Color_["A"] .. [[" />
        </Property>
]]
end

function CreateCustomPallete(PaletteName, ColorTable)
	local Palette = 
[[
    <Property name="]] .. PaletteName .. [[" value="GcPaletteData.xml">
      <Property name="NumColours" value="_4" />
      <Property name="Colours">
]]
	for i=1,#ColorTable,1 do
		Palette = Palette .. GetColor(ColorTable[i])
	end
Palette = Palette .. 
[[
      </Property>
    </Property>	
]]
	return Palette
end


PALLETTE = CreateCustomPallete(CustomPaletteName, ColorTable)


CustomShipPalette = 
[[
    <Property name="Rock" value="GcPaletteData.xml">
      <Property name="NumColours" value="_4" />
      <Property name="Colours">
        <Property value="Colour.xml">
          <Property name="R" value="0.329" />
          <Property name="G" value="0.318" />
          <Property name="B" value="0.31" />
          <Property name="A" value="1" />
        </Property>
      </Property>
    </Property>	
]]


NMS_MOD_DEFINITION_CONTAINER = 
{
["MOD_FILENAME"] 			= "CustomShipColorPalette.pak",
["MOD_AUTHOR"]				= "Mjjstral",
["MOD_DESCRIPTION"]			= "Exchange choosen ship colors",
["NMS_VERSION"]				= "2.0+",
["MODIFICATIONS"] 			= 
	{
		{
			["PAK_FILE_SOURCE"] 	= "NNMSARC.515F1D3.pak",
			["MBIN_CHANGE_TABLE"] 	= 
			{
				{
					["MBIN_FILE_SOURCE"] 	= 
					{
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\COCKPIT\COCKPIT_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\COCKPIT\COCKPIT_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\DETAILKITS\DETAILKIT_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\ENGINE\ENGINE_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\ENGINE\ENGINE_B.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\HULL\HULL_A.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\HULL\HULL_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_C.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_D.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_E.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_F.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\SUBWINGS\SUBWINGS_G.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\THRUSTERS\THRUSTERS_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\THRUSTERS\THRUSTERS_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\DROPSHIP\THRUSTERS\THRUSTERS_C.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\WINGS\WINGS_A.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\DROPSHIP\WINGS\WINGS_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPITACC_TOPFIN_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPITACC_TOPFIN_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A_NOSEB.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B_NOSEA.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_A\COCKPIT_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\COCKPIT\COCKPIT_B\COCKPIT_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINES_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINES_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINES_C.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINE_B\ENGINE_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\ENGINES\ENGINE_C\ENGINE_C.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\HULL\HULL_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITA_NOSEB\COCKPITA_NOSEB.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\NOSE\COCKPITB_NOSEA\COCKPITB_NOSEA.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\HQTRIM_PRIMARY.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\HQTRIM_SECONDARY.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\PRIMARY.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\SECONDARY.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\TERTIARY.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SHARED\TRIMS.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\SUBWINGS\SUBWINGS_B\SUBWINGS_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_B.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_D.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_E.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_F.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_G.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_H.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_I.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_J.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_K.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_L.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_M.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_A\WINGS_A.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_D\WINGS_D.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_E\WINGS_E.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_G\WINGS_G.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FIGHTERS\WINGS\WINGS_I\WINGS_I.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FRIGATES\SURFDETAIL.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\FRIGATES\WARRIORTILED.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\INDUSTRIAL\SHARED\FREIGHTER_PROC.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\INDUSTRIAL\SHARED\DECALS\SMALL_STRIPES.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\INDUSTRIAL\SHARED\DECALS\STRIPE_SINGLE.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\S-CLASS\DETAILS.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\S-CLASS\GLOWINGCOREPROC.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\S-CLASS\ROYALSCLASS_TRIM.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\S-CLASS\SQUIDSCLASS_TRIM.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\SCIENTIFIC\SHARED\SCIENTIFIC.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\SHARED\ENGINEGLOWPROC.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\SHARED\COCKPITINTERIORS\PLASTICGRAIN.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\SHARED\DECALS\DECALPAINT.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\SHARED\DECALS\LOGO.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\SHARED\DECALS\PATTERNS.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\SHARED\DECALS\SMALLDECAL.TEXTURE.MBIN",
						"TEXTURES\COMMON\SPACECRAFT\SHUTTLE\SHARED\SHUTTLE.TEXTURE.MBIN",
						-- "TEXTURES\COMMON\SPACECRAFT\SHUTTLE\SHARED\SHUTTLEDECALSHEET.TEXTURE.MBIN"					
					}
					["EXML_CHANGE_TABLE"] 	= 
					{
						{
							["REPLACE_TYPE"] 		= "ALL",
							["VALUE_MATCH"] 		= "Rock",
							["VALUE_CHANGE_TABLE"] 	= 
							{
								{"Palette",		CustomPaletteName},				
							}
						}
					}
				},
				{
					["MBIN_FILE_SOURCE"] 	= 
					{
						"METADATA\SIMULATION\SOLARSYSTEM\COLOURS\BASECOLOURPALETTES.MBIN",
						"METADATA\SIMULATION\SOLARSYSTEM\COLOURS\LEGACYBASECOLOURPALETTES.MBIN"
					}
					["EXML_CHANGE_TABLE"] 	= 
					{
						{
							["PRECEDING_KEY_WORDS"] = { "Palettes" },
							["LINE_OFFSET"] 		= "+0",
							["ADD"] 				= PALLETTE
						}
					}
				}				
			}
		}
	}
}


