//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Enable more creatures to become companion pets.
	public class Creature_Pet : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			TkAttachmentData();
		}

		//...........................................................
		
		protected void TkAttachmentData()
		{
			// get non-cached existing interaction data to use as cloning source
			var mbin = Game.PAK.Mbin<mbin_tk.TkAttachmentData>(false,
				"MODELS/PLANETS/CREATURES/ANTELOPERIG/ANTELOPE/ENTITIES/_BODY_SKINNY.ENTITY.MBIN",
				Log
			);
			var source = mbin.Components.FindFirstAs<mbin_gc.GcInteractionComponentData>();		
			source.InteractDistance = 40;
			
			foreach( var info in Game.PAK.FindInfoEndsWith(".ENTITY.MBIN", Cancel) ) {
				// before extracting mbins, do coarse filter using path
				var  is_robot  =  info.Path.Contains("ROBOT") || info.Path.Contains("CYBER");
				if( !is_robot && !info.Path.Contains("CREATURE") ) continue;
				
				// get a non-cached instance, since we don't know if we want to mod it
				mbin = info.Mbin<mbin_tk.TkAttachmentData>(Log);
				if( mbin == null ) continue;
				
				// make sure entity is for a creature ...
				var creature  = mbin.Components.FindFirstAs<mbin_gc.GcCreatureComponentData>();
				if( creature == null ) continue;
					
				// ... and that the creature isn't already able to be a pet
				var interaction  = mbin.Components.FindFirstAs<mbin_gc.GcInteractionComponentData>();
				if( interaction != null ) continue;
	
				// what do we need to feed it
				source.SecondaryActivationCost.SubstanceId = is_robot ? 
					"POWERCELL" : "BAIT_BASIC"
				;
				
				// now that we know we want to mod it, get a cached instance
				mbin = Mbin<mbin_tk.TkAttachmentData>(info.Path);				
				mbin.Components.Add(source.Clone());
			}
			
			string [] paths = new [] {
				"MODELS/PLANETS/CREATURES/BEETLERIG/BEETLE/ENTITIES/BEETLEDATA.ENTITY.MBIN",
				"MODELS/PLANETS/CREATURES/BUTTERFLYRIG/LARGEBUTTERFLY/ENTITIES/LARGEBUTTERFLYDATA.ENTITY.MBIN",
				"MODELS/PLANETS/CREATURES/WEIRD/ROLLERCREATURE/ENTITIES/_STRANGE_ROLL.ENTITY.MBIN",
				"MODELS/PLANETS/CREATURES/WEIRD/WEIRDRIG/ENTITIES/WEIRDFLOAT.ENTITY.MBIN",
				"MODELS/PLANETS/CREATURES/WEIRD/WEIRDRIG/ENTITIES/WEIRDROLL.ENTITY.MBIN",
			};		
			foreach( var path in paths ) {
				mbin = Mbin<mbin_tk.TkAttachmentData>(path);				
				var interaction = mbin.Components.FindFirstAs<mbin_gc.GcInteractionComponentData>();
				interaction.RepeatInteraction = false;
				interaction.UseInteractCamera = false;
			}
		}
	}
}

//=============================================================================
