//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	using SizeTypeEnum = mbin_gc.GcInventoryLayoutSizeType.SizeTypeEnum;
	
	//=========================================================================

	public class Inventory : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcPlayerGlobals();
			GcGameplayGlobals();
			GcInventoryStoreBalance();
			GcInventoryTable();
			GcDefaultSaveData();
		}

		//...........................................................

		public static int MaxAmount { get; set; } = 100000;
			
		//...........................................................

		protected void GcPlayerGlobals()
		{
			var mbin = Mbin<mbin_gl.GcPlayerGlobals>(
				"GCPLAYERGLOBALS.GLOBAL.MBIN"
			);
			mbin.LuckyWithTech          = true;  // max stats for every upgrade
			mbin.ChanceHighGradeIllegal = 15;    // 10, useless if LuckyWithTech
		}
		
		//...........................................................
		
		protected void GcGameplayGlobals()
		{
			var mbin = Mbin<mbin_gl.GcGameplayGlobals>(
				"GCGAMEPLAYGLOBALS.GLOBAL.MBIN"
			);
			mbin.MaxNumSameGroupTech = 4;  // 3, overload warning if exceed this
		}

		//...........................................................

		protected void GcInventoryStoreBalance()
		{
			var mbin = Mbin<mbin_gc.GcInventoryStoreBalance>(
				"METADATA/GAMESTATE/DEFAULTINVENTORYBALANCE.MBIN"
			);
	
			mbin.DeconstructRefundPercentage = 0.8f; // 0.5

			mbin.PlayerPersonalInventoryTechWidth   = 8;  // 7
			mbin.PlayerPersonalInventoryTechHeight  = 3;  // 2
			mbin.PlayerPersonalInventoryCargoWidth  = 8;  // 8
			mbin.PlayerPersonalInventoryCargoHeight = 6;  // 6
		
			// it seems substance and product amounts work in opposite ways:
			// - substances use a default max amount = x, and a mult = 1.
			// - products   use a default max amount = 1, and a mult = x.
			// trying to use the same method for products as for substances
			// can lead to things not being buildable, even w/ enough material to build.
			
			mbin.SubstanceMaxAmountLimit               = MaxAmount;  // 9999
			mbin.DefaultSubstanceMaxAmount             = MaxAmount;  // 9999
			mbin.DefaultSubstanceStorageMultiplier     = 1;  // 1
			mbin.CargoSubstanceStorageMultiplier       = 1;  // 1
			mbin.ShipSubstanceStorageMultiplier        = 1;  // 1
			mbin.FreighterSubstanceStorageMultiplier   = 1;  // 1
			mbin.ChestSubstanceStorageMultiplier       = 1;  // 1
			mbin.BaseCapsuleSubstanceStorageMultiplier = 1;  // 1
			GcSubstanceTable(1);

			// used to set *StorageMultiplier's = MaxAmount,
			// but game no longer propagates them to corresponding storage,
			// so we now set = 1 and set Multiplier for each product = MaxAmount.
			// not ideal, won't handle any new products added by mods.
			mbin.ProductMaxAmountLimit                 = MaxAmount;  // 9999
			mbin.DefaultProductMaxAmount               = 1;  //   1
			mbin.DefaultProductStorageMultiplier       = 1;  //   5
			mbin.CargoProductStorageMultiplier         = 1;  //  10
			mbin.ShipProductStorageMultiplier          = 1;  //   5
			mbin.FreighterProductStorageMultiplier     = 1;  //  10
			mbin.ChestProductStorageMultiplier         = 1;  //  20
			mbin.BaseCapsuleProductStorageMultiplier   = 1;  // 100
			GcProductTable(MaxAmount);
		}

		//...........................................................
		
		protected void GcSubstanceTable( int STACK_MULTIPLIER )
		{
			var mbin = Mbin<mbin_gc.GcSubstanceTable>(
				"METADATA/REALITY/TABLES/NMS_REALITY_GCSUBSTANCETABLE.MBIN"
			);
			foreach( var substance in mbin.Table ) {
				if( substance.StackMultiplier > 0 ) substance.StackMultiplier = STACK_MULTIPLIER;
			}
		}
		
		//...........................................................
		
		protected void GcProductTable( int STACK_MULTIPLIER )
		{
			var mbin = Mbin<mbin_gc.GcProductTable>(
				"METADATA/REALITY/TABLES/NMS_REALITY_GCPRODUCTTABLE.MBIN"
			);
			foreach( var product in mbin.Table ) {
				if( product.StackMultiplier > 0 ) product.StackMultiplier = STACK_MULTIPLIER;
			}
		}
		
		//...........................................................
		
		protected void GcInventoryTable()
		{
			var mbin = Mbin<mbin_gc.GcInventoryTable>(
				"METADATA/REALITY/TABLES/INVENTORYTABLE.MBIN"
			);
			var data = mbin.GenerationData.GenerationDataPerSizeType;
			data[(int)SizeTypeEnum.ChestLarge].MinSlots = 40;  // 20
			data[(int)SizeTypeEnum.ChestLarge].MaxSlots = 40;  // 20			
		}

		//...........................................................

		protected void GcDefaultSaveData()
		{
			string [] paths = new [] {
				"METADATA/GAMESTATE/DEFAULTSAVEDATA.MBIN",
				"METADATA/GAMESTATE/DEFAULTSAVEDATACREATIVE.MBIN"
			};
			foreach( var path in paths ) {
				var mbin = Mbin<mbin_gc.GcDefaultSaveData>(path);
				GcInventory(mbin.State.Chest1Layout, mbin.State.Chest1Inventory);
				GcInventory(mbin.State.Chest2Layout, mbin.State.Chest2Inventory);
				GcInventory(mbin.State.Chest3Layout, mbin.State.Chest3Inventory);
				GcInventory(mbin.State.Chest4Layout, mbin.State.Chest4Inventory);
				GcInventory(mbin.State.Chest5Layout, mbin.State.Chest5Inventory);
				GcInventory(mbin.State.Chest6Layout, mbin.State.Chest6Inventory);
				GcInventory(mbin.State.Chest7Layout, mbin.State.Chest7Inventory);
				GcInventory(mbin.State.Chest8Layout, mbin.State.Chest8Inventory);
				GcInventory(mbin.State.Chest9Layout, mbin.State.Chest9Inventory);
				GcInventory(mbin.State.Chest10Layout, mbin.State.Chest10Inventory);	
			}
		}

		//...........................................................

		// resizing no longer works, but can still add starting items to these inventories.
		protected void GcInventory( mbin_gc.GcInventoryLayout LAYOUT, mbin_gc.GcInventoryContainer INVENTORY )
		{	
			#if false  // these are being ignored
				INVENTORY.SubstanceMaxStorageMultiplier = 1;
				INVENTORY.ProductMaxStorageMultiplier   = 1;
				INVENTORY.Width  = 8;
				INVENTORY.Height = 5;
				//for( var row = 0; row < INVENTORY.Height; ++row ) {
				//	for( var col = 0; col < INVENTORY.Width; ++col ) {
				//		INVENTORY.ValidSlotIndices.Add(new mbin_gc.GcInventoryIndex{ X = col, Y = row });
				//	}
				//}
			#endif
			// used to work, now stored in save file, but not propagated to INVENTORY
			LAYOUT.Slots = 40;  //INVENTORY.Width * INVENTORY.Height;
		}
	}
}

//=============================================================================
