//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Adjust timings for notifications.
	// Hide lower-right notification UI.
	public class Notification : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcUIGlobals();
			GcNGuiLayerData();
		}

		//...........................................................

		protected void GcUIGlobals()
		{
			var mbin = Mbin<mbin_gl.GcUIGlobals>(
				"GCUIGLOBALS.GLOBAL.MBIN"
			);

			// throwing darts, hopefully something works
			var time = 1f;
			
			mbin.DiscoveryHelperTimings.DiscoverPlanetTotalTime   = time;  // 10
			mbin.DiscoveryHelperTimings.DiscoverPlanetMessageWait = time;  //  1
			mbin.DiscoveryHelperTimings.DiscoverPlanetMessageTime = time;  //  7

			mbin.MilestoneStingDisplayTime  = time;  // 6
			mbin.StageStingDisplayTime      = time;  // 6
			mbin.HUDDisplayTime             = time;  // 6
			mbin.StatsMessageDelayTime      = time;  // 12
			mbin.NotificationMinVisibleTime = time;  // 3
			mbin.MessageNotificationTime    = time;  // 12
			mbin.MessageTimeQuick           = time;  // 6

			// don't seem to be used
			mbin.DistanceUnitM   =  "m";    // "u"
			mbin.DistanceUnitKM  = "km";    // "ks"
			mbin.DistanceUnitMpS =  "m/s";  // "u/s"
		}

		//...........................................................

		protected void GcNGuiLayerData()
		{
			var mbin = Mbin<mbin_gc.GcNGuiLayerData>(
				"UI/HUD/HUDNOTIFICATIONPANEL.MBIN"
			);		
			// hide all lower-right notification ui elements
			var notify = mbin.Children.FindFirstAs<mbin_gc.GcNGuiLayerData>(CHILD => 			
				CHILD.ElementData.ID == "LOWER_NOTIFY"
			);
			foreach( var child in notify.Children ) {
				     if( child is mbin_gc.GcNGuiLayerData   layer   ) layer  .ElementData.IsHidden = true;
				else if( child is mbin_gc.GcNGuiTextData    text    ) text   .ElementData.IsHidden = true;
				else if( child is mbin_gc.GcNGuiGraphicData graphic ) graphic.ElementData.IsHidden = true;
			}
		}
	}
}

//=============================================================================
