//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	using CompletionRequirementEnum = mbin_gc.GcMaintenanceElement.CompletionRequirementEnum;
	
	//=========================================================================
	
	public class Portal: cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcGameplayGlobals();
			TkAttachmentData();
		}

		//...........................................................

		protected void GcGameplayGlobals()
		{
			var mbin = Mbin<mbin_gl.GcGameplayGlobals>(
				"GCGAMEPLAYGLOBALS.GLOBAL.MBIN"
			);
			// know all portal glyphs, see Start.
			mbin.Portal.KnowAllRunes = true;
		}
		
		//...........................................................

		protected void TkAttachmentData()
		{
			var mbin = Mbin<mbin_tk.TkAttachmentData>(
				"MODELS/PLANETS/BIOMES/COMMON/BUILDINGS/PORTAL/PORTAL/ENTITIES/BUTTON.ENTITY.MBIN"
			);
			// make all portal buttons free (don't need to charge w/ substances)
			var maint = mbin.Components.FindFirstAs<mbin_gc.GcMaintenanceComponentData>();
			foreach( var button in maint.PreInstalledTech ) {
				button.MaxCapactiy           = 0;  // -1, some report this no longer works ...
				button.CompletionRequirement = CompletionRequirementEnum.NoRequirement;  // ... but that this does
			}
		}
	}
}

//=============================================================================
